/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.handlers.relative.DependencyGraph;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponent
implements NlAttributesHolder {
    @Nullable
    private XmlModelComponentMixin myMixin;
    @Nullable
    public List<NlComponent> children;
    private NlComponent myParent;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private XmlTag myTag;
    @NotNull
    private String myTagName;
    @Nullable
    private TagSnapshot mySnapshot;
    final HashMap<Object, Object> myClientProperties;
    private final ListenerCollection<ChangeListener> myListeners;
    private final ChangeEvent myChangeEvent;
    private DependencyGraph myCachedDependencyGraph;
    @Nullable
    AttributesTransaction myCurrentTransaction;

    public NlComponent(@NotNull NlModel model, @NotNull XmlTag tag) {
        if (model == null) {
            NlComponent.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(1);
        }
        this.myClientProperties = new HashMap();
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myChangeEvent = new ChangeEvent(this);
        this.myModel = model;
        this.myTag = tag;
        this.myTagName = tag.getName();
    }

    public void setMixin(@NotNull XmlModelComponentMixin mixin) {
        if (mixin == null) {
            NlComponent.$$$reportNull$$$0(2);
        }
        assert (this.myMixin == null);
        this.myMixin = mixin;
    }

    @Nullable
    public XmlModelComponentMixin getMixin() {
        return this.myMixin;
    }

    @NotNull
    public XmlTag getTag() {
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            NlComponent.$$$reportNull$$$0(3);
        }
        return xmlTag;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            NlComponent.$$$reportNull$$$0(4);
        }
        return nlModel;
    }

    public void setTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(5);
        }
        this.myTag = tag;
        this.myTagName = tag.getName();
    }

    @Nullable
    public TagSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    public void setSnapshot(@Nullable TagSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public void addChild(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlComponent.$$$reportNull$$$0(6);
        }
        this.addChild(component2, null);
    }

    public void addChild(@NotNull NlComponent component2, @Nullable NlComponent before) {
        int index;
        if (component2 == null) {
            NlComponent.$$$reportNull$$$0(7);
        }
        if (component2 == this) {
            throw new IllegalArgumentException();
        }
        if (this.children == null) {
            this.children = Lists.newArrayList();
        }
        int n = index = before != null ? this.children.indexOf(before) : -1;
        if (index != -1) {
            this.children.add(index, component2);
        } else {
            this.children.add(component2);
        }
        component2.setParent(this);
    }

    public void removeChild(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlComponent.$$$reportNull$$$0(8);
        }
        if (component2 == this) {
            throw new IllegalArgumentException();
        }
        if (this.children != null) {
            this.children.remove(component2);
        }
        component2.setParent(null);
    }

    public void setChildren(@Nullable List<NlComponent> components) {
        this.children = components;
        if (components != null) {
            for (NlComponent component2 : components) {
                if (component2 == this) {
                    throw new IllegalArgumentException();
                }
                component2.setParent(this);
            }
        }
    }

    @NotNull
    public List<NlComponent> getChildren() {
        List<NlComponent> list = this.children != null ? this.children : Collections.emptyList();
        if (list == null) {
            NlComponent.$$$reportNull$$$0(9);
        }
        return list;
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Nullable
    public NlComponent getChild(int index) {
        return this.children != null && index >= 0 && index < this.children.size() ? this.children.get(index) : null;
    }

    @NotNull
    public Stream<NlComponent> flatten() {
        Stream<NlComponent> stream = Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(NlComponent::flatten));
        if (stream == null) {
            NlComponent.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @NotNull
    public DependencyGraph getDependencyGraph() {
        if (this.myCachedDependencyGraph == null || this.myCachedDependencyGraph.isStale(this)) {
            this.myCachedDependencyGraph = new DependencyGraph(this);
        }
        DependencyGraph dependencyGraph = this.myCachedDependencyGraph;
        if (dependencyGraph == null) {
            NlComponent.$$$reportNull$$$0(11);
        }
        return dependencyGraph;
    }

    @Nullable
    public NlComponent getNextSibling() {
        if (this.myParent == null) {
            return null;
        }
        for (int index = 0; index < this.myParent.getChildCount(); ++index) {
            if (this.myParent.getChild(index) != this) continue;
            return this.myParent.getChild(index + 1);
        }
        return null;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(12);
        }
        if (this.myTag == tag) {
            return this;
        }
        for (NlComponent child : this.getChildren()) {
            NlComponent result = child.findViewByTag(tag);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void findViewsByTag(@NotNull XmlTag tag, @NotNull ImmutableList.Builder<NlComponent> builder) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            NlComponent.$$$reportNull$$$0(14);
        }
        if (this.children == null && this.myTag == tag) {
            builder.add((Object)this);
            return;
        }
        for (NlComponent child : this.getChildren()) {
            child.findViewsByTag(tag, builder);
        }
        if (this.myTag == tag) {
            builder.add((Object)this);
        }
    }

    @NotNull
    public ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlComponent.$$$reportNull$$$0(15);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        this.findViewsByTag(tag, (ImmutableList.Builder<NlComponent>)builder);
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            NlComponent.$$$reportNull$$$0(16);
        }
        return immutableList;
    }

    public boolean isRoot() {
        return !(this.myTag.getParent() instanceof XmlTag);
    }

    public NlComponent getRoot() {
        NlComponent component2;
        for (component2 = this; component2 != null && !component2.isRoot(); component2 = component2.getParent()) {
        }
        return component2;
    }

    @Nullable
    public String getId() {
        String id = this.myCurrentTransaction != null ? this.myCurrentTransaction.getAndroidAttribute("id") : this.getAndroidAttribute("id");
        return NlComponent.stripId(id);
    }

    @Nullable
    public static String stripId(@Nullable String id) {
        if (id != null) {
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    public static Collection<String> getIds(@NotNull NlModel model) {
        if (model == null) {
            NlComponent.$$$reportNull$$$0(17);
        }
        AndroidFacet facet = model.getFacet();
        AppResourceRepository resources = AppResourceRepository.getOrCreateInstance(facet);
        ArrayList ids = resources.getItemsOfType(ResourceType.ID);
        Set<String> pendingIds = model.getPendingIds();
        if (!pendingIds.isEmpty()) {
            ArrayList all = Lists.newArrayListWithCapacity((int)(pendingIds.size() + ids.size()));
            all.addAll(ids);
            all.addAll(pendingIds);
            ids = all;
        }
        return ids;
    }

    @Nullable
    public NlComponent getParent() {
        return this.myParent;
    }

    private void setParent(@Nullable NlComponent parent) {
        this.myParent = parent;
    }

    @NotNull
    public String getTagName() {
        String string = this.myTagName;
        if (string == null) {
            NlComponent.$$$reportNull$$$0(18);
        }
        return string;
    }

    public String toString() {
        if (this.getMixin() != null) {
            return this.getMixin().toString();
        }
        return String.format("<%s>", this.myTagName);
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value) {
        String previous;
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(19);
        }
        if (!this.myTag.isValid()) {
            return;
        }
        String prefix = null;
        if (namespace != null && !"http://schemas.android.com/apk/res/android".equals(namespace)) {
            prefix = AndroidResourceUtil.ensureNamespaceImported((XmlFile)this.myTag.getContainingFile(), namespace, null);
        }
        if (Objects.equals(previous = this.getAttribute(namespace, attribute), value)) {
            return;
        }
        this.myTag.setAttribute(attribute, namespace, value);
        if (this.mySnapshot != null) {
            this.mySnapshot.setAttribute(attribute, namespace, prefix, value);
        }
    }

    @NotNull
    public AttributesTransaction startAttributeTransaction() {
        if (this.myCurrentTransaction == null) {
            this.myCurrentTransaction = new AttributesTransaction(this);
        }
        AttributesTransaction attributesTransaction = this.myCurrentTransaction;
        if (attributesTransaction == null) {
            NlComponent.$$$reportNull$$$0(20);
        }
        return attributesTransaction;
    }

    @Nullable
    public String getLiveAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(21);
        }
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        return this.getAttribute(namespace, attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(22);
        }
        if (this.mySnapshot != null) {
            return this.mySnapshot.getAttribute(attribute, namespace);
        }
        if (AndroidPsiUtils.isValid(this.myTag)) {
            return AndroidPsiUtils.getAttributeSafely(this.myTag, namespace, attribute);
        }
        return null;
    }

    @Nullable
    public String resolveAttribute(@NotNull String namespace, @NotNull String attribute) {
        String attributeValue;
        if (namespace == null) {
            NlComponent.$$$reportNull$$$0(23);
        }
        if (attribute == null) {
            NlComponent.$$$reportNull$$$0(24);
        }
        if ((attributeValue = this.getAttribute(namespace, attribute)) != null) {
            return attributeValue;
        }
        String styleAttributeValue = this.getAttribute(null, "style");
        if (styleAttributeValue == null) {
            return null;
        }
        ResourceResolver resources = this.myModel.getConfiguration().getResourceResolver();
        if (resources == null) {
            return null;
        }
        ResourceValue tmpResourceValue = new ResourceValue(ResourceUrl.create(null, (ResourceType)ResourceType.STYLE, (String)this.myTagName), styleAttributeValue);
        ResourceValue styleResourceValue = resources.resolveResValue(tmpResourceValue);
        if (!(styleResourceValue instanceof StyleResourceValue)) {
            return null;
        }
        ResourceValue itemResourceValue = resources.findItemInStyle((StyleResourceValue)styleResourceValue, attribute, true);
        if (itemResourceValue == null) {
            return null;
        }
        return itemResourceValue.getValue();
    }

    @NotNull
    public List<AttributeSnapshot> getAttributes() {
        if (this.mySnapshot != null) {
            List<AttributeSnapshot> list = this.mySnapshot.attributes;
            if (list == null) {
                NlComponent.$$$reportNull$$$0(25);
            }
            return list;
        }
        if (this.myTag.isValid()) {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                List list = (List)application.runReadAction(() -> AttributeSnapshot.createAttributesForTag(this.myTag));
                if (list == null) {
                    NlComponent.$$$reportNull$$$0(26);
                }
                return list;
            }
            List<AttributeSnapshot> list = AttributeSnapshot.createAttributesForTag(this.myTag);
            if (list == null) {
                NlComponent.$$$reportNull$$$0(27);
            }
            return list;
        }
        List<AttributeSnapshot> list = Collections.emptyList();
        if (list == null) {
            NlComponent.$$$reportNull$$$0(28);
        }
        return list;
    }

    public String ensureNamespace(@NotNull String prefix, @NotNull String namespace) {
        if (prefix == null) {
            NlComponent.$$$reportNull$$$0(29);
        }
        if (namespace == null) {
            NlComponent.$$$reportNull$$$0(30);
        }
        return AndroidResourceUtil.ensureNamespaceImported((XmlFile)this.myTag.getContainingFile(), namespace, prefix);
    }

    public boolean isShowing() {
        return this.mySnapshot != null;
    }

    @Nullable
    public static String extractId(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf("@id/");
        if (index != -1) {
            return str.substring(index + 4);
        }
        index = str.lastIndexOf("@+id/");
        if (index != -1) {
            return str.substring(index + 5);
        }
        return null;
    }

    public final void putClientProperty(Object key, Object value) {
        this.myClientProperties.put(key, value);
    }

    public final Object getClientProperty(Object key) {
        return this.myClientProperties.get(key);
    }

    public final Object removeClientProperty(Object key) {
        return this.myClientProperties.remove(key);
    }

    public void addLiveChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    public void removeLiveChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void fireLiveChangeEvent() {
        this.myListeners.forEach(listener -> listener.stateChanged(this.myChangeEvent));
    }

    @NotNull
    public String assignId() {
        String string = this.assignId(this.getTagName());
        if (string == null) {
            NlComponent.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public String assignId(@NotNull String baseName) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(32);
        }
        String string = this.assignId(baseName, NlComponent.getIds(this.getModel()));
        if (string == null) {
            NlComponent.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public String assignId(@NotNull Collection<String> ids) {
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(34);
        }
        String string = this.assignId(this.getTagName(), ids);
        if (string == null) {
            NlComponent.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public String assignId(@NotNull String baseName, @NotNull Collection<String> ids) {
        if (baseName == null) {
            NlComponent.$$$reportNull$$$0(36);
        }
        if (ids == null) {
            NlComponent.$$$reportNull$$$0(37);
        }
        String idValue = StringUtil.decapitalize((String)baseName.substring(baseName.lastIndexOf(46) + 1));
        Module module = this.getModel().getModule();
        Project project = module.getProject();
        String nextIdValue = idValue = ResourceHelper.prependResourcePrefix(module, idValue, ResourceFolderType.LAYOUT);
        int index = 0;
        NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        while (ids.contains(nextIdValue) || validator != null && validator.isKeyword(nextIdValue, project)) {
            if (!(++index != 1 || validator != null && validator.isKeyword(nextIdValue, project))) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + index;
        }
        String newId = idValue + (index == 0 ? "" : Integer.valueOf(index));
        NlAttributesHolder attributes = this.myCurrentTransaction == null ? this : this.myCurrentTransaction;
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + newId);
        this.getModel().getPendingIds().add(newId);
        String string = newId;
        if (string == null) {
            NlComponent.$$$reportNull$$$0(38);
        }
        return string;
    }

    public boolean isSelected() {
        return this.getModel().getSelectionModel().isSelected(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mixin";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/NlComponent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/NlComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyGraph";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewsByTag";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "startAttributeTransaction";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "assignId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setMixin";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 38: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTag";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findViewByTag";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findViewsByTag";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIds";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLiveAttribute";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveAttribute";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "ensureNamespace";
                break;
            }
            case 32: 
            case 34: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "assignId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class XmlModelComponentMixin {
        private final NlComponent myComponent;

        public XmlModelComponentMixin(@NotNull NlComponent component2) {
            if (component2 == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(0);
            }
            this.myComponent = component2;
        }

        @NotNull
        protected NlComponent getComponent() {
            NlComponent nlComponent = this.myComponent;
            if (nlComponent == null) {
                XmlModelComponentMixin.$$$reportNull$$$0(1);
            }
            return nlComponent;
        }

        public String toString() {
            return String.format("<%s>", this.myComponent.getTagName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

