/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.ZoomType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.RefreshRenderAction;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.NlComponentUtil;
import com.android.tools.idea.uibuilder.model.NlModelHelper;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModel
implements Disposable,
ResourceNotificationManager.ResourceChangeListener,
ModificationTracker {
    private static final boolean CHECK_MODEL_INTEGRITY = false;
    private final Set<String> myPendingIds;
    @NotNull
    private final DesignSurface mySurface;
    @NotNull
    private final AndroidFacet myFacet;
    private final VirtualFile myFile;
    private final ConfigurationListener myConfigurationListener;
    private final Configuration myConfiguration;
    private final ListenerCollection<ModelListener> myListeners;
    private NlComponent myRootComponent;
    private LintAnnotationsModel myLintAnnotationsModel;
    private final long myId;
    private final Set<Object> myActivations;
    private final ModelVersion myModelVersion;
    private final NlLayoutType myType;
    private long myConfigurationModificationCount;
    private ChangeType myModificationTrigger;

    @NotNull
    public static NlModel create(@NotNull DesignSurface surface, @Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull XmlFile file) {
        if (surface == null) {
            NlModel.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            NlModel.$$$reportNull$$$0(1);
        }
        if (file == null) {
            NlModel.$$$reportNull$$$0(2);
        }
        NlModel nlModel = new NlModel(surface, parent, facet, file);
        if (nlModel == null) {
            NlModel.$$$reportNull$$$0(3);
        }
        return nlModel;
    }

    @VisibleForTesting
    protected NlModel(@NotNull DesignSurface surface, @Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull XmlFile file) {
        if (surface == null) {
            NlModel.$$$reportNull$$$0(4);
        }
        if (facet == null) {
            NlModel.$$$reportNull$$$0(5);
        }
        if (file == null) {
            NlModel.$$$reportNull$$$0(6);
        }
        this.myPendingIds = Sets.newHashSet();
        this.myConfigurationListener = new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((flags & 6) != 0 && !NlModel.this.mySurface.isLayoutDisabled()) {
                    NlModel.this.mySurface.zoom(ZoomType.FIT_INTO);
                }
                return true;
            }
        };
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myActivations = Collections.newSetFromMap(new WeakHashMap());
        this.myModelVersion = new ModelVersion();
        this.mySurface = surface;
        this.myFacet = facet;
        this.myFile = file.getVirtualFile();
        this.myConfiguration = ConfigurationManager.getOrCreateInstance(facet).getConfiguration(this.myFile);
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
        this.myId = System.nanoTime() ^ (long)file.getName().hashCode();
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        this.myType = NlLayoutType.typeOf(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(@NotNull Object source) {
        boolean wasActive;
        if (source == null) {
            NlModel.$$$reportNull$$$0(7);
        }
        Set<Object> set = this.myActivations;
        synchronized (set) {
            wasActive = !this.myActivations.isEmpty();
            this.myActivations.add(source);
        }
        if (!wasActive) {
            this.myConfiguration.addListener(this.myConfigurationListener);
            if (this.myConfiguration.getModificationCount() != this.myConfigurationModificationCount) {
                this.updateTheme();
            }
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
            manager.addListener(this, this.myFacet, (PsiFile)this.getFile(), this.myConfiguration);
            this.myListeners.forEach(listener -> listener.modelActivated(this));
        }
    }

    public void updateTheme() {
        ResourceResolver resolver;
        ResourceUrl themeUrl;
        String theme = this.myConfiguration.getTheme();
        ResourceUrl resourceUrl = themeUrl = theme != null ? ResourceUrl.parse((String)this.myConfiguration.getTheme()) : null;
        if (themeUrl != null && themeUrl.type == ResourceType.STYLE && ((resolver = this.myConfiguration.getResourceResolver()) == null || resolver.getTheme(themeUrl.name, themeUrl.framework) == null)) {
            this.myConfiguration.setTheme(this.myConfiguration.getConfigurationManager().computePreferredTheme(this.myConfiguration));
        }
    }

    private void deactivate() {
        this.myListeners.forEach(listener -> listener.modelDeactivated(this));
        XmlFile file = this.getFile();
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(file.getProject());
        manager.removeListener(this, this.myFacet, (PsiFile)file, this.myConfiguration);
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
        this.myConfiguration.removeListener(this.myConfigurationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(@NotNull Object source) {
        boolean shouldDeactivate;
        if (source == null) {
            NlModel.$$$reportNull$$$0(8);
        }
        Set<Object> set = this.myActivations;
        synchronized (set) {
            boolean removed = this.myActivations.remove(source);
            shouldDeactivate = removed && this.myActivations.isEmpty();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
    }

    @NotNull
    public XmlFile getFile() {
        XmlFile file = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.getProject(), this.myFile);
        assert (file != null);
        XmlFile xmlFile = file;
        if (xmlFile == null) {
            NlModel.$$$reportNull$$$0(9);
        }
        return xmlFile;
    }

    @NotNull
    public NlLayoutType getType() {
        NlLayoutType nlLayoutType = this.myType;
        if (nlLayoutType == null) {
            NlModel.$$$reportNull$$$0(10);
        }
        return nlLayoutType;
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            NlModel.$$$reportNull$$$0(11);
        }
        return designSurface;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySurface.getSelectionModel();
        if (selectionModel == null) {
            NlModel.$$$reportNull$$$0(12);
        }
        return selectionModel;
    }

    @Nullable
    public LintAnnotationsModel getLintAnnotationsModel() {
        return this.myLintAnnotationsModel;
    }

    public void setLintAnnotationsModel(@Nullable LintAnnotationsModel model) {
        this.myLintAnnotationsModel = model;
    }

    @NotNull
    Set<String> getPendingIds() {
        Set<String> set = this.myPendingIds;
        if (set == null) {
            NlModel.$$$reportNull$$$0(13);
        }
        return set;
    }

    public void syncWithPsi(@NotNull XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
        if (newRoot == null) {
            NlModel.$$$reportNull$$$0(14);
        }
        if (roots == null) {
            NlModel.$$$reportNull$$$0(15);
        }
        new ModelUpdater(this).update(newRoot, roots);
    }

    public void checkStructure() {
    }

    private void checkUnique(NlComponent component2, Set<NlComponent> unique) {
    }

    private void checkUnique(XmlTag tag, Set<XmlTag> unique) {
    }

    private void checkStructure(NlComponent component2) {
    }

    public void addListener(@NotNull ModelListener listener) {
        if (listener == null) {
            NlModel.$$$reportNull$$$0(16);
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@Nullable ModelListener listener) {
        this.myListeners.remove(listener);
    }

    public void notifyListenersModelUpdateComplete() {
        this.myListeners.forEach(listener -> listener.modelDerivedDataChanged(this));
    }

    public void notifyListenersRenderComplete() {
        this.myListeners.forEach(listener -> listener.modelRendered(this));
    }

    public void notifyListenersModelLayoutComplete(boolean animate) {
        this.myListeners.forEach(listener -> listener.modelChangedOnLayout(this, animate));
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            NlModel.$$$reportNull$$$0(17);
        }
        return androidFacet;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myFacet.getModule();
        if (module == null) {
            NlModel.$$$reportNull$$$0(18);
        }
        return module;
    }

    @NotNull
    public Project getProject() {
        Project project = this.getModule().getProject();
        if (project == null) {
            NlModel.$$$reportNull$$$0(19);
        }
        return project;
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            NlModel.$$$reportNull$$$0(20);
        }
        return configuration;
    }

    @NotNull
    public ImmutableList<NlComponent> getComponents() {
        ImmutableList immutableList = this.myRootComponent != null ? ImmutableList.of((Object)this.myRootComponent) : ImmutableList.of();
        if (immutableList == null) {
            NlModel.$$$reportNull$$$0(21);
        }
        return immutableList;
    }

    @NotNull
    public Stream<NlComponent> flattenComponents() {
        Stream<NlComponent> stream = this.myRootComponent != null ? Stream.of(this.myRootComponent).flatMap(NlComponent::flatten) : Stream.empty();
        if (stream == null) {
            NlModel.$$$reportNull$$$0(22);
        }
        return stream;
    }

    public void notifyLiveUpdate(boolean animate) {
        this.myListeners.forEach(listener -> listener.modelLiveUpdate(this, animate));
    }

    @NotNull
    public ImmutableList<NlComponent> findByOffset(int offset) {
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.getFile(), (int)offset, XmlTag.class, (boolean)false);
        ImmutableList<NlComponent> immutableList = tag != null ? this.findViewsByTag(tag) : ImmutableList.of();
        if (immutableList == null) {
            NlModel.$$$reportNull$$$0(23);
        }
        return immutableList;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(24);
        }
        return this.myRootComponent != null ? this.myRootComponent.findViewByTag(tag) : null;
    }

    @Nullable
    public NlComponent find(@NotNull String id) {
        if (id == null) {
            NlModel.$$$reportNull$$$0(25);
        }
        return this.flattenComponents().filter(c -> {
            if (id == null) {
                NlModel.$$$reportNull$$$0(57);
            }
            return id.equals(c.getId());
        }).findFirst().orElse(null);
    }

    @NotNull
    private ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(26);
        }
        if (this.myRootComponent == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                NlModel.$$$reportNull$$$0(27);
            }
            return immutableList;
        }
        ImmutableList<NlComponent> immutableList = this.myRootComponent.findViewsByTag(tag);
        if (immutableList == null) {
            NlModel.$$$reportNull$$$0(28);
        }
        return immutableList;
    }

    @Nullable
    public NlComponent findViewByPsi(@Nullable PsiElement element) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element != null) {
            if (element instanceof XmlTag) {
                return this.findViewByTag((XmlTag)element);
            }
            element = element.getParent();
        }
        return null;
    }

    public void delete(final Collection<NlComponent> components) {
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(this.myFacet.getModule().getProject(), "Delete Component", new PsiFile[]{this.getFile()}){

            protected void run(@NotNull Result<Void> result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                NlModel.this.handleDeletion(components);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/common/model/NlModel$2", "run"));
            }
        };
        action.execute();
        ArrayList remaining = Lists.newArrayList(this.getSelectionModel().getSelection());
        remaining.removeAll(components);
        this.getSelectionModel().setSelection(remaining);
        this.notifyModified(ChangeType.DELETE);
    }

    private void handleDeletion(@NotNull Collection<NlComponent> components) {
        if (components == null) {
            NlModel.$$$reportNull$$$0(29);
        }
        Multimap<NlComponent, NlComponent> siblingLists = NlComponentUtil.groupSiblings(components);
        for (NlComponent parent : siblingLists.keySet()) {
            Collection children;
            if (parent == null || NlModelHelper.INSTANCE.handleDeletion(parent, children = siblingLists.get((Object)parent))) continue;
            for (NlComponent component2 : children) {
                NlComponent p = component2.getParent();
                if (p != null) {
                    p.removeChild(component2);
                }
                component2.getTag().delete();
            }
        }
    }

    public NlComponent createComponent(@NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(30);
        }
        if (parent != null) {
            XmlTag parentTag = parent.getTag();
            tag = before != null ? (XmlTag)parentTag.addBefore((PsiElement)tag, (PsiElement)before.getTag()) : parentTag.addSubTag(tag, false);
        }
        NlComponent child = this.createComponent(tag);
        if (parent != null) {
            parent.addChild(child, before);
        }
        return child;
    }

    public NlComponent createComponent(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(31);
        }
        return this.mySurface.createComponent(tag);
    }

    @NotNull
    public Transferable getSelectionAsTransferable() {
        Transferable transferable = this.getSelectionModel().getTransferable(this.myId);
        if (transferable == null) {
            NlModel.$$$reportNull$$$0(32);
        }
        return transferable;
    }

    public boolean canAddComponents(@Nullable List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before) {
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(33);
        }
        if (before != null && before.getParent() != receiver) {
            return false;
        }
        if (toAdd == null || toAdd.isEmpty()) {
            return false;
        }
        if (!NlModelHelperKt.canAddComponents(this, receiver, toAdd)) {
            return false;
        }
        for (NlComponent component2 : toAdd) {
            for (NlComponent same = receiver; same != null; same = same.getParent()) {
                if (same != component2) continue;
                return false;
            }
        }
        return true;
    }

    public void addComponents(@Nullable List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(34);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(35);
        }
        if (!this.canAddComponents(toAdd, receiver, before)) {
            return;
        }
        if (!NlModelHelperKt.addDependencies(this, toAdd, insertType)) {
            return;
        }
        assert (toAdd != null);
        NlWriteCommandAction.run(toAdd, insertType.getDragType().getDescription(), () -> {
            if (receiver == null) {
                NlModel.$$$reportNull$$$0(55);
            }
            if (insertType == null) {
                NlModel.$$$reportNull$$$0(56);
            }
            this.handleAddition(toAdd, receiver, before, insertType);
        });
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    public void addTags(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (added == null) {
            NlModel.$$$reportNull$$$0(36);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(37);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(38);
        }
        NlWriteCommandAction.run(added, insertType.getDragType().getDescription(), () -> {
            if (added == null) {
                NlModel.$$$reportNull$$$0(52);
            }
            if (receiver == null) {
                NlModel.$$$reportNull$$$0(53);
            }
            if (insertType == null) {
                NlModel.$$$reportNull$$$0(54);
            }
            for (NlComponent component2 : added) {
                NlComponent parent = component2.getParent();
                if (parent != null) {
                    parent.removeChild(component2);
                }
                receiver.addChild(component2, before);
                if (receiver.getTag() != component2.getTag()) {
                    XmlTag prev = component2.getTag();
                    this.transferNamespaces(prev);
                    if (before != null) {
                        component2.setTag((XmlTag)receiver.getTag().addBefore((PsiElement)component2.getTag(), (PsiElement)before.getTag()));
                    } else {
                        component2.setTag(receiver.getTag().addSubTag(component2.getTag(), false));
                    }
                    if (insertType.isMove()) {
                        prev.delete();
                    }
                }
                NlModel.removeNamespaceAttributes(component2);
            }
        });
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    private void handleAddition(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (added == null) {
            NlModel.$$$reportNull$$$0(39);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(40);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(41);
        }
        NlModelHelperKt.handleAddition(this, added, receiver, insertType, this.mySurface);
        for (NlComponent component2 : added) {
            NlComponent parent = component2.getParent();
            if (parent != null) {
                parent.removeChild(component2);
            }
            receiver.addChild(component2, before);
            if (receiver.getTag() != component2.getTag()) {
                XmlTag prev = component2.getTag();
                this.transferNamespaces(prev);
                if (before != null) {
                    component2.setTag((XmlTag)receiver.getTag().addBefore((PsiElement)component2.getTag(), (PsiElement)before.getTag()));
                } else {
                    component2.setTag(receiver.getTag().addSubTag(component2.getTag(), false));
                }
                if (insertType.isMove()) {
                    prev.delete();
                }
            }
            NlModel.removeNamespaceAttributes(component2);
        }
    }

    private void transferNamespaces(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(42);
        }
        XmlFile file = this.getFile();
        XmlDocument xmlDocument = file.getDocument();
        assert (xmlDocument != null);
        XmlTag rootTag = xmlDocument.getRootTag();
        assert (rootTag != null);
        Map prefixToNamespace = rootTag.getLocalNamespaceDeclarations();
        HashMap namespaceToPrefix = Maps.newHashMap();
        for (Map.Entry entry : prefixToNamespace.entrySet()) {
            namespaceToPrefix.put(entry.getValue(), entry.getKey());
        }
        HashMap oldPrefixToPrefix = Maps.newHashMap();
        for (Map.Entry entry : tag.getLocalNamespaceDeclarations().entrySet()) {
            String namespace = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            String currentPrefix = (String)namespaceToPrefix.get(namespace);
            if (currentPrefix == null) {
                String newPrefix = AndroidResourceUtil.ensureNamespaceImported(file, namespace, prefix);
                if (prefix.equals(newPrefix)) continue;
                oldPrefixToPrefix.put(prefix, newPrefix);
                namespaceToPrefix.put(namespace, newPrefix);
                continue;
            }
            if (prefix.equals(currentPrefix)) continue;
            oldPrefixToPrefix.put(prefix, currentPrefix);
        }
        if (!oldPrefixToPrefix.isEmpty()) {
            NlModel.updatePrefixes(tag, oldPrefixToPrefix);
        }
    }

    private static void updatePrefixes(@NotNull XmlTag tag, @NotNull Map<String, String> oldPrefixToPrefix) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(43);
        }
        if (oldPrefixToPrefix == null) {
            NlModel.$$$reportNull$$$0(44);
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String newPrefix;
            String prefix = xmlAttribute.getNamespacePrefix();
            if (prefix.isEmpty()) continue;
            if (prefix.equals("xmlns")) {
                newPrefix = oldPrefixToPrefix.get(xmlAttribute.getLocalName());
                if (newPrefix == null) continue;
                xmlAttribute.setName("xmlns:" + newPrefix);
                continue;
            }
            newPrefix = oldPrefixToPrefix.get(prefix);
            if (newPrefix == null) continue;
            xmlAttribute.setName(newPrefix + ':' + xmlAttribute.getLocalName());
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            NlModel.updatePrefixes((XmlTag)xmlAttribute, oldPrefixToPrefix);
        }
    }

    private static void removeNamespaceAttributes(NlComponent component2) {
        for (XmlAttribute attribute : component2.getTag().getAttributes()) {
            if (!attribute.getName().startsWith("xmlns:")) continue;
            attribute.delete();
        }
    }

    @NotNull
    public InsertType determineInsertType(@NotNull DragType dragType, @Nullable DnDTransferItem item, boolean asPreview) {
        if (dragType == null) {
            NlModel.$$$reportNull$$$0(45);
        }
        if (item != null && item.isFromPalette()) {
            InsertType insertType = asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
            if (insertType == null) {
                NlModel.$$$reportNull$$$0(46);
            }
            return insertType;
        }
        switch (dragType) {
            case CREATE: {
                InsertType insertType = asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
                if (insertType == null) {
                    NlModel.$$$reportNull$$$0(47);
                }
                return insertType;
            }
            case MOVE: {
                InsertType insertType = item != null && this.myId != item.getModelId() ? InsertType.COPY : InsertType.MOVE_INTO;
                if (insertType == null) {
                    NlModel.$$$reportNull$$$0(48);
                }
                return insertType;
            }
            case COPY: {
                InsertType insertType = InsertType.COPY;
                if (insertType == null) {
                    NlModel.$$$reportNull$$$0(49);
                }
                return insertType;
            }
        }
        InsertType insertType = InsertType.PASTE;
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(50);
        }
        return insertType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean shouldDeactivate;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            shouldDeactivate = !this.myActivations.isEmpty();
            this.myActivations.clear();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
        this.myListeners.clear();
    }

    public String toString() {
        return NlModel.class.getSimpleName() + " for " + this.getFile();
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reason) {
        if (reason == null) {
            NlModel.$$$reportNull$$$0(51);
        }
        for (ResourceNotificationManager.Reason r : reason) {
            switch (r) {
                case RESOURCE_EDIT: {
                    this.notifyModified(ChangeType.RESOURCE_EDIT);
                    break;
                }
                case EDIT: {
                    this.notifyModified(ChangeType.EDIT);
                    break;
                }
                case IMAGE_RESOURCE_CHANGED: {
                    RefreshRenderAction.clearCache(this.mySurface);
                    break;
                }
                case GRADLE_SYNC: 
                case PROJECT_BUILD: 
                case VARIANT_CHANGED: 
                case SDK_CHANGED: {
                    this.notifyModified(ChangeType.BUILD);
                    break;
                }
                case CONFIGURATION_CHANGED: {
                    this.notifyModified(ChangeType.CONFIGURATION_CHANGE);
                }
            }
        }
    }

    public long getModificationCount() {
        return this.myModelVersion.getVersion();
    }

    public long getConfigurationModificationCount() {
        return this.myConfigurationModificationCount;
    }

    public void notifyModified(ChangeType reason) {
        this.myModelVersion.increase(reason);
        this.updateTheme();
        this.myModificationTrigger = reason;
        this.myListeners.forEach(listener -> listener.modelChanged(this));
    }

    public ChangeType getLastChangeType() {
        return this.myModificationTrigger;
    }

    public void resetLastChange() {
        this.myModificationTrigger = null;
    }

    private /* synthetic */ void lambda$checkStructure$2() {
        Set unique = Sets.newIdentityHashSet();
        Set uniqueTags = Sets.newIdentityHashSet();
        this.checkUnique(this.getFile().getRootTag(), uniqueTags);
        uniqueTags.clear();
        if (this.myRootComponent != null) {
            this.checkUnique(this.myRootComponent.getTag(), uniqueTags);
            this.checkUnique(this.myRootComponent, unique);
            this.checkStructure(this.myRootComponent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 32: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 32: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 32: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/NlModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 25: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 35: 
            case 38: 
            case 41: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 36: 
            case 39: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPrefixToPrefix";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/NlModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingIds";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenComponents";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findByOffset";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewsByTag";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionAsTransferable";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "determineInsertType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 32: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "syncWithPsi";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findViewByTag";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findViewsByTag";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "handleDeletion";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "canAddComponents";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addComponents";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addTags";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "handleAddition";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "transferNamespaces";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updatePrefixes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "determineInsertType";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "resourcesChanged";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTags$9";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addComponents$8";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$find$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 32: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModelVersion {
        private final AtomicLong myVersion = new AtomicLong();
        ChangeType mLastReason;

        ModelVersion() {
        }

        public void increase(ChangeType reason) {
            this.myVersion.incrementAndGet();
            this.mLastReason = reason;
        }

        public long getVersion() {
            return this.myVersion.get();
        }
    }

    public static enum ChangeType {
        RESOURCE_EDIT,
        EDIT,
        RESOURCE_CHANGED,
        ADD_COMPONENTS,
        DELETE,
        DND_COMMIT,
        DND_END,
        DROP,
        RESIZE_END,
        RESIZE_COMMIT,
        UPDATE_HIERARCHY,
        BUILD,
        CONFIGURATION_CHANGE;

    }

    private static class ModelUpdater {
        private final NlModel myModel;
        private final Map<XmlTag, NlComponent> myTagToComponentMap;
        private final Map<NlComponent, XmlTag> myComponentToTagMap;
        protected final Map<TagSnapshot, NlComponent> mySnapshotToComponent;
        private final Map<XmlTag, TagSnapshot> myTagToSnapshot;

        public ModelUpdater(@NotNull NlModel model) {
            if (model == null) {
                ModelUpdater.$$$reportNull$$$0(0);
            }
            this.myTagToComponentMap = Maps.newIdentityHashMap();
            this.myComponentToTagMap = Maps.newIdentityHashMap();
            this.mySnapshotToComponent = Maps.newIdentityHashMap();
            this.myTagToSnapshot = Maps.newHashMap();
            this.myModel = model;
        }

        private void recordComponentMapping(@NotNull XmlTag tag, @NotNull NlComponent component2) {
            XmlTag prevTag;
            if (tag == null) {
                ModelUpdater.$$$reportNull$$$0(1);
            }
            if (component2 == null) {
                ModelUpdater.$$$reportNull$$$0(2);
            }
            if ((prevTag = this.myComponentToTagMap.get(component2)) != null) {
                this.myTagToComponentMap.remove(prevTag);
            }
            this.myComponentToTagMap.put(component2, tag);
            this.myTagToComponentMap.put(tag, component2);
        }

        @VisibleForTesting
        public void update(@Nullable XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
            if (roots == null) {
                ModelUpdater.$$$reportNull$$$0(3);
            }
            if (newRoot == null) {
                this.myModel.myRootComponent = null;
                return;
            }
            boolean isValidRoot = (Boolean)ApplicationManager.getApplication().runReadAction(() -> ((XmlTag)newRoot).isValid());
            if (!isValidRoot) {
                this.myModel.myRootComponent = null;
                return;
            }
            for (TagSnapshotTreeNode root : roots) {
                ModelUpdater.gatherTagsAndSnapshots(root, this.myTagToSnapshot);
            }
            NlComponent rootComponent = (NlComponent)ApplicationManager.getApplication().runReadAction(() -> {
                this.mapOldToNew(newRoot);
                for (Map.Entry<XmlTag, NlComponent> entry : this.myTagToComponentMap.entrySet()) {
                    XmlTag tag = entry.getKey();
                    NlComponent component2 = entry.getValue();
                    if (component2.getTagName().equals(tag.getName())) continue;
                    this.myTagToComponentMap.clear();
                    this.myComponentToTagMap.clear();
                    break;
                }
                return this.createTree(newRoot);
            });
            this.myModel.myRootComponent = rootComponent;
            for (NlComponent component2 : this.myTagToComponentMap.values()) {
                component2.setSnapshot(null);
            }
            for (TagSnapshotTreeNode root : roots) {
                this.updateHierarchy(root);
            }
        }

        private void mapOldToNew(@NotNull XmlTag newRootTag) {
            XmlTag oldTag;
            TagSnapshot snapshot;
            NlComponent component2;
            if (newRootTag == null) {
                ModelUpdater.$$$reportNull$$$0(4);
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (NlComponent component3 : this.myModel.getComponents()) {
                this.gatherTagsAndSnapshots(component3);
            }
            ArrayList missing = Lists.newArrayList();
            Set remaining = Sets.newIdentityHashSet();
            remaining.addAll(this.myTagToComponentMap.keySet());
            ModelUpdater.checkMissing(newRootTag, remaining, missing);
            if (missing.isEmpty()) {
                return;
            }
            if (remaining.isEmpty()) {
                return;
            }
            HashMap oldIds = Maps.newHashMap();
            for (Map.Entry<TagSnapshot, NlComponent> entry : this.mySnapshotToComponent.entrySet()) {
                String id;
                TagSnapshot snapshot2 = entry.getKey();
                if (snapshot2 == null || (id = snapshot2.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null) continue;
                oldIds.put(id, entry.getValue());
            }
            ListIterator missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                XmlTag tag = (XmlTag)missingIterator.next();
                String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
                if (id == null || (component2 = (NlComponent)oldIds.get(id)) == null) continue;
                this.recordComponentMapping(tag, component2);
                remaining.remove(component2.getTag());
                missingIterator.remove();
            }
            if (missing.isEmpty() || remaining.isEmpty()) {
                return;
            }
            ArrayListMultimap snapshotIds = ArrayListMultimap.create();
            for (XmlTag old : remaining) {
                NlComponent component4 = this.myTagToComponentMap.get(old);
                if (component4 == null || (snapshot = component4.getSnapshot()) == null) continue;
                snapshotIds.put((Object)snapshot.getSignature(), (Object)snapshot);
            }
            missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                TagSnapshot first;
                NlComponent component5;
                long signature;
                Collection snapshots;
                XmlTag tag = (XmlTag)missingIterator.next();
                TagSnapshot snapshot3 = this.myTagToSnapshot.get(tag);
                if (snapshot3 == null || (snapshots = snapshotIds.get((Object)(signature = snapshot3.getSignature()))).isEmpty() || (component5 = this.mySnapshotToComponent.get(first = (TagSnapshot)snapshots.iterator().next())) == null) continue;
                this.recordComponentMapping(tag, component5);
                remaining.remove(component5.getTag());
                snapshotIds.remove((Object)tag, (Object)first);
                missingIterator.remove();
            }
            if (missing.size() == 1 && remaining.size() == 1 && (component2 = this.myTagToComponentMap.get(oldTag = (XmlTag)remaining.iterator().next())) != null) {
                XmlTag newTag = (XmlTag)missing.get(0);
                snapshot = component2.getSnapshot();
                if (snapshot != null && snapshot.tagName.equals(newTag.getName())) {
                    this.recordComponentMapping(newTag, component2);
                }
            }
        }

        private static void checkMissing(XmlTag tag, Set<XmlTag> remaining, List<XmlTag> missing) {
            boolean found = remaining.remove(tag);
            if (!found) {
                missing.add(tag);
            }
            for (XmlTag child : tag.getSubTags()) {
                ModelUpdater.checkMissing(child, remaining, missing);
            }
        }

        private void gatherTagsAndSnapshots(@NotNull NlComponent component2) {
            if (component2 == null) {
                ModelUpdater.$$$reportNull$$$0(5);
            }
            XmlTag tag = component2.getTag();
            this.recordComponentMapping(tag, component2);
            this.mySnapshotToComponent.put(component2.getSnapshot(), component2);
            for (NlComponent child : component2.getChildren()) {
                this.gatherTagsAndSnapshots(child);
            }
        }

        private static void gatherTagsAndSnapshots(@NotNull TagSnapshotTreeNode node, @NotNull Map<XmlTag, TagSnapshot> map) {
            TagSnapshot snapshot;
            if (node == null) {
                ModelUpdater.$$$reportNull$$$0(6);
            }
            if (map == null) {
                ModelUpdater.$$$reportNull$$$0(7);
            }
            if ((snapshot = node.getTagSnapshot()) != null) {
                map.put(snapshot.tag, snapshot);
            }
            for (TagSnapshotTreeNode child : node.getChildren()) {
                ModelUpdater.gatherTagsAndSnapshots(child, map);
            }
        }

        @NotNull
        private NlComponent createTree(@NotNull XmlTag tag) {
            XmlTag[] subTags;
            NlComponent component2;
            if (tag == null) {
                ModelUpdater.$$$reportNull$$$0(8);
            }
            if ((component2 = this.myTagToComponentMap.get(tag)) == null) {
                component2 = this.myModel.createComponent(tag);
                this.recordComponentMapping(tag, component2);
            }
            if ((subTags = tag.getSubTags()).length > 0) {
                ArrayList<NlComponent> children = new ArrayList<NlComponent>(subTags.length);
                for (XmlTag subtag : subTags) {
                    NlComponent child = this.createTree(subtag);
                    children.add(child);
                }
                component2.setChildren(children);
            } else {
                component2.setChildren(null);
            }
            NlComponent nlComponent = component2;
            if (nlComponent == null) {
                ModelUpdater.$$$reportNull$$$0(9);
            }
            return nlComponent;
        }

        private void updateHierarchy(@NotNull TagSnapshotTreeNode node) {
            TagSnapshot snapshot;
            if (node == null) {
                ModelUpdater.$$$reportNull$$$0(10);
            }
            if ((snapshot = node.getTagSnapshot()) != null) {
                NlComponent component2 = this.mySnapshotToComponent.get(snapshot);
                if (component2 == null) {
                    component2 = this.myTagToComponentMap.get(snapshot.tag);
                }
                if (component2 != null) {
                    component2.setSnapshot(snapshot);
                    assert (snapshot.tag != null);
                    component2.setTag(snapshot.tag);
                }
            }
            for (TagSnapshotTreeNode child : node.getChildren()) {
                this.updateHierarchy(child);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRootTag";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/model/NlModel$ModelUpdater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/model/NlModel$ModelUpdater";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "recordComponentMapping";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "mapOldToNew";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "gatherTagsAndSnapshots";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createTree";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "updateHierarchy";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface TagSnapshotTreeNode {
        @Nullable
        public TagSnapshot getTagSnapshot();

        @NotNull
        public List<TagSnapshotTreeNode> getChildren();
    }
}

