/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class DrawComponentBackground
extends DrawRegion {
    public static final int SUBDUED = 0;
    public static final int NORMAL = 1;
    public static final int OVER = 2;
    public static final int SELECTED = 3;
    public static final int ARC_SIZE = 20;
    private final int myMode;
    private final boolean myRounded;

    public DrawComponentBackground(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c++]);
        this.myRounded = Boolean.parseBoolean(sp[c]);
    }

    @Override
    public int getLevel() {
        return 20;
    }

    public DrawComponentBackground(int x, int y, int width, int height, int mode) {
        this(x, y, width, height, mode, false);
    }

    public DrawComponentBackground(int x, int y, int width, int height, int mode, boolean rounded) {
        super(x, y, width, height);
        this.myMode = mode;
        this.myRounded = rounded;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color[] colorBackground = new Color[]{colorSet.getComponentBackground(), colorSet.getComponentBackground(), colorSet.getComponentHighlightedBackground(), colorSet.getComponentHighlightedBackground(), colorSet.getDragReceiverBackground()};
        if (colorSet.drawBackground()) {
            g.setColor(colorBackground[this.myMode]);
            if (this.myRounded) {
                g.fillRoundRect(this.x, this.y, this.width, this.height, 20, 20);
            } else {
                g.fillRect(this.x, this.y, this.width, this.height);
            }
        }
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode + "," + this.myRounded;
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, int mode) {
        DrawComponentBackground.add(list, sceneContext, rect, mode, false);
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, int mode, boolean rounded) {
        int l = sceneContext.getSwingX(rect.x);
        int t = sceneContext.getSwingY(rect.y);
        int w = sceneContext.getSwingDimension(rect.width);
        int h = sceneContext.getSwingDimension(rect.height);
        list.add(new DrawComponentBackground(l, t, w, h, mode, rounded));
    }
}

