/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.targets.PlatformTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SoftValueHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.uipreview.UserDeviceManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationManager
implements Disposable {
    private static final Key<ConfigurationManager> KEY = Key.create((String)ConfigurationManager.class.getName());
    @NotNull
    private final Module myModule;
    private List<Device> myDevices;
    private Map<String, Device> myDeviceMap;
    private final UserDeviceManager myUserDeviceManager;
    private final SoftValueHashMap<VirtualFile, Configuration> myCache;
    private List<Locale> myLocales;
    private Device myDefaultDevice;
    private Locale myLocale;
    private IAndroidTarget myTarget;
    private int myStateVersion;
    private ResourceResolverCache myResolverCache;
    private long myLocaleCacheStamp;

    @NotNull
    public static ConfigurationManager getOrCreateInstance(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            ConfigurationManager.$$$reportNull$$$0(0);
        }
        ConfigurationManager configurationManager = ConfigurationManager.findConfigurationManager(androidFacet, true);
        if (configurationManager == null) {
            ConfigurationManager.$$$reportNull$$$0(1);
        }
        return configurationManager;
    }

    @NotNull
    public static ConfigurationManager getOrCreateInstance(@NotNull Module module) {
        AndroidFacet androidFacet;
        if (module == null) {
            ConfigurationManager.$$$reportNull$$$0(2);
        }
        if ((androidFacet = AndroidFacet.getInstance(module)) == null) {
            throw new IllegalArgumentException("Module '" + module.getName() + "' is not an Android module");
        }
        ConfigurationManager configurationManager = ConfigurationManager.findConfigurationManager(androidFacet, true);
        if (configurationManager == null) {
            ConfigurationManager.$$$reportNull$$$0(3);
        }
        return configurationManager;
    }

    @Nullable
    public static ConfigurationManager findExistingInstance(@NotNull Module module) {
        AndroidFacet androidFacet;
        if (module == null) {
            ConfigurationManager.$$$reportNull$$$0(4);
        }
        if ((androidFacet = AndroidFacet.getInstance(module)) == null) {
            throw new IllegalArgumentException("Module '" + module.getName() + "' is not an Android module");
        }
        return ConfigurationManager.findConfigurationManager(androidFacet, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static ConfigurationManager findConfigurationManager(@NotNull AndroidFacet androidFacet, boolean createIfNecessary) {
        Module module;
        ConfigurationManager configurationManager;
        if (androidFacet == null) {
            ConfigurationManager.$$$reportNull$$$0(5);
        }
        if ((configurationManager = (ConfigurationManager)(module = androidFacet.getModule()).getUserData(KEY)) == null && createIfNecessary) {
            configurationManager = ConfigurationManager.create(module);
            module.putUserData(KEY, (Object)configurationManager);
        }
        return configurationManager;
    }

    private ConfigurationManager(@NotNull Module module) {
        if (module == null) {
            ConfigurationManager.$$$reportNull$$$0(6);
        }
        this.myCache = new SoftValueHashMap();
        this.myModule = module;
        this.myUserDeviceManager = new UserDeviceManager(){

            @Override
            protected void userDevicesChanged() {
                ConfigurationManager.this.myDevices = null;
                ConfigurationManager.this.myDeviceMap = null;
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myUserDeviceManager);
        Disposer.register((Disposable)this.myModule, (Disposable)this);
    }

    @NotNull
    public Configuration getConfiguration(@NotNull VirtualFile file) {
        Configuration configuration;
        if (file == null) {
            ConfigurationManager.$$$reportNull$$$0(7);
        }
        if ((configuration = (Configuration)this.myCache.get((Object)file)) == null) {
            configuration = this.create(file);
            this.myCache.put((Object)file, (Object)configuration);
        }
        Configuration configuration2 = configuration;
        if (configuration2 == null) {
            ConfigurationManager.$$$reportNull$$$0(8);
        }
        return configuration2;
    }

    boolean hasCachedConfiguration(@NotNull VirtualFile file) {
        if (file == null) {
            ConfigurationManager.$$$reportNull$$$0(9);
        }
        return this.myCache.get((Object)file) != null;
    }

    @NotNull
    private Configuration create(@NotNull VirtualFile file) {
        if (file == null) {
            ConfigurationManager.$$$reportNull$$$0(10);
        }
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(file);
        assert (file.getParent() != null) : file;
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)file.getParent().getName());
        if (config == null) {
            config = new FolderConfiguration();
        }
        Configuration configuration = Configuration.create(this, file, fileState, config);
        AppResourceRepository resources = AppResourceRepository.getOrCreateInstance(this.getModule());
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, resources, file);
        if (fileState != null) {
            matcher.adaptConfigSelection(true);
        } else {
            matcher.findAndSetCompatibleConfig(false);
        }
        Configuration configuration2 = configuration;
        if (configuration2 == null) {
            ConfigurationManager.$$$reportNull$$$0(11);
        }
        return configuration2;
    }

    @NotNull
    public Configuration createSimilar(@NotNull VirtualFile file, @NotNull VirtualFile baseFile) {
        if (file == null) {
            ConfigurationManager.$$$reportNull$$$0(12);
        }
        if (baseFile == null) {
            ConfigurationManager.$$$reportNull$$$0(13);
        }
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(baseFile);
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)file.getParent().getName());
        if (config == null) {
            config = new FolderConfiguration();
        }
        Configuration configuration = Configuration.create(this, file, fileState, config);
        Configuration baseConfig = (Configuration)this.myCache.get((Object)file);
        if (baseConfig != null) {
            configuration.setEffectiveDevice(baseConfig.getDevice(), baseConfig.getDeviceState());
        }
        AppResourceRepository resources = AppResourceRepository.getOrCreateInstance(this.getModule());
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, resources, file);
        matcher.adaptConfigSelection(true);
        this.myCache.put((Object)file, (Object)configuration);
        Configuration configuration2 = configuration;
        if (configuration2 == null) {
            ConfigurationManager.$$$reportNull$$$0(14);
        }
        return configuration2;
    }

    public ConfigurationStateManager getStateManager() {
        return ConfigurationStateManager.get(this.getModule().getProject());
    }

    @NotNull
    public static ConfigurationManager create(@NotNull Module module) {
        if (module == null) {
            ConfigurationManager.$$$reportNull$$$0(15);
        }
        ConfigurationManager configurationManager = new ConfigurationManager(module);
        Disposer.register((Disposable)module, (Disposable)configurationManager);
        ConfigurationManager configurationManager2 = configurationManager;
        if (configurationManager2 == null) {
            ConfigurationManager.$$$reportNull$$$0(16);
        }
        return configurationManager2;
    }

    @NotNull
    public List<Device> getDevices() {
        if (this.myDevices == null || this.myDevices.isEmpty()) {
            ArrayList<Device> devices = null;
            AndroidPlatform platform = AndroidPlatform.getInstance(this.getModule());
            if (platform != null) {
                AndroidSdkData sdkData = platform.getSdkData();
                devices = new ArrayList<Device>();
                DeviceManager deviceManager = sdkData.getDeviceManager();
                devices.addAll(deviceManager.getDevices(EnumSet.of(DeviceManager.DeviceFilter.DEFAULT, DeviceManager.DeviceFilter.VENDOR)));
                devices.addAll(this.myUserDeviceManager.parseUserDevices((ILogger)new MessageBuildingSdkLog()));
            }
            this.myDevices = devices == null ? Collections.emptyList() : devices;
        }
        List<Device> list = this.myDevices;
        if (list == null) {
            ConfigurationManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private Map<String, Device> getDeviceMap() {
        if (this.myDeviceMap == null) {
            List<Device> devices = this.getDevices();
            this.myDeviceMap = Maps.newHashMapWithExpectedSize((int)devices.size());
            for (Device device : devices) {
                this.myDeviceMap.put(device.getId(), device);
            }
        }
        Map<String, Device> map = this.myDeviceMap;
        if (map == null) {
            ConfigurationManager.$$$reportNull$$$0(18);
        }
        return map;
    }

    @Nullable
    public Device getDeviceById(@NotNull String id) {
        if (id == null) {
            ConfigurationManager.$$$reportNull$$$0(19);
        }
        return this.getDeviceMap().get(id);
    }

    @Nullable
    public Device createDeviceForAvd(@NotNull AvdInfo avd) {
        if (avd == null) {
            ConfigurationManager.$$$reportNull$$$0(20);
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.getModule());
        assert (facet != null);
        for (Device device : this.getDevices()) {
            if (!device.getManufacturer().equals(avd.getDeviceManufacturer()) || !device.getId().equals(avd.getDeviceName()) && !device.getDisplayName().equals(avd.getDeviceName())) continue;
            String avdName = avd.getName();
            Device.Builder builder = new Device.Builder(device);
            builder.setName(avdName);
            return builder.build();
        }
        return null;
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.getModule());
        if (platform != null) {
            AndroidSdkData sdkData = platform.getSdkData();
            IAndroidTarget[] iAndroidTargetArray = sdkData.getTargets();
            if (iAndroidTargetArray == null) {
                ConfigurationManager.$$$reportNull$$$0(21);
            }
            return iAndroidTargetArray;
        }
        IAndroidTarget[] iAndroidTargetArray = new IAndroidTarget[]{};
        if (iAndroidTargetArray == null) {
            ConfigurationManager.$$$reportNull$$$0(22);
        }
        return iAndroidTargetArray;
    }

    public static boolean isLayoutLibTarget(@NotNull IAndroidTarget target) {
        if (target == null) {
            ConfigurationManager.$$$reportNull$$$0(23);
        }
        return target.isPlatform() && target.hasRenderingLibrary();
    }

    @Nullable
    public IAndroidTarget getHighestApiTarget() {
        IAndroidTarget[] targetList = this.getTargets();
        for (int i = targetList.length - 1; i >= 0; --i) {
            IAndroidTarget target = targetList[i];
            if (!ConfigurationManager.isLayoutLibTarget(target) || !ConfigurationManager.isLayoutLibSupported(target)) continue;
            return target;
        }
        return null;
    }

    private static boolean isLayoutLibSupported(IAndroidTarget target) {
        if (target instanceof PlatformTarget) {
            int layoutlibVersion = ((PlatformTarget)target).getLayoutlibApi();
            return layoutlibVersion <= 17;
        }
        return false;
    }

    @NotNull
    public String computePreferredTheme(@NotNull Configuration configuration) {
        if (configuration == null) {
            ConfigurationManager.$$$reportNull$$$0(24);
        }
        MergedManifest manifest = MergedManifest.get(this.getModule());
        String activity = configuration.getActivity();
        if (activity != null) {
            String theme;
            MergedManifest.ActivityAttributes attributes;
            String activityFqcn = activity;
            if (activity.startsWith(".")) {
                String pkg = StringUtil.notNullize((String)manifest.getPackage());
                activityFqcn = pkg + activity;
            }
            if ((attributes = manifest.getActivityAttributes(activityFqcn)) != null && (theme = attributes.getTheme()) != null && theme.startsWith("@")) {
                String string = theme;
                if (string == null) {
                    ConfigurationManager.$$$reportNull$$$0(25);
                }
                return string;
            }
            attributes = manifest.getActivityAttributes(activity);
            if (attributes != null && (theme = attributes.getTheme()) != null && theme.startsWith("@")) {
                String string = theme;
                if (string == null) {
                    ConfigurationManager.$$$reportNull$$$0(26);
                }
                return string;
            }
        }
        String string = manifest.getDefaultTheme(configuration.getTarget(), configuration.getScreenSize(), configuration.getDevice());
        if (string == null) {
            ConfigurationManager.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ConfigurationManager.$$$reportNull$$$0(28);
        }
        return module;
    }

    @NotNull
    public Project getProject() {
        Project project = this.getModule().getProject();
        if (project == null) {
            ConfigurationManager.$$$reportNull$$$0(29);
        }
        return project;
    }

    public void dispose() {
        this.getModule().putUserData(KEY, null);
    }

    @Nullable
    public Device getDefaultDevice() {
        List<Device> devices;
        if (this.myDefaultDevice == null && !(devices = this.getDevices()).isEmpty()) {
            Device device = devices.get(0);
            for (Device d : devices) {
                String name = d.getId();
                if (name.equals("Nexus 4")) {
                    device = d;
                    break;
                }
                if (!name.equals("Galaxy Nexus")) continue;
                device = d;
            }
            this.myDefaultDevice = device;
        }
        return this.myDefaultDevice;
    }

    @Nullable
    public IAndroidTarget getDefaultTarget() {
        return this.getHighestApiTarget();
    }

    @NotNull
    public List<Locale> getLocales() {
        ProjectResourceRepository projectResources = ProjectResourceRepository.getOrCreateInstance(this.getModule());
        assert (projectResources != null);
        if (((LocalResourceRepository)projectResources).getModificationCount() != this.myLocaleCacheStamp) {
            this.myLocales = null;
        }
        if (this.myLocales == null) {
            ArrayList<Locale> locales = new ArrayList<Locale>();
            for (LocaleQualifier locale : projectResources.getLocales()) {
                locales.add(Locale.create(locale));
            }
            this.myLocales = locales;
            this.myLocaleCacheStamp = ((LocalResourceRepository)projectResources).getModificationCount();
        }
        List<Locale> list = this.myLocales;
        if (list == null) {
            ConfigurationManager.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Nullable
    public IAndroidTarget getProjectTarget() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.getModule());
        return platform != null ? platform.getTarget() : null;
    }

    @NotNull
    public Locale getLocale() {
        if (this.myLocale == null) {
            String localeString = this.getStateManager().getProjectState().getLocale();
            this.myLocale = localeString != null ? ConfigurationProjectState.fromLocaleString(localeString) : Locale.ANY;
        }
        Locale locale = this.myLocale;
        if (locale == null) {
            ConfigurationManager.$$$reportNull$$$0(31);
        }
        return locale;
    }

    public void setLocale(@NotNull Locale locale) {
        if (locale == null) {
            ConfigurationManager.$$$reportNull$$$0(32);
        }
        if (!locale.equals(this.myLocale)) {
            this.myLocale = locale;
            ++this.myStateVersion;
            this.getStateManager().getProjectState().setLocale(ConfigurationProjectState.toLocaleString(locale));
            for (Configuration configuration : this.myCache.values()) {
                configuration.updated(16);
            }
        }
    }

    public List<Device> getRecentDevices() {
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        if (deviceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList devices = Lists.newArrayListWithExpectedSize((int)deviceIds.size());
        ListIterator<String> iterator = deviceIds.listIterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            Device device = this.getDeviceById(id);
            if (device != null) {
                devices.add(device);
                continue;
            }
            iterator.remove();
        }
        return devices;
    }

    public void selectDevice(@NotNull Device device) {
        if (device == null) {
            ConfigurationManager.$$$reportNull$$$0(33);
        }
        String id = device.getId();
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        deviceIds.remove(id);
        deviceIds.add(0, id);
        while (deviceIds.size() > 10) {
            deviceIds.remove(deviceIds.size() - 1);
        }
        ++this.myStateVersion;
        for (Configuration configuration : this.myCache.values()) {
            boolean updateTheme = false;
            String theme = configuration.getTheme();
            if (theme != null && theme.startsWith("@android:style/")) {
                updateTheme = true;
                configuration.startBulkEditing();
                configuration.setTheme(null);
            }
            configuration.updated(2);
            if (!updateTheme) continue;
            configuration.finishBulkEditing();
        }
    }

    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            ConfigurationProjectState projectState = this.getStateManager().getProjectState();
            if (projectState.isPickTarget()) {
                this.myTarget = this.getDefaultTarget();
            } else {
                String targetString = projectState.getTarget();
                this.myTarget = ConfigurationProjectState.fromTargetString(this, targetString);
                if (this.myTarget == null) {
                    this.myTarget = this.getDefaultTarget();
                }
            }
            return this.myTarget;
        }
        return this.myTarget;
    }

    @Nullable
    public IAndroidTarget getTarget(int min) {
        IAndroidTarget target = this.getTarget();
        if (target != null && target.getVersion().getApiLevel() >= min) {
            return target;
        }
        IAndroidTarget[] targetList = this.getTargets();
        for (int i = targetList.length - 1; i >= 0; --i) {
            target = targetList[i];
            if (!ConfigurationManager.isLayoutLibTarget(target) || target.getVersion().getFeatureLevel() < min || !ConfigurationManager.isLayoutLibSupported(target)) continue;
            return target;
        }
        return null;
    }

    public void setTarget(@Nullable IAndroidTarget target) {
        if (target != this.myTarget) {
            AndroidTargetData targetData;
            if (this.myTarget != null && (targetData = AndroidTargetData.getTargetData(this.myTarget, this.getModule())) != null) {
                targetData.clearLayoutBitmapCache(this.getModule());
            }
            this.myTarget = target;
            if (target != null) {
                this.getStateManager().getProjectState().setTarget(ConfigurationProjectState.toTargetString(target));
                ++this.myStateVersion;
                for (Configuration configuration : this.myCache.values()) {
                    configuration.updated(32);
                }
            }
        }
    }

    public void syncToVariations(int flags, @NotNull VirtualFile updatedFile, @NotNull Configuration base, boolean includeSelf, boolean async) {
        if (updatedFile == null) {
            ConfigurationManager.$$$reportNull$$$0(34);
        }
        if (base == null) {
            ConfigurationManager.$$$reportNull$$$0(35);
        }
        if (async) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (updatedFile == null) {
                    ConfigurationManager.$$$reportNull$$$0(36);
                }
                if (base == null) {
                    ConfigurationManager.$$$reportNull$$$0(37);
                }
                this.doSyncToVariations(flags, updatedFile, includeSelf, base);
            });
        } else {
            this.doSyncToVariations(flags, updatedFile, includeSelf, base);
        }
    }

    private void doSyncToVariations(int flags, VirtualFile updatedFile, boolean includeSelf, Configuration base) {
        List<VirtualFile> files = ResourceHelper.getResourceVariations(updatedFile, includeSelf);
        for (VirtualFile file : files) {
            Configuration configuration = this.getConfiguration(file);
            Configuration.copyCompatible(base, configuration);
            configuration.save();
        }
    }

    public int getStateVersion() {
        return this.myStateVersion;
    }

    public ResourceResolverCache getResolverCache() {
        if (this.myResolverCache == null) {
            this.myResolverCache = new ResourceResolverCache(this);
        }
        return this.myResolverCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/ConfigurationManager";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avd";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFile";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/ConfigurationManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimilar";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceMap";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "computePreferredTheme";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocales";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateInstance";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInstance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationManager";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasCachedConfiguration";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSimilar";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceById";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createDeviceForAvd";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isLayoutLibTarget";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "computePreferredTheme";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setLocale";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "selectDevice";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "syncToVariations";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$syncToVariations$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

