/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.adb;

import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Getter;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class AdbOptionsService
implements Getter<AdbOptionsService> {
    private static final String USE_LIBUSB = "adb.use.libusb";
    private static final boolean LIBUSB_DEFAULT = false;
    private final Object LOCK = new Object();
    @GuardedBy(value="LOCK")
    private List<AdbOptionsListener> myListeners = new SmartList();

    public static AdbOptionsService getInstance() {
        return (AdbOptionsService)ServiceManager.getService(AdbOptionsService.class);
    }

    public AdbOptionsService get() {
        return this;
    }

    public boolean shouldUseLibusb() {
        return PropertiesComponent.getInstance().getBoolean(USE_LIBUSB, false);
    }

    public void setUseLibusb(boolean en) {
        PropertiesComponent.getInstance().setValue(USE_LIBUSB, en);
        this.updateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListeners() {
        ImmutableList listeners;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            listeners = ImmutableList.copyOf(this.myListeners);
        }
        for (AdbOptionsListener listener : listeners) {
            listener.optionsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull AdbOptionsListener listener) {
        if (listener == null) {
            AdbOptionsService.$$$reportNull$$$0(0);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull AdbOptionsListener listener) {
        if (listener == null) {
            AdbOptionsService.$$$reportNull$$$0(1);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myListeners.remove(listener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "listener";
        objectArray2[1] = "com/android/tools/idea/ddms/adb/AdbOptionsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface AdbOptionsListener {
        public void optionsChanged();
    }
}

