/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.structure.AndroidProjectStructureConfigurable;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.actions.ShowStructureSettingsAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class AndroidShowStructureSettingsAction
extends ShowStructureSettingsAction {
    public void update(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null && AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
            e.getPresentation().setEnabledAndVisible(GradleProjectInfo.getInstance(project).isBuildWithGradle());
        }
        super.update(e);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null && IdeInfo.getInstance().isAndroidStudio()) {
            project = ProjectManager.getInstance().getDefaultProject();
            AndroidShowStructureSettingsAction.showAndroidProjectStructure(project);
            return;
        }
        if (project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            AndroidShowStructureSettingsAction.showAndroidProjectStructure(project);
            return;
        }
        super.actionPerformed(e);
    }

    private static void showAndroidProjectStructure(@NotNull Project project) {
        if (project == null) {
            AndroidShowStructureSettingsAction.$$$reportNull$$$0(0);
        }
        if (GradleExperimentalSettings.getInstance().USE_NEW_PROJECT_STRUCTURE_DIALOG) {
            ProjectStructureConfigurable projectStructure = ProjectStructureConfigurable.getInstance(project);
            AtomicBoolean needsSync = new AtomicBoolean();
            ProjectStructureConfigurable.ProjectStructureChangeListener changeListener = () -> needsSync.set(true);
            projectStructure.add(changeListener);
            projectStructure.showDialog();
            projectStructure.remove(changeListener);
            if (needsSync.get()) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
            }
            return;
        }
        AndroidProjectStructureConfigurable.getInstance(project).showDialog();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/AndroidShowStructureSettingsAction", "showAndroidProjectStructure"));
    }
}

