/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleValue;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleBuildModel
extends GradleFileModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NotNull
    private List<GradleDslExpressionMap> myToBeAppliedPlugins;

    @Nullable
    public static GradleBuildModel get(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            GradleBuildModel.$$$reportNull$$$0(0);
        }
        return (file = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath(project))) != null ? GradleBuildModel.parseBuildFile(file, project, project.getName()) : null;
    }

    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        VirtualFile file;
        if (module == null) {
            GradleBuildModel.$$$reportNull$$$0(1);
        }
        return (file = GradleUtil.getGradleBuildFile(module)) != null ? GradleBuildModel.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            GradleBuildModel.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GradleBuildModel.$$$reportNull$$$0(3);
        }
        GradleBuildModel gradleBuildModel = GradleBuildModel.parseBuildFile(file, project, "<Unknown>");
        if (gradleBuildModel == null) {
            GradleBuildModel.$$$reportNull$$$0(4);
        }
        return gradleBuildModel;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            GradleBuildModel.$$$reportNull$$$0(5);
        }
        if (project == null) {
            GradleBuildModel.$$$reportNull$$$0(6);
        }
        if (moduleName == null) {
            GradleBuildModel.$$$reportNull$$$0(7);
        }
        GradleBuildDslFile buildDslFile = new GradleBuildDslFile(file, project, moduleName);
        ApplicationManager.getApplication().runReadAction(() -> {
            GradleBuildModel.populateWithParentModuleSubProjectsProperties(buildDslFile);
            GradleBuildModel.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile);
            buildDslFile.parse();
        });
        GradleBuildModel gradleBuildModel = new GradleBuildModel(buildDslFile);
        if (gradleBuildModel == null) {
            GradleBuildModel.$$$reportNull$$$0(8);
        }
        return gradleBuildModel;
    }

    private static void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildDslFile buildDslFile) {
        GradleSettingsModel gradleSettingsModel;
        if (buildDslFile == null) {
            GradleBuildModel.$$$reportNull$$$0(9);
        }
        if ((gradleSettingsModel = GradleSettingsModel.get(buildDslFile.getProject())) == null) {
            return;
        }
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (parentModuleModel == null) {
            return;
        }
        GradleDslFile parentModuleDslFile = parentModuleModel.myGradleDslFile;
        buildDslFile.setParentModuleDslFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getPropertyElement("subprojects", SubProjectsDslElement.class);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.setParsedElement("subprojects", subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            buildDslFile.setParsedElement(entry.getKey(), entry.getValue());
        }
    }

    private static void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildDslFile buildDslFile) {
        File propertiesFilePath;
        VirtualFile propertiesFile;
        if (buildDslFile == null) {
            GradleBuildModel.$$$reportNull$$$0(10);
        }
        if ((propertiesFile = VfsUtil.findFileByIoFile((File)(propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties")), (boolean)true)) == null) {
            return;
        }
        GradlePropertiesModel propertiesModel = GradlePropertiesModel.parsePropertiesFile(propertiesFile, buildDslFile.getProject(), buildDslFile.getName());
        if (propertiesModel == null) {
            return;
        }
        GradleDslFile propertiesDslFile = propertiesModel.myGradleDslFile;
        buildDslFile.setSiblingDslFile(propertiesDslFile);
        propertiesDslFile.setSiblingDslFile(buildDslFile);
    }

    private GradleBuildModel(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            GradleBuildModel.$$$reportNull$$$0(11);
        }
        super(buildDslFile);
        this.myToBeAppliedPlugins = new ArrayList<GradleDslExpressionMap>();
    }

    @NotNull
    public List<GradleNotNullValue<String>> appliedPlugins() {
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleBuildModel.$$$reportNull$$$0(12);
            }
            return immutableList;
        }
        List<GradleNotNullValue<String>> listProperty = applyDslElement.getListProperty(PLUGIN, String.class);
        if (listProperty == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleBuildModel.$$$reportNull$$$0(13);
            }
            return immutableList;
        }
        ArrayList<GradleNotNullValue<String>> plugins = new ArrayList<GradleNotNullValue<String>>();
        HashSet pluginValues = new HashSet();
        for (GradleNotNullValue<String> plugin : listProperty) {
            if (!pluginValues.add(plugin.value())) continue;
            plugins.add(plugin);
        }
        for (GradleDslExpressionMap toBeAppliedPlugin : this.myToBeAppliedPlugins) {
            GradleNullableValue<String> plugin = toBeAppliedPlugin.getLiteralProperty(PLUGIN, String.class);
            assert (plugin instanceof GradleNotNullValue);
            if (!pluginValues.add(plugin.value())) continue;
            plugins.add((GradleNotNullValue)plugin);
        }
        ArrayList<GradleNotNullValue<String>> arrayList = plugins;
        if (arrayList == null) {
            GradleBuildModel.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public GradleBuildModel applyPlugin(@NotNull String plugin) {
        if (plugin == null) {
            GradleBuildModel.$$$reportNull$$$0(15);
        }
        if (GradleValue.getValues(this.appliedPlugins()).contains(plugin.trim())) {
            GradleBuildModel gradleBuildModel = this;
            if (gradleBuildModel == null) {
                GradleBuildModel.$$$reportNull$$$0(16);
            }
            return gradleBuildModel;
        }
        GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, "apply");
        applyMap.addNewLiteral(PLUGIN, plugin.trim());
        this.myToBeAppliedPlugins.add(applyMap);
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            GradleBuildModel.$$$reportNull$$$0(17);
        }
        return gradleBuildModel;
    }

    @NotNull
    public GradleBuildModel removePlugin(@NotNull String plugin) {
        if (plugin == null) {
            GradleBuildModel.$$$reportNull$$$0(18);
        }
        plugin = plugin.trim();
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            GradleBuildModel gradleBuildModel = this;
            if (gradleBuildModel == null) {
                GradleBuildModel.$$$reportNull$$$0(19);
            }
            return gradleBuildModel;
        }
        ArrayList<GradleDslExpressionMap> toBeRemovedPlugins = new ArrayList<GradleDslExpressionMap>();
        for (GradleDslExpressionMap applyMap : this.myToBeAppliedPlugins) {
            if (!plugin.equals(applyMap.getLiteralProperty(PLUGIN, String.class).value())) continue;
            toBeRemovedPlugins.add(applyMap);
        }
        this.myToBeAppliedPlugins.removeAll(toBeRemovedPlugins);
        while (GradleValue.getValues(applyDslElement.getListProperty(PLUGIN, String.class)).contains(plugin)) {
            applyDslElement.removeFromExpressionList(PLUGIN, plugin);
        }
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            GradleBuildModel.$$$reportNull$$$0(20);
        }
        return gradleBuildModel;
    }

    @Nullable
    public AndroidModel android() {
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.find(this.myGradleDslFile.getProject());
        if (androidPluginInfo != null && androidPluginInfo.isExperimental()) {
            return null;
        }
        AndroidDslElement androidDslElement = this.myGradleDslFile.getPropertyElement("android", AndroidDslElement.class);
        if (androidDslElement == null) {
            androidDslElement = new AndroidDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("android", androidDslElement);
        }
        return new AndroidModel(androidDslElement);
    }

    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.getPropertyElement("buildscript", BuildScriptDslElement.class);
        if (buildScriptDslElement == null) {
            buildScriptDslElement = new BuildScriptDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("buildscript", buildScriptDslElement);
        }
        BuildScriptModel buildScriptModel = new BuildScriptModel(buildScriptDslElement);
        if (buildScriptModel == null) {
            GradleBuildModel.$$$reportNull$$$0(21);
        }
        return buildScriptModel;
    }

    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.getPropertyElement("dependencies", DependenciesDslElement.class);
        if (dependenciesDslElement == null) {
            dependenciesDslElement = new DependenciesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("dependencies", dependenciesDslElement);
        }
        return new DependenciesModel(dependenciesDslElement);
    }

    @NotNull
    public ExtModel ext() {
        ExtDslElement extDslElement = this.myGradleDslFile.getPropertyElement("ext", ExtDslElement.class);
        if (extDslElement == null) {
            extDslElement = new ExtDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("ext", extDslElement);
        }
        ExtModel extModel = new ExtModel(extDslElement);
        if (extModel == null) {
            GradleBuildModel.$$$reportNull$$$0(22);
        }
        return extModel;
    }

    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.getPropertyElement("java", JavaDslElement.class);
        if (javaDslElement == null) {
            javaDslElement = new JavaDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("java", javaDslElement);
        }
        JavaModel javaModel = new JavaModel(javaDslElement);
        if (javaModel == null) {
            GradleBuildModel.$$$reportNull$$$0(23);
        }
        return javaModel;
    }

    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.getPropertyElement("repositories", RepositoriesDslElement.class);
        if (repositoriesDslElement == null) {
            repositoriesDslElement = new RepositoriesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("repositories", repositoriesDslElement);
        }
        RepositoriesModel repositoriesModel = new RepositoriesModel(repositoriesDslElement);
        if (repositoriesModel == null) {
            GradleBuildModel.$$$reportNull$$$0(24);
        }
        return repositoriesModel;
    }

    @Override
    public void resetState() {
        this.myToBeAppliedPlugins.clear();
        super.resetState();
    }

    @Override
    public void applyChanges() {
        for (GradleDslExpressionMap applyMap : this.myToBeAppliedPlugins) {
            applyMap.create();
            applyMap.applyChanges();
            this.myGradleDslFile.addParsedElement("apply", applyMap);
        }
        this.myToBeAppliedPlugins.clear();
        super.applyChanges();
    }

    public void removeRepositoriesBlocks() {
        this.myGradleDslFile.removeProperty("repositories");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = PLUGIN;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModel";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBuildFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "appliedPlugins";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPlugin";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "removePlugin";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildscript";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "ext";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "java";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildFile";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "populateWithParentModuleSubProjectsProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "populateSiblingDslFileWithGradlePropertiesFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyPlugin";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removePlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GradleBuildDslFile
    extends GradleDslFile {
        private GradleBuildDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            if (file == null) {
                GradleBuildDslFile.$$$reportNull$$$0(0);
            }
            if (project == null) {
                GradleBuildDslFile.$$$reportNull$$$0(1);
            }
            if (moduleName == null) {
                GradleBuildDslFile.$$$reportNull$$$0(2);
            }
            super(file, project, moduleName);
        }

        @Override
        public void reparse() {
            super.reparse();
        }

        @Override
        protected void parse(@NotNull GroovyFile psiFile) {
            if (psiFile == null) {
                GradleBuildDslFile.$$$reportNull$$$0(3);
            }
            psiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

                public void visitMethodCallExpression(GrMethodCallExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitAssignmentExpression(GrAssignmentExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitApplicationStatement(GrApplicationStatement e) {
                    this.process((GroovyPsiElement)e);
                }

                void process(GroovyPsiElement e) {
                    GradleDslParser.parse(e, this);
                }
            }));
        }

        @Override
        public void addParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property == null) {
                GradleBuildDslFile.$$$reportNull$$$0(4);
            }
            if (element == null) {
                GradleBuildDslFile.$$$reportNull$$$0(5);
            }
            if ("apply".equals(property) && element instanceof GradleDslExpressionMap) {
                ApplyDslElement applyDslElement = this.getPropertyElement("apply", ApplyDslElement.class);
                if (applyDslElement == null) {
                    applyDslElement = new ApplyDslElement(this);
                    super.addParsedElement("apply", applyDslElement);
                }
                for (Map.Entry<String, GradleDslElement> entry : ((GradleDslExpressionMap)element).getPropertyElements().entrySet()) {
                    applyDslElement.addParsedElement(entry.getKey(), entry.getValue());
                }
                return;
            }
            super.addParsedElement(property, element);
        }

        @Override
        public void setParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property == null) {
                GradleBuildDslFile.$$$reportNull$$$0(6);
            }
            if (element == null) {
                GradleBuildDslFile.$$$reportNull$$$0(7);
            }
            if (("sourceCompatibility".equals(property) || "targetCompatibility".equals(property)) && (element instanceof GradleDslLiteral || element instanceof GradleDslReference)) {
                JavaDslElement javaDslElement = this.getPropertyElement("java", JavaDslElement.class);
                if (javaDslElement == null) {
                    javaDslElement = new JavaDslElement(this);
                    super.setParsedElement("java", javaDslElement);
                }
                javaDslElement.setParsedElement(property, element);
                return;
            }
            super.setParsedElement(property, element);
        }

        @Override
        protected void reset() {
            super.reset();
        }

        @Override
        protected void apply() {
            super.apply();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addParsedElement";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setParsedElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

