/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.settings.AndroidStudioGradleProjectSettings;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.collect.ImmutableList;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProjectInfo {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myProjectInfo;
    @NotNull
    private final AndroidStudioGradleProjectSettings myGradleProjectSettings;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    @NotNull
    private final AtomicReference<String> myProjectCreationErrorRef;
    private volatile boolean myIsNewOrImportedProject;
    private final ProjectFacetManager myFacetManager;

    @NotNull
    public static GradleProjectInfo getInstance(@NotNull Project project) {
        if (project == null) {
            GradleProjectInfo.$$$reportNull$$$0(0);
        }
        GradleProjectInfo gradleProjectInfo = (GradleProjectInfo)ServiceManager.getService((Project)project, GradleProjectInfo.class);
        if (gradleProjectInfo == null) {
            GradleProjectInfo.$$$reportNull$$$0(1);
        }
        return gradleProjectInfo;
    }

    public GradleProjectInfo(@NotNull Project project, @NotNull AndroidProjectInfo projectInfo, @NotNull AndroidStudioGradleProjectSettings gradleProjectSettings, @NotNull ProjectFileIndex projectFileIndex) {
        if (project == null) {
            GradleProjectInfo.$$$reportNull$$$0(2);
        }
        if (projectInfo == null) {
            GradleProjectInfo.$$$reportNull$$$0(3);
        }
        if (gradleProjectSettings == null) {
            GradleProjectInfo.$$$reportNull$$$0(4);
        }
        if (projectFileIndex == null) {
            GradleProjectInfo.$$$reportNull$$$0(5);
        }
        this.myProjectCreationErrorRef = new AtomicReference();
        this.myProject = project;
        this.myProjectInfo = projectInfo;
        this.myGradleProjectSettings = gradleProjectSettings;
        this.myProjectFileIndex = projectFileIndex;
        this.myFacetManager = ProjectFacetManager.getInstance((Project)this.myProject);
    }

    public boolean canUseLocalMavenRepo() {
        return !this.myGradleProjectSettings.DISABLE_EMBEDDED_MAVEN_REPO;
    }

    public boolean isNewOrImportedProject() {
        return this.myIsNewOrImportedProject;
    }

    public void setNewOrImportedProject(boolean newOrImportedProject) {
        this.myIsNewOrImportedProject = newOrImportedProject;
    }

    @Nullable
    public String getProjectCreationError() {
        return this.myProjectCreationErrorRef.get();
    }

    public void setProjectCreationError(@Nullable String error) {
        this.myProjectCreationErrorRef.set(error);
    }

    public boolean isDirectGradleBuildEnabled() {
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(this.myProject);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public boolean isBuildWithGradle() {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myFacetManager.hasFacets(GradleFacet.getFacetTypeId())) {
                return true;
            }
            if (GradleSyncState.getInstance(this.myProject).getSummary().getSyncTimestamp() != -1L) {
                return true;
            }
            return this.hasTopLevelGradleBuildFile();
        });
    }

    public boolean hasTopLevelGradleBuildFile() {
        if (this.myProject.isDefault()) {
            return false;
        }
        VirtualFile baseDir = this.myProject.getBaseDir();
        VirtualFile buildGradle = baseDir == null ? null : baseDir.findChild("build.gradle");
        return buildGradle != null && !buildGradle.isDirectory();
    }

    @NotNull
    public List<Module> getAndroidModules() {
        ImmutableList.Builder modules = ImmutableList.builder();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (AndroidFacet.getInstance(module) == null || GradleFacet.getInstance(module) == null) continue;
                modules.add((Object)module);
            }
        });
        ImmutableList immutableList = modules.build();
        if (immutableList == null) {
            GradleProjectInfo.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    public void forEachAndroidModule(@NotNull Consumer<AndroidFacet> consumer) {
        if (consumer == null) {
            GradleProjectInfo.$$$reportNull$$$0(7);
        }
        ReadAction.run(() -> {
            if (consumer == null) {
                GradleProjectInfo.$$$reportNull$$$0(12);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null || GradleFacet.getInstance(module) == null) continue;
                consumer.consume((Object)androidFacet);
            }
        });
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file) {
        if (file == null) {
            GradleProjectInfo.$$$reportNull$$$0(8);
        }
        return this.findAndroidModelInModule(file, true);
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file, boolean honorExclusion) {
        Module module;
        if (file == null) {
            GradleProjectInfo.$$$reportNull$$$0(9);
        }
        if ((module = this.findModuleForFile(file, honorExclusion)) == null) {
            VirtualFile rootFolder;
            if (this.myProjectInfo.requiresAndroidModel() && (rootFolder = this.myProject.getBaseDir()) != null) {
                for (VirtualFile parent = file.getParent(); parent != null && parent.equals(rootFolder) && (module = this.findModuleForFile(file, honorExclusion)) == null; parent = parent.getParent()) {
                }
            }
            if (module == null) {
                return null;
            }
        }
        if (module.isDisposed()) {
            this.getLog().warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        return AndroidModuleModel.get(module);
    }

    @Nullable
    private Module findModuleForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        if (file == null) {
            GradleProjectInfo.$$$reportNull$$$0(10);
        }
        return this.myProjectFileIndex.getModuleForFile(file, honorExclusion);
    }

    @NotNull
    private Logger getLog() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            GradleProjectInfo.$$$reportNull$$$0(11);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/GradleProjectInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileIndex";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/GradleProjectInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidModules";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forEachAndroidModule";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAndroidModelInModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forEachAndroidModule$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

