/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android.level2;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.builder.model.level2.GraphItem;
import com.android.builder.model.level2.Library;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeLibraries;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.level2.BuildFolderPaths;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependencies;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependenciesImpl;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeLibraryFactory;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeDependenciesFactory {
    @NotNull
    private final Map<String, Library> myLibrariesById = new HashMap<String, Library>();
    @NotNull
    private final IdeLibraryFactory myLibraryFactory = new IdeLibraryFactory();
    @NotNull
    private final BuildFolderPaths myBuildFolderPaths = new BuildFolderPaths();

    public void findAndAddBuildFolderPath(@NotNull GradleProject gradleProject) {
        if (gradleProject == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(0);
        }
        this.myBuildFolderPaths.add(gradleProject);
    }

    public IdeDependencies create(@NotNull BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        if (artifact == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(1);
        }
        ModelCache modelCache = new ModelCache();
        if (modelVersion != null && modelVersion.getMajor() >= 3 && NewGradleSync.isLevel4Model()) {
            return this.createFromDependencyGraphs(artifact.getDependencyGraphs());
        }
        return this.createFromDependencies(artifact.getDependencies(), modelCache);
    }

    @NotNull
    IdeDependencies createFromDependencyGraphs(@NotNull DependencyGraphs graphs) {
        if (graphs == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(2);
        }
        IdeDependencies ideDependencies = this.createInstance(graphs.getCompileDependencies().stream().map(GraphItem::getArtifactAddress).collect(Collectors.toList()));
        if (ideDependencies == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(3);
        }
        return ideDependencies;
    }

    @NotNull
    private IdeDependencies createFromDependencies(@NotNull Dependencies dependencies2, @NotNull ModelCache modelCache) {
        if (dependencies2 == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(4);
        }
        if (modelCache == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(5);
        }
        HashSet<String> visited = new HashSet<String>();
        this.populateAndroidLibraries(dependencies2.getLibraries(), visited, modelCache);
        this.populateJavaLibraries(dependencies2.getJavaLibraries(), visited, modelCache);
        for (String projectPath : dependencies2.getProjects()) {
            if (visited.contains(projectPath)) continue;
            visited.add(projectPath);
            this.myLibrariesById.computeIfAbsent(projectPath, id -> {
                if (modelCache == null) {
                    IdeDependenciesFactory.$$$reportNull$$$0(20);
                }
                return IdeLibraryFactory.create(projectPath, modelCache);
            });
        }
        IdeDependencies ideDependencies = this.createInstance(visited);
        if (ideDependencies == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(6);
        }
        return ideDependencies;
    }

    private void populateAndroidLibraries(@NotNull Collection<? extends AndroidLibrary> androidLibraries, @NotNull Set<String> visited, @NotNull ModelCache modelCache) {
        if (androidLibraries == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(7);
        }
        if (visited == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(8);
        }
        if (modelCache == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(9);
        }
        for (AndroidLibrary androidLibrary : androidLibraries) {
            String address = IdeLibraries.computeAddress((com.android.builder.model.Library)androidLibrary);
            if (visited.contains(address)) continue;
            visited.add(address);
            this.myLibrariesById.computeIfAbsent(address, id -> {
                if (modelCache == null) {
                    IdeDependenciesFactory.$$$reportNull$$$0(19);
                }
                return this.myLibraryFactory.create(androidLibrary, this.myBuildFolderPaths, modelCache);
            });
            this.populateAndroidLibraries(androidLibrary.getLibraryDependencies(), visited, modelCache);
            this.populateJavaLibraries(IdeDependenciesFactory.getJavaDependencies(androidLibrary), visited, modelCache);
        }
    }

    @NotNull
    private static Collection<? extends JavaLibrary> getJavaDependencies(AndroidLibrary androidLibrary) {
        Collection collection;
        try {
            collection = androidLibrary.getJavaDependencies();
        }
        catch (UnsupportedMethodException e) {
            List list = Collections.emptyList();
            if (list == null) {
                IdeDependenciesFactory.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (collection == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(10);
        }
        return collection;
    }

    private void populateJavaLibraries(@NotNull Collection<? extends JavaLibrary> javaLibraries, @NotNull Set<String> visited, @NotNull ModelCache modelCache) {
        if (javaLibraries == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(12);
        }
        if (visited == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(13);
        }
        if (modelCache == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(14);
        }
        for (JavaLibrary javaLibrary : javaLibraries) {
            String address = IdeLibraries.computeAddress((com.android.builder.model.Library)javaLibrary);
            if (visited.contains(address)) continue;
            visited.add(address);
            this.myLibrariesById.computeIfAbsent(address, k -> {
                if (modelCache == null) {
                    IdeDependenciesFactory.$$$reportNull$$$0(18);
                }
                return this.myLibraryFactory.create(javaLibrary, modelCache);
            });
            this.populateJavaLibraries(javaLibrary.getDependencies(), visited, modelCache);
        }
    }

    @NotNull
    private IdeDependencies createInstance(@NotNull Collection<String> artifactAddresses) {
        if (artifactAddresses == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(15);
        }
        ImmutableList.Builder androidLibraries = ImmutableList.builder();
        ImmutableList.Builder javaLibraries = ImmutableList.builder();
        ImmutableList.Builder moduleDependencies = ImmutableList.builder();
        block5: for (String address : artifactAddresses) {
            Library library = this.myLibrariesById.get(address);
            assert (library != null);
            switch (library.getType()) {
                case 1: {
                    androidLibraries.add((Object)library);
                    continue block5;
                }
                case 2: {
                    javaLibraries.add((Object)library);
                    continue block5;
                }
                case 3: {
                    moduleDependencies.add((Object)library);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown library type " + library.getType());
        }
        IdeDependenciesImpl ideDependenciesImpl = new IdeDependenciesImpl((ImmutableList<Library>)androidLibraries.build(), (ImmutableList<Library>)javaLibraries.build(), (ImmutableList<Library>)moduleDependencies.build());
        if (ideDependenciesImpl == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(16);
        }
        return ideDependenciesImpl;
    }

    public void setupGlobalLibraryMap(@NotNull GlobalLibraryMap globalLibraryMap) {
        if (globalLibraryMap == null) {
            IdeDependenciesFactory.$$$reportNull$$$0(17);
        }
        ModelCache modelCache = new ModelCache();
        for (Library library : globalLibraryMap.getLibraries().values()) {
            this.myLibrariesById.computeIfAbsent(library.getArtifactAddress(), k -> this.myLibraryFactory.create(library, modelCache));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphs";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/ide/android/level2/IdeDependenciesFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidLibraries";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaLibraries";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactAddresses";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalLibraryMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/ide/android/level2/IdeDependenciesFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromDependencyGraphs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromDependencies";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAndAddBuildFolderPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFromDependencyGraphs";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFromDependencies";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "populateAndroidLibraries";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "populateJavaLibraries";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupGlobalLibraryMap";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$populateJavaLibraries$2";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$populateAndroidLibraries$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createFromDependencies$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

