/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncSummary;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.project.IndexingSuspender;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.Utils;

public class GradleSyncState {
    private static final Logger LOG = Logger.getInstance(GradleSyncState.class);
    private static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"Gradle sync");
    @VisibleForTesting
    static final Topic<GradleSyncListener> GRADLE_SYNC_TOPIC = new Topic("Project sync with Gradle", GradleSyncListener.class);
    private static final int INDEXING_WAIT_TIMEOUT_MILLIS = 5000;
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final StateChangeNotification myChangeNotification;
    @NotNull
    private final GradleSyncSummary mySummary;
    @NotNull
    private final GradleFiles myGradleFiles;
    @NotNull
    private final Object myLock;
    @NotNull
    private final Object myIndexingLock;
    private boolean myFlagIsIndexingAware;
    @GuardedBy(value="myLock")
    private boolean mySyncNotificationsEnabled;
    @GuardedBy(value="myLock")
    private boolean mySyncSkipped;
    @GuardedBy(value="myLock")
    private boolean mySyncInProgress;
    private long mySyncStartedTimestamp;
    private long mySyncSetupStartedTimeStamp;
    private long mySyncEndedTimeStamp;
    private long mySyncFailedTimeStamp;
    private GradleSyncStats.Trigger myTrigger;

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleSyncListener listener) {
        if (project == null) {
            GradleSyncState.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            GradleSyncState.$$$reportNull$$$0(1);
        }
        MessageBusConnection messageBusConnection = GradleSyncState.subscribe(project, listener, (Disposable)project);
        if (messageBusConnection == null) {
            GradleSyncState.$$$reportNull$$$0(2);
        }
        return messageBusConnection;
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleSyncListener listener, @NotNull Disposable parentDisposable) {
        if (project == null) {
            GradleSyncState.$$$reportNull$$$0(3);
        }
        if (listener == null) {
            GradleSyncState.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            GradleSyncState.$$$reportNull$$$0(5);
        }
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(GRADLE_SYNC_TOPIC, (Object)listener);
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            GradleSyncState.$$$reportNull$$$0(6);
        }
        return messageBusConnection;
    }

    @NotNull
    public static GradleSyncState getInstance(@NotNull Project project) {
        if (project == null) {
            GradleSyncState.$$$reportNull$$$0(7);
        }
        GradleSyncState gradleSyncState = (GradleSyncState)ServiceManager.getService((Project)project, GradleSyncState.class);
        if (gradleSyncState == null) {
            GradleSyncState.$$$reportNull$$$0(8);
        }
        return gradleSyncState;
    }

    public GradleSyncState(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleFiles gradleFiles, @NotNull MessageBus messageBus) {
        if (project == null) {
            GradleSyncState.$$$reportNull$$$0(9);
        }
        if (androidProjectInfo == null) {
            GradleSyncState.$$$reportNull$$$0(10);
        }
        if (gradleProjectInfo == null) {
            GradleSyncState.$$$reportNull$$$0(11);
        }
        if (gradleFiles == null) {
            GradleSyncState.$$$reportNull$$$0(12);
        }
        if (messageBus == null) {
            GradleSyncState.$$$reportNull$$$0(13);
        }
        this(project, androidProjectInfo, gradleProjectInfo, gradleFiles, messageBus, new StateChangeNotification(project), new GradleSyncSummary(project));
    }

    @VisibleForTesting
    GradleSyncState(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleFiles gradleFiles, @NotNull MessageBus messageBus, @NotNull StateChangeNotification changeNotification, @NotNull GradleSyncSummary summary) {
        if (project == null) {
            GradleSyncState.$$$reportNull$$$0(14);
        }
        if (androidProjectInfo == null) {
            GradleSyncState.$$$reportNull$$$0(15);
        }
        if (gradleProjectInfo == null) {
            GradleSyncState.$$$reportNull$$$0(16);
        }
        if (gradleFiles == null) {
            GradleSyncState.$$$reportNull$$$0(17);
        }
        if (messageBus == null) {
            GradleSyncState.$$$reportNull$$$0(18);
        }
        if (changeNotification == null) {
            GradleSyncState.$$$reportNull$$$0(19);
        }
        if (summary == null) {
            GradleSyncState.$$$reportNull$$$0(20);
        }
        this.myLock = new Object();
        this.myIndexingLock = new Object();
        this.myFlagIsIndexingAware = StudioFlags.GRADLE_INVOCATIONS_INDEXING_AWARE.get();
        this.mySyncStartedTimestamp = -1L;
        this.mySyncSetupStartedTimeStamp = -1L;
        this.mySyncEndedTimeStamp = -1L;
        this.mySyncFailedTimeStamp = -1L;
        this.myTrigger = GradleSyncStats.Trigger.TRIGGER_UNKNOWN;
        this.myProject = project;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myMessageBus = messageBus;
        this.myChangeNotification = changeNotification;
        this.mySummary = summary;
        this.myGradleFiles = gradleFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areSyncNotificationsEnabled() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncNotificationsEnabled;
        }
    }

    public boolean skippedSyncStarted(boolean notifyUser, GradleSyncStats.Trigger trigger) {
        return this.syncStarted(true, notifyUser, trigger);
    }

    public boolean syncStarted(boolean notifyUser, GradleSyncStats.Trigger trigger) {
        return this.syncStarted(false, notifyUser, trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncStarted(boolean syncSkipped, boolean notifyUser, GradleSyncStats.Trigger trigger) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySyncInProgress) {
                LOG.info(String.format("Sync already in progress for project '%1$s'.", this.myProject.getName()));
                return false;
            }
            this.mySyncSkipped = syncSkipped;
            this.mySyncInProgress = true;
            this.myFlagIsIndexingAware = StudioFlags.GRADLE_INVOCATIONS_INDEXING_AWARE.get();
            this.ensureNoIndexingDuringSync();
        }
        LOG.info(String.format("Started sync with Gradle for project '%1$s'.", this.myProject.getName()));
        this.setSyncStartedTimeStamp(System.currentTimeMillis(), trigger);
        this.addInfoToEventLog("Gradle sync started");
        if (notifyUser) {
            this.notifyStateChanged();
        }
        this.mySummary.reset();
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncStarted(this.myProject));
        AndroidStudioEvent.Builder event = this.generateSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_STARTED);
        UsageTracker.getInstance().log(event);
        return true;
    }

    private void ensureNoIndexingDuringSync() {
        if (this.myFlagIsIndexingAware) {
            IndexingSuspender.queue(this.myProject, "Gradle Sync", this.myIndexingLock, this::isSyncInProgress, 5000);
        }
    }

    @VisibleForTesting
    void setSyncStartedTimeStamp(long timeStampMs, GradleSyncStats.Trigger trigger) {
        this.mySyncStartedTimestamp = timeStampMs;
        this.mySyncSetupStartedTimeStamp = -1L;
        this.mySyncEndedTimeStamp = -1L;
        this.mySyncFailedTimeStamp = -1L;
        this.myTrigger = trigger;
    }

    @VisibleForTesting
    void setSyncSetupStartedTimeStamp(long timeStampMs) {
        this.mySyncSetupStartedTimeStamp = timeStampMs;
    }

    @VisibleForTesting
    void setSyncEndedTimeStamp(long timeStampMs) {
        this.mySyncEndedTimeStamp = timeStampMs;
    }

    @VisibleForTesting
    void setSyncFailedTimeStamp(long timeStampMs) {
        this.mySyncFailedTimeStamp = timeStampMs;
    }

    public void syncSkipped(long lastSyncTimestamp) {
        long syncEndTimestamp = System.currentTimeMillis();
        this.setSyncEndedTimeStamp(syncEndTimestamp);
        String msg = String.format("Gradle sync finished in %1$s (from cached state)", this.getFormattedSyncDuration(syncEndTimestamp));
        this.addInfoToEventLog(msg);
        LOG.info(msg);
        this.stopSyncInProgress();
        this.mySummary.setSyncTimestamp(lastSyncTimestamp);
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSkipped(this.myProject));
        this.enableNotifications();
        AndroidStudioEvent.Builder event = this.generateSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_SKIPPED);
        UsageTracker.getInstance().log(event);
    }

    public void invalidateLastSync(@NotNull String error) {
        if (error == null) {
            GradleSyncState.$$$reportNull$$$0(21);
        }
        this.syncFailed(error);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            facet.setAndroidModel(null);
        }
    }

    public void syncFailed(@NotNull String message) {
        if (message == null) {
            GradleSyncState.$$$reportNull$$$0(22);
        }
        long syncEndTimestamp = System.currentTimeMillis();
        if (this.mySyncStartedTimestamp == -1L) {
            this.syncFinished(syncEndTimestamp);
            return;
        }
        this.setSyncFailedTimeStamp(syncEndTimestamp);
        String msg = "Gradle sync failed";
        if (StringUtil.isNotEmpty((String)message)) {
            msg = msg + String.format(": %1$s", message);
        }
        msg = msg + String.format(" (%1$s)", this.getFormattedSyncDuration(syncEndTimestamp));
        this.addToEventLog(msg, MessageType.ERROR);
        LOG.info(msg);
        AndroidStudioEvent.Builder event = this.generateSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE);
        UsageTracker.getInstance().log(event);
        this.syncFinished(syncEndTimestamp);
        this.syncPublisher(() -> {
            if (message == null) {
                GradleSyncState.$$$reportNull$$$0(33);
            }
            ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncFailed(this.myProject, message);
        });
        this.mySummary.setSyncErrorsFound(true);
    }

    public void syncEnded() {
        assert (!this.lastSyncFailedOrHasIssues());
        long syncEndTimestamp = System.currentTimeMillis();
        if (this.mySyncStartedTimestamp == -1L) {
            this.syncFinished(syncEndTimestamp);
            return;
        }
        this.setSyncEndedTimeStamp(syncEndTimestamp);
        String msg = String.format("Gradle sync finished in %1$s", this.getFormattedSyncDuration(syncEndTimestamp));
        this.addInfoToEventLog(msg);
        LOG.info(msg);
        LintUtils.sTryPrefixLookup = true;
        GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(this.myProject);
        String gradleVersionString = gradleVersion != null ? gradleVersion.toString() : "";
        AndroidStudioEvent.Builder event = this.generateSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_ENDED).setGradleVersion(gradleVersionString);
        UsageTracker.getInstance().log(event);
        this.syncFinished(syncEndTimestamp);
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSucceeded(this.myProject));
    }

    private long getSyncDurationMS(long syncEndTimestamp) {
        return syncEndTimestamp - this.mySyncStartedTimestamp;
    }

    @VisibleForTesting
    @NotNull
    String getFormattedSyncDuration(long syncEndTimestamp) {
        String string = Utils.formatDuration((long)this.getSyncDurationMS(syncEndTimestamp));
        if (string == null) {
            GradleSyncState.$$$reportNull$$$0(23);
        }
        return string;
    }

    private void addInfoToEventLog(@NotNull String message) {
        if (message == null) {
            GradleSyncState.$$$reportNull$$$0(24);
        }
        this.addToEventLog(message, MessageType.INFO);
    }

    private void addToEventLog(@NotNull String message, @NotNull MessageType type) {
        if (message == null) {
            GradleSyncState.$$$reportNull$$$0(25);
        }
        if (type == null) {
            GradleSyncState.$$$reportNull$$$0(26);
        }
        LOGGING_NOTIFICATION.createNotification(message, type).notify(this.myProject);
    }

    private void syncFinished(long timestamp) {
        this.stopSyncInProgress();
        this.mySyncStartedTimestamp = -1L;
        this.mySummary.setSyncTimestamp(timestamp);
        this.enableNotifications();
        this.notifyStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSyncInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncInProgress = false;
            this.mySyncSkipped = false;
            this.unblockIndexing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblockIndexing() {
        if (this.myFlagIsIndexingAware) {
            Object object = this.myIndexingLock;
            synchronized (object) {
                this.myIndexingLock.notifyAll();
            }
        }
    }

    private void syncPublisher(@NotNull Runnable publishingTask) {
        if (publishingTask == null) {
            GradleSyncState.$$$reportNull$$$0(27);
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)publishingTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableNotifications() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncNotificationsEnabled = true;
        }
    }

    public void notifyStateChanged() {
        this.myChangeNotification.notifyStateChanged();
    }

    public boolean lastSyncFailedOrHasIssues() {
        boolean lastSyncFailed = this.lastSyncFailed();
        boolean hasSyncErrors = this.mySummary.hasSyncErrors();
        return lastSyncFailed || hasSyncErrors;
    }

    public boolean lastSyncFailed() {
        return !this.isSyncInProgress() && this.myGradleProjectInfo.isBuildWithGradle() && (this.myAndroidProjectInfo.requiredAndroidModelMissing() || this.mySummary.hasSyncErrors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncSkipped() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncSkipped;
        }
    }

    @NotNull
    public ThreeState isSyncNeeded() {
        long lastSync = this.mySummary.getSyncTimestamp();
        if (lastSync < 0L) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GradleSyncState.$$$reportNull$$$0(28);
            }
            return threeState;
        }
        ThreeState threeState = this.myGradleFiles.areGradleFilesModified(lastSync) ? ThreeState.YES : ThreeState.NO;
        if (threeState == null) {
            GradleSyncState.$$$reportNull$$$0(29);
        }
        return threeState;
    }

    @NotNull
    public GradleSyncSummary getSummary() {
        GradleSyncSummary gradleSyncSummary = this.mySummary;
        if (gradleSyncSummary == null) {
            GradleSyncState.$$$reportNull$$$0(30);
        }
        return gradleSyncSummary;
    }

    public void setupStarted() {
        long syncSetupTimestamp = System.currentTimeMillis();
        this.setSyncSetupStartedTimeStamp(syncSetupTimestamp);
        this.addInfoToEventLog("Project setup started");
        LOG.info(String.format("Started setup of project '%1$s'.", this.myProject.getName()));
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).setupStarted(this.myProject));
        AndroidStudioEvent.Builder event = this.generateSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_SETUP_STARTED);
        UsageTracker.getInstance().log(event);
    }

    @NotNull
    private AndroidStudioEvent.Builder generateSyncEvent(@NotNull AndroidStudioEvent.EventKind kind) {
        if (kind == null) {
            GradleSyncState.$$$reportNull$$$0(31);
        }
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
        GradleSyncStats.Builder syncStats = GradleSyncStats.newBuilder();
        syncStats.setTotalTimeMs(this.getSyncTotalTimeMs()).setIdeTimeMs(this.getSyncIdeTimeMs()).setGradleTimeMs(this.getSyncGradleTimeMs()).setTrigger(this.myTrigger);
        event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(kind).setGradleSyncStats(syncStats);
        AndroidStudioEvent.Builder builder = event;
        if (builder == null) {
            GradleSyncState.$$$reportNull$$$0(32);
        }
        return builder;
    }

    @VisibleForTesting
    long getSyncTotalTimeMs() {
        if (this.mySyncEndedTimeStamp >= 0L) {
            return this.mySyncEndedTimeStamp - this.mySyncStartedTimestamp;
        }
        if (this.mySyncFailedTimeStamp >= 0L) {
            return this.mySyncFailedTimeStamp - this.mySyncStartedTimestamp;
        }
        if (this.mySyncSetupStartedTimeStamp >= 0L) {
            return this.mySyncSetupStartedTimeStamp - this.mySyncStartedTimestamp;
        }
        return 0L;
    }

    @VisibleForTesting
    long getSyncIdeTimeMs() {
        if (this.mySyncEndedTimeStamp >= 0L) {
            if (this.mySyncSetupStartedTimeStamp >= 0L) {
                return this.mySyncEndedTimeStamp - this.mySyncSetupStartedTimeStamp;
            }
            return -1L;
        }
        return -1L;
    }

    @VisibleForTesting
    long getSyncGradleTimeMs() {
        if (this.mySyncSetupStartedTimeStamp >= 0L) {
            return this.mySyncSetupStartedTimeStamp - this.mySyncStartedTimestamp;
        }
        return -1L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/GradleSyncState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProjectInfo";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectInfo";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleFiles";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeNotification";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 22: 
            case 24: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishingTask";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleSyncState";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribe";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattedSyncDuration";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "isSyncNeeded";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSyncEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "invalidateLastSync";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "syncFailed";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addInfoToEventLog";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addToEventLog";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "generateSyncEvent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$syncFailed$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class StateChangeNotification {
        @NotNull
        private final Project myProject;

        StateChangeNotification(@NotNull Project project) {
            if (project == null) {
                StateChangeNotification.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        void notifyStateChanged() {
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> {
                VirtualFile[] files;
                EditorNotifications notifications = EditorNotifications.getInstance((Project)this.myProject);
                for (VirtualFile file : files = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
                    try {
                        notifications.updateNotifications(file);
                    }
                    catch (Throwable e) {
                        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
                        String msg = String.format("Failed to update editor notifications for file '%1$s'", filePath);
                        LOG.info(msg, e);
                    }
                }
                BuildVariantView.getInstance(this.myProject).updateContents();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncState$StateChangeNotification", "<init>"));
        }
    }
}

