/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.notification;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.pom.NonNavigatable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleNotificationExtension
implements ExternalSystemNotificationExtension {
    @NotNull
    private final SyncErrorHandler[] myErrorHandlers;

    public GradleNotificationExtension() {
        this(SyncErrorHandler.getExtensions());
    }

    @VisibleForTesting
    GradleNotificationExtension(SyncErrorHandler ... errorHandlers) {
        if (errorHandlers == null) {
            GradleNotificationExtension.$$$reportNull$$$0(0);
        }
        this.myErrorHandlers = errorHandlers;
    }

    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        ProjectSystemId projectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        if (projectSystemId == null) {
            GradleNotificationExtension.$$$reportNull$$$0(1);
        }
        return projectSystemId;
    }

    public void customize(@NotNull NotificationData notification, @NotNull Project project, @Nullable Throwable error) {
        if (notification == null) {
            GradleNotificationExtension.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GradleNotificationExtension.$$$reportNull$$$0(3);
        }
        GradleSyncMessages.getInstance(project).removeProjectMessages();
        Throwable cause = error;
        if (error instanceof UndeclaredThrowableException && (cause = ((UndeclaredThrowableException)error).getUndeclaredThrowable()) instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof ExternalSystemException) {
            this.handleError((ExternalSystemException)cause, notification, project);
        }
        if (notification.getNavigatable() == null) {
            notification.setNavigatable(NonNavigatable.INSTANCE);
        }
    }

    private void handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (error == null) {
            GradleNotificationExtension.$$$reportNull$$$0(4);
        }
        if (notification == null) {
            GradleNotificationExtension.$$$reportNull$$$0(5);
        }
        if (project == null) {
            GradleNotificationExtension.$$$reportNull$$$0(6);
        }
        for (SyncErrorHandler errorHandler : this.myErrorHandlers) {
            if (!errorHandler.handleError(error, notification, project)) continue;
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandlers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/notification/GradleNotificationExtension";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/notification/GradleNotificationExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetExternalSystemId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

