/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

abstract class ProjectSetup {
    ProjectSetup() {
    }

    abstract void setUpProject(@NotNull SyncAction.ProjectModels var1, @NotNull ProgressIndicator var2);

    abstract void commit();

    @VisibleForTesting
    static class ProjectSetupImpl
    extends ProjectSetup {
        @NotNull
        private final Project myProject;
        @NotNull
        private final IdeModifiableModelsProvider myModelsProvider;
        @NotNull
        private final ModuleSetup.Factory myModuleSetupFactory;

        ProjectSetupImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleSetup.Factory moduleSetupFactory) {
            if (project == null) {
                ProjectSetupImpl.$$$reportNull$$$0(0);
            }
            if (modelsProvider == null) {
                ProjectSetupImpl.$$$reportNull$$$0(1);
            }
            if (moduleSetupFactory == null) {
                ProjectSetupImpl.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myModelsProvider = modelsProvider;
            this.myModuleSetupFactory = moduleSetupFactory;
        }

        @Override
        void setUpProject(final @NotNull SyncAction.ProjectModels models, final @NotNull ProgressIndicator indicator) {
            if (models == null) {
                ProjectSetupImpl.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                ProjectSetupImpl.$$$reportNull$$$0(4);
            }
            final ModuleSetup moduleSetup = this.myModuleSetupFactory.create(this.myProject, this.myModelsProvider);
            try {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        moduleSetup.setUpModules(models, indicator);
                    }
                });
            }
            catch (Throwable e) {
                this.disposeChanges();
                throw e;
            }
        }

        @Override
        void commit() {
            try {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        myModelsProvider.commit();
                    }
                });
            }
            catch (Throwable e) {
                this.disposeChanges();
                throw e;
            }
        }

        private void disposeChanges() {
            ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                public void execute() {
                    myModelsProvider.dispose();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelsProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleSetupFactory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "models";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ProjectSetup$ProjectSetupImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUpProject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        ProjectSetup create(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            ProjectSetupImpl projectSetupImpl = new ProjectSetupImpl(project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), new ModuleSetup.Factory());
            if (projectSetupImpl == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return projectSetupImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/ProjectSetup$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ProjectSetup$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

