/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandlerManager;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.ng.ExtraSyncModelExtensionManager;
import com.android.tools.idea.gradle.project.sync.ng.GradleSyncProgress;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

class SyncExecutor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final SyncErrorHandlerManager myErrorHandlerManager;
    @NotNull
    private final ExtraSyncModelExtensionManager myExtraSyncModelExtensionManager;
    @NotNull
    private final GradleExecutionHelper myHelper;

    SyncExecutor(@NotNull Project project) {
        if (project == null) {
            SyncExecutor.$$$reportNull$$$0(0);
        }
        this(project, GradleSyncMessages.getInstance(project), new CommandLineArgs(true), new SyncErrorHandlerManager(project), new ExtraSyncModelExtensionManager());
    }

    @VisibleForTesting
    SyncExecutor(@NotNull Project project, @NotNull GradleSyncMessages syncMessages, @NotNull CommandLineArgs commandLineArgs, @NotNull SyncErrorHandlerManager errorHandlerManager, @NotNull ExtraSyncModelExtensionManager extraSyncModelExtensionManager) {
        if (project == null) {
            SyncExecutor.$$$reportNull$$$0(1);
        }
        if (syncMessages == null) {
            SyncExecutor.$$$reportNull$$$0(2);
        }
        if (commandLineArgs == null) {
            SyncExecutor.$$$reportNull$$$0(3);
        }
        if (errorHandlerManager == null) {
            SyncExecutor.$$$reportNull$$$0(4);
        }
        if (extraSyncModelExtensionManager == null) {
            SyncExecutor.$$$reportNull$$$0(5);
        }
        this.myHelper = new GradleExecutionHelper();
        this.myProject = project;
        this.mySyncMessages = syncMessages;
        this.myCommandLineArgs = commandLineArgs;
        this.myErrorHandlerManager = errorHandlerManager;
        this.myExtraSyncModelExtensionManager = extraSyncModelExtensionManager;
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback) {
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(7);
        }
        Runnable removeMessagesTask = () -> this.mySyncMessages.removeMessages(new String[]{null});
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            removeMessagesTask.run();
        } else {
            application.invokeAndWait(removeMessagesTask);
        }
        if (this.myProject.isDisposed()) {
            callback.reject(String.format("Project '%1$s' is already disposed", this.myProject.getName()));
        }
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(this.myProject);
        Function syncFunction = connection -> {
            if (indicator == null) {
                SyncExecutor.$$$reportNull$$$0(10);
            }
            if (callback == null) {
                SyncExecutor.$$$reportNull$$$0(11);
            }
            SyncAction syncAction = new SyncAction(this.myExtraSyncModelExtensionManager.getExtraAndroidModels(), this.myExtraSyncModelExtensionManager.getExtraJavaModels());
            BuildActionExecuter executor = connection.action((BuildAction)syncAction);
            List<String> commandLineArgs = this.myCommandLineArgs.get(this.myProject);
            ExternalSystemTaskId id = SyncExecutor.createId(this.myProject);
            GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(indicator), Collections.emptyList(), commandLineArgs, (ProjectConnection)connection);
            CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
            executor.withCancellationToken(cancellationTokenSource.token());
            try {
                SyncAction.ProjectModels models = (SyncAction.ProjectModels)executor.run();
                callback.setDone(models);
            }
            catch (RuntimeException e) {
                this.myErrorHandlerManager.handleError(e);
                callback.setRejected(e);
            }
            return null;
        };
        this.myHelper.execute(Projects.getBaseDirPath(this.myProject).getPath(), executionSettings, syncFunction);
    }

    @NotNull
    private static ExternalSystemTaskId createId(@NotNull Project project) {
        if (project == null) {
            SyncExecutor.$$$reportNull$$$0(8);
        }
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)project);
        if (externalSystemTaskId == null) {
            SyncExecutor.$$$reportNull$$$0(9);
        }
        return externalSystemTaskId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArgs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandlerManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraSyncModelExtensionManager";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "syncProject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createId";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$syncProject$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class GradleSyncNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private final ProgressIndicator myIndicator;

        GradleSyncNotificationListener(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator;
        }

        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
            if (event == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(1);
            }
            GradleSyncProgress.notifyProgress(this.myIndicator, event.getDescription());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor$GradleSyncNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStatusChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

