/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencySetupIssues {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final Map<String, MissingModule> myMissingModules;
    @NotNull
    private final Map<String, MissingModule> myMissingModulesWithBackupLibraries;
    @NotNull
    private final Set<String> myDependentsOnLibrariesWithoutBinaryPath;
    @NotNull
    private final Set<InvalidModuleDependency> myInvalidModuleDependencies;

    @NotNull
    public static DependencySetupIssues getInstance(@NotNull Project project) {
        if (project == null) {
            DependencySetupIssues.$$$reportNull$$$0(0);
        }
        DependencySetupIssues dependencySetupIssues = (DependencySetupIssues)ServiceManager.getService((Project)project, DependencySetupIssues.class);
        if (dependencySetupIssues == null) {
            DependencySetupIssues.$$$reportNull$$$0(1);
        }
        return dependencySetupIssues;
    }

    public DependencySetupIssues(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleSyncMessages syncMessages) {
        if (project == null) {
            DependencySetupIssues.$$$reportNull$$$0(2);
        }
        if (syncState == null) {
            DependencySetupIssues.$$$reportNull$$$0(3);
        }
        if (syncMessages == null) {
            DependencySetupIssues.$$$reportNull$$$0(4);
        }
        this.myMissingModules = new ConcurrentHashMap<String, MissingModule>();
        this.myMissingModulesWithBackupLibraries = new ConcurrentHashMap<String, MissingModule>();
        this.myDependentsOnLibrariesWithoutBinaryPath = new CopyOnWriteArraySet<String>();
        this.myInvalidModuleDependencies = new CopyOnWriteArraySet<InvalidModuleDependency>();
        this.myProject = project;
        this.mySyncState = syncState;
        this.mySyncMessages = syncMessages;
    }

    public void reportIssues() {
        String msg;
        this.reportModulesNotFoundIssues(this.getMissingModules());
        for (String dependent : this.getDependentsOnLibrariesWithoutBinaryPath()) {
            msg = String.format("Module '%1$s' depends on libraries that do not have a 'binary' path.", dependent);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.ERROR, msg));
        }
        for (InvalidModuleDependency dependency : this.myInvalidModuleDependencies) {
            msg = String.format("Ignoring dependency of module '%1$s' on module '%2$s'. %3$s", dependency.dependent, dependency.dependency.getName(), dependency.cause);
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(dependency.dependency);
            assert (buildFile != null);
            OpenFileDescriptor navigatable = new OpenFileDescriptor(dependency.dependency.getProject(), buildFile, 0);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.WARNING, (Navigatable)navigatable, msg));
        }
        this.reportModulesNotFoundIssues(this.getMissingModulesWithBackupLibraries());
        this.clear();
    }

    @VisibleForTesting
    @NotNull
    List<MissingModule> getMissingModules() {
        List<MissingModule> list = DependencySetupIssues.getMissingModules(this.myMissingModules);
        if (list == null) {
            DependencySetupIssues.$$$reportNull$$$0(5);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    List<MissingModule> getMissingModulesWithBackupLibraries() {
        List<MissingModule> list = DependencySetupIssues.getMissingModules(this.myMissingModulesWithBackupLibraries);
        if (list == null) {
            DependencySetupIssues.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<MissingModule> getMissingModules(@NotNull Map<String, MissingModule> missingModulesByName) {
        if (missingModulesByName == null) {
            DependencySetupIssues.$$$reportNull$$$0(7);
        }
        if (missingModulesByName.isEmpty()) {
            List<MissingModule> list = Collections.emptyList();
            if (list == null) {
                DependencySetupIssues.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<MissingModule> missingModules = new ArrayList<MissingModule>();
        ArrayList<String> names = new ArrayList<String>(missingModulesByName.keySet());
        if (names.size() > 1) {
            names.sort(String::compareTo);
        }
        for (String name : names) {
            MissingModule missingModule = missingModulesByName.get(name);
            missingModule.sortDependentNames();
            missingModules.add(missingModule);
        }
        ArrayList<MissingModule> arrayList = missingModules;
        if (arrayList == null) {
            DependencySetupIssues.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @VisibleForTesting
    @NotNull
    List<String> getDependentsOnLibrariesWithoutBinaryPath() {
        List<String> list = DependencySetupIssues.sortSet(this.myDependentsOnLibrariesWithoutBinaryPath);
        if (list == null) {
            DependencySetupIssues.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static List<String> sortSet(@NotNull Set<String> set) {
        if (set == null) {
            DependencySetupIssues.$$$reportNull$$$0(11);
        }
        if (set.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DependencySetupIssues.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<String> sorted = new ArrayList<String>(set);
        if (sorted.size() > 1) {
            sorted.sort(String::compareTo);
        }
        ArrayList<String> arrayList = sorted;
        if (arrayList == null) {
            DependencySetupIssues.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private void reportModulesNotFoundIssues(@NotNull List<MissingModule> missingModules) {
        if (missingModules == null) {
            DependencySetupIssues.$$$reportNull$$$0(14);
        }
        if (!missingModules.isEmpty()) {
            boolean hasSelection;
            CharSequence text;
            boolean hasError = false;
            for (MissingModule missingModule : missingModules) {
                ArrayList<String> messageLines = new ArrayList<String>();
                text = new StringBuilder();
                ((StringBuilder)text).append(String.format("Unable to find module with Gradle path '%1$s' (needed by module", missingModule.dependencyPath));
                DependencySetupIssues.addDependentsToText((StringBuilder)text, missingModule.dependentNames);
                ((StringBuilder)text).append(".)");
                messageLines.add(((StringBuilder)text).toString());
                String backupLibraryName = missingModule.backupLibraryName;
                if (StringUtil.isNotEmpty((String)backupLibraryName)) {
                    String msg = String.format("Linking to library '%1$s' instead.", backupLibraryName);
                    messageLines.add(msg);
                }
                if (missingModule.isError()) {
                    hasError = true;
                }
                this.mySyncMessages.report(new SyncMessage("Missing Dependencies", missingModule.issueType, ArrayUtil.toStringArray(messageLines)));
            }
            ProjectSubset projectSubset = ProjectSubset.getInstance(this.myProject);
            String[] selection = projectSubset.getSelection();
            boolean bl = hasSelection = selection != null && selection.length > 0;
            if (hasError && hasSelection && projectSubset.hasCachedModules()) {
                text = "The missing modules may have been excluded from the project subset.";
                SyncMessage message = new SyncMessage("Missing Dependencies", MessageType.INFO, new String[]{text});
                message.add(new IncludeMissingModulesHyperlink(missingModules));
                this.mySyncMessages.report(message);
            }
        }
    }

    private static void addDependentsToText(@NotNull StringBuilder text, @NotNull List<String> dependents) {
        if (text == null) {
            DependencySetupIssues.$$$reportNull$$$0(15);
        }
        if (dependents == null) {
            DependencySetupIssues.$$$reportNull$$$0(16);
        }
        assert (!dependents.isEmpty());
        if (dependents.size() == 1) {
            text.append(String.format(" '%1$s'", dependents.get(0)));
            return;
        }
        text.append("s: ");
        int i = 0;
        for (String dependent : dependents) {
            if (i++ > 0) {
                text.append(", ");
            }
            text.append(String.format("'%1$s'", dependent));
        }
    }

    private void clear() {
        this.myMissingModules.clear();
        this.myMissingModulesWithBackupLibraries.clear();
        this.myDependentsOnLibrariesWithoutBinaryPath.clear();
        this.myInvalidModuleDependencies.clear();
    }

    public void addMissingModule(@NotNull String dependencyName, @NotNull String dependentName, @Nullable String backupLibraryName) {
        if (dependencyName == null) {
            DependencySetupIssues.$$$reportNull$$$0(17);
        }
        if (dependentName == null) {
            DependencySetupIssues.$$$reportNull$$$0(18);
        }
        Map<String, MissingModule> mapping = StringUtil.isNotEmpty((String)backupLibraryName) ? this.myMissingModulesWithBackupLibraries : this.myMissingModules;
        MissingModule missingModule = mapping.computeIfAbsent(dependencyName, name -> new MissingModule((String)name, backupLibraryName));
        missingModule.addDependent(dependentName);
        if (missingModule.isError()) {
            this.registerSyncError();
        }
    }

    public void addMissingBinaryPath(@NotNull String dependentName) {
        if (dependentName == null) {
            DependencySetupIssues.$$$reportNull$$$0(19);
        }
        this.myDependentsOnLibrariesWithoutBinaryPath.add(dependentName);
        this.registerSyncError();
    }

    private void registerSyncError() {
        this.mySyncState.getSummary().setSyncErrorsFound(true);
    }

    public void addInvalidModuleDependency(@NotNull Module dependency, @NotNull String dependent, @NotNull String cause) {
        if (dependency == null) {
            DependencySetupIssues.$$$reportNull$$$0(20);
        }
        if (dependent == null) {
            DependencySetupIssues.$$$reportNull$$$0(21);
        }
        if (cause == null) {
            DependencySetupIssues.$$$reportNull$$$0(22);
        }
        this.myInvalidModuleDependencies.add(new InvalidModuleDependency(dependency, dependent, cause));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupIssues";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingModulesByName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingModules";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependents";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupIssues";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingModulesWithBackupLibraries";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentsOnLibrariesWithoutBinaryPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sortSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMissingModules";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sortSet";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportModulesNotFoundIssues";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addDependentsToText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addMissingModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addMissingBinaryPath";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addInvalidModuleDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IncludeMissingModulesHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Set<String> myModuleGradlePaths;

        IncludeMissingModulesHyperlink(@NotNull List<MissingModule> missingModules) {
            if (missingModules == null) {
                IncludeMissingModulesHyperlink.$$$reportNull$$$0(0);
            }
            super("include.missing.modules", "Find and include missing modules");
            this.myModuleGradlePaths = new HashSet<String>(missingModules.size());
            for (MissingModule module : missingModules) {
                this.myModuleGradlePaths.add(module.dependencyPath);
            }
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                IncludeMissingModulesHyperlink.$$$reportNull$$$0(1);
            }
            ProjectSubset.getInstance(project).findAndIncludeModules(this.myModuleGradlePaths);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "missingModules";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupIssues$IncludeMissingModulesHyperlink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class InvalidModuleDependency {
        @NotNull
        final Module dependency;
        @NotNull
        final String dependent;
        @NotNull
        final String cause;

        InvalidModuleDependency(@NotNull Module dependency, @NotNull String dependent, @NotNull String cause) {
            if (dependency == null) {
                InvalidModuleDependency.$$$reportNull$$$0(0);
            }
            if (dependent == null) {
                InvalidModuleDependency.$$$reportNull$$$0(1);
            }
            if (cause == null) {
                InvalidModuleDependency.$$$reportNull$$$0(2);
            }
            this.dependency = dependency;
            this.dependent = dependent;
            this.cause = cause;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependency";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupIssues$InvalidModuleDependency";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class MissingModule {
        @NotNull
        final String dependencyPath;
        @NotNull
        final MessageType issueType;
        @Nullable
        final String backupLibraryName;
        @NotNull
        final List<String> dependentNames;

        MissingModule(@NotNull String dependencyPath, @Nullable String backupLibraryName) {
            if (dependencyPath == null) {
                MissingModule.$$$reportNull$$$0(0);
            }
            this.dependentNames = new CopyOnWriteArrayList<String>();
            this.dependencyPath = dependencyPath;
            this.backupLibraryName = backupLibraryName;
            this.issueType = StringUtil.isEmpty((String)backupLibraryName) ? MessageType.ERROR : MessageType.WARNING;
        }

        void addDependent(@NotNull String dependentName) {
            if (dependentName == null) {
                MissingModule.$$$reportNull$$$0(1);
            }
            this.dependentNames.add(dependentName);
        }

        void sortDependentNames() {
            if (!this.dependentNames.isEmpty()) {
                this.dependentNames.sort(String::compareTo);
            }
        }

        boolean isError() {
            return this.issueType == MessageType.ERROR;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependentName";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupIssues$MissingModule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDependent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

