/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.compatibility.VersionCompatibilityChecker;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupIssues;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgrade;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.sync.setup.post.project.DisposedModules;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonModuleValidator;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.instantapp.ProvistionTasks;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.concurrency.JobLauncher;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class PostSyncProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final DependencySetupIssues myDependencySetupIssues;
    @NotNull
    private final ProjectSetup myProjectSetup;
    @NotNull
    private final ModuleSetup myModuleSetup;
    @NotNull
    private final PluginVersionUpgrade myPluginVersionUpgrade;
    @NotNull
    private final VersionCompatibilityChecker myVersionCompatibilityChecker;
    @NotNull
    private final GradleProjectBuilder myProjectBuilder;
    @NotNull
    private final CommonModuleValidator.Factory myModuleValidatorFactory;
    @NotNull
    private final ProvistionTasks myProvistionTasks;

    @NotNull
    public static PostSyncProjectSetup getInstance(@NotNull Project project) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(0);
        }
        PostSyncProjectSetup postSyncProjectSetup = (PostSyncProjectSetup)ServiceManager.getService((Project)project, PostSyncProjectSetup.class);
        if (postSyncProjectSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(1);
        }
        return postSyncProjectSetup;
    }

    public PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull GradleSyncMessages syncMessages, @NotNull DependencySetupIssues dependencySetupIssues, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(2);
        }
        if (ideInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(3);
        }
        if (gradleProjectInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(4);
        }
        if (syncInvoker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(5);
        }
        if (syncState == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(6);
        }
        if (syncMessages == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(7);
        }
        if (dependencySetupIssues == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(8);
        }
        if (pluginVersionUpgrade == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(9);
        }
        if (versionCompatibilityChecker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(10);
        }
        if (projectBuilder == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(11);
        }
        this(project, ideInfo, gradleProjectInfo, syncInvoker, syncState, dependencySetupIssues, new ProjectSetup(project), new ModuleSetup(project), pluginVersionUpgrade, versionCompatibilityChecker, projectBuilder, new CommonModuleValidator.Factory(), new ProvistionTasks());
    }

    @VisibleForTesting
    PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull DependencySetupIssues dependencySetupIssues, @NotNull ProjectSetup projectSetup, @NotNull ModuleSetup moduleSetup, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder, @NotNull CommonModuleValidator.Factory moduleValidatorFactory, @NotNull ProvistionTasks provistionTasks) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(12);
        }
        if (ideInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(13);
        }
        if (gradleProjectInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(14);
        }
        if (syncInvoker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(15);
        }
        if (syncState == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(16);
        }
        if (dependencySetupIssues == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(17);
        }
        if (projectSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(18);
        }
        if (moduleSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(19);
        }
        if (pluginVersionUpgrade == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(20);
        }
        if (versionCompatibilityChecker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(21);
        }
        if (projectBuilder == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(22);
        }
        if (moduleValidatorFactory == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(23);
        }
        if (provistionTasks == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(24);
        }
        this.myProject = project;
        this.myIdeInfo = ideInfo;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.mySyncInvoker = syncInvoker;
        this.mySyncState = syncState;
        this.myDependencySetupIssues = dependencySetupIssues;
        this.myProjectSetup = projectSetup;
        this.myModuleSetup = moduleSetup;
        this.myPluginVersionUpgrade = pluginVersionUpgrade;
        this.myVersionCompatibilityChecker = versionCompatibilityChecker;
        this.myProjectBuilder = projectBuilder;
        this.myModuleValidatorFactory = moduleValidatorFactory;
        this.myProvistionTasks = provistionTasks;
    }

    public void setUpProject(@NotNull Request request, @NotNull ProgressIndicator progressIndicator) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(25);
        }
        if (progressIndicator == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(26);
        }
        this.myGradleProjectInfo.setNewOrImportedProject(false);
        boolean syncFailed = this.mySyncState.lastSyncFailedOrHasIssues();
        if (syncFailed && request.isUsingCachedGradleModels()) {
            this.onCachedModelsSetupFailure(request);
            return;
        }
        this.myDependencySetupIssues.reportIssues();
        this.myVersionCompatibilityChecker.checkAndReportComponentIncompatibilities(this.myProject);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<Module> modules = Arrays.asList(moduleManager.getModules());
        CommonModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(modules, progressIndicator, true, module -> {
            moduleValidator.validate((Module)module);
            return true;
        });
        moduleValidator.fixAndReportFoundIssues();
        if (syncFailed) {
            this.failTestsIfSyncIssuesPresent();
            this.myProjectSetup.setUpProject(progressIndicator, true);
            this.mySyncState.syncFailed("");
            return;
        }
        if (!request.isSkipAndroidPluginUpgrade() && this.myPluginVersionUpgrade.checkAndPerformUpgrade()) {
            return;
        }
        new ProjectStructureUsageTracker(this.myProject).trackProjectStructure();
        DisposedModules.getInstance(this.myProject).deleteImlFilesForDisposedModules();
        this.findAndShowVariantConflicts();
        this.myProjectSetup.setUpProject(progressIndicator, false);
        boolean androidStudio = this.myIdeInfo.isAndroidStudio();
        String taskName = androidStudio ? "Gradle-aware Make" : ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
        this.setMakeStepInJunitRunConfigurations(taskName);
        this.myProvistionTasks.addInstantAppProvisionTaskToRunConfigurations(this.myProject);
        this.notifySyncFinished(request);
        this.attemptToGenerateSources(request);
        TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
        this.myModuleSetup.setUpModules(null);
    }

    public void onCachedModelsSetupFailure(@NotNull Request request) {
        long syncTimestamp;
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(27);
        }
        if ((syncTimestamp = request.getLastSyncTimestamp()) < 0L) {
            syncTimestamp = System.currentTimeMillis();
        }
        this.mySyncState.syncSkipped(syncTimestamp);
        this.mySyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_LOADED, null);
    }

    private void failTestsIfSyncIssuesPresent() {
        if (ApplicationManager.getApplication().isUnitTestMode() && this.mySyncState.getSummary().hasSyncErrors()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Sync issues found!").append('\n');
            this.myGradleProjectInfo.forEachAndroidModule((Consumer<AndroidFacet>)((Consumer)facet -> {
                Collection<SyncIssue> issues;
                AndroidModel androidModel = facet.getAndroidModel();
                if (androidModel instanceof AndroidModuleModel && (issues = ((AndroidModuleModel)androidModel).getSyncIssues()) != null && !issues.isEmpty()) {
                    buffer.append("Module '").append(facet.getModule().getName()).append("':").append('\n');
                    for (SyncIssue issue2 : issues) {
                        buffer.append(issue2.getMessage()).append('\n');
                    }
                }
            }));
            throw new IllegalStateException(buffer.toString());
        }
    }

    private void notifySyncFinished(@NotNull Request request) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(28);
        }
        if (request.isUsingCachedGradleModels()) {
            long timestamp = System.currentTimeMillis();
            this.mySyncState.syncSkipped(timestamp);
            GradleBuildState.getInstance(this.myProject).buildFinished(BuildStatus.SKIPPED);
        } else {
            this.mySyncState.syncEnded();
            GradleProjectSyncData.save(this.myProject);
        }
    }

    private void findAndShowVariantConflicts() {
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog.show();
        }
        conflicts.showSelectionConflicts();
    }

    private void setMakeStepInJunitRunConfigurations(@NotNull String makeTaskName) {
        if (makeTaskName == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(29);
        }
        AndroidJUnitConfigurationType junitConfigurationType = AndroidJUnitConfigurationType.getInstance();
        BeforeRunTaskProvider[] taskProviders = (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject);
        BeforeRunTaskProvider targetProvider = null;
        for (BeforeRunTaskProvider provider : taskProviders) {
            if (!makeTaskName.equals(provider.getName())) continue;
            targetProvider = provider;
            break;
        }
        if (targetProvider != null) {
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.myProject);
            for (ConfigurationFactory configurationFactory : junitConfigurationType.getConfigurationFactories()) {
                RunnerAndConfigurationSettingsImpl template = runManager.getConfigurationTemplate(configurationFactory);
                RunConfiguration runConfiguration = template.getConfiguration();
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
            }
            for (RunConfiguration runConfiguration : runManager.getConfigurationsList((ConfigurationType)junitConfigurationType)) {
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
            }
        }
    }

    private void setMakeStepInJUnitConfiguration(@NotNull BeforeRunTaskProvider targetProvider, @NotNull RunConfiguration runConfiguration) {
        if (targetProvider == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(30);
        }
        if (runConfiguration == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(31);
        }
        LinkedList<BeforeRunTask> newBeforeRunTasks = new LinkedList<BeforeRunTask>();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.myProject);
        for (BeforeRunTask beforeRunTask : runManager.getBeforeRunTasks(runConfiguration)) {
            if (beforeRunTask.getProviderId().equals((Object)CompileStepBeforeRun.ID)) {
                BeforeRunTask task = targetProvider.createTask(runConfiguration);
                if (task == null) continue;
                task.setEnabled(true);
                newBeforeRunTasks.add(task);
                continue;
            }
            newBeforeRunTasks.add(beforeRunTask);
        }
        runManager.setBeforeRunTasks(runConfiguration, newBeforeRunTasks, false);
    }

    private void attemptToGenerateSources(@NotNull Request request) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(32);
        }
        if (!request.isGenerateSourcesAfterSync()) {
            return;
        }
        boolean cleanProjectAfterSync = request.isCleanProjectAfterSync();
        if (!cleanProjectAfterSync) {
            Map<String, GradleVersion> previousPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
            Projects.storePluginVersionsPerModule(this.myProject);
            if (previousPluginVersionsPerModule != null && !previousPluginVersionsPerModule.isEmpty()) {
                Map<String, GradleVersion> currentPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
                assert (currentPluginVersionsPerModule != null);
                for (Map.Entry<String, GradleVersion> entry : currentPluginVersionsPerModule.entrySet()) {
                    String modulePath = entry.getKey();
                    GradleVersion previous = previousPluginVersionsPerModule.get(modulePath);
                    if (previous != null && entry.getValue().compareTo(previous) == 0) continue;
                    cleanProjectAfterSync = true;
                    break;
                }
            }
        }
        if (cleanProjectAfterSync) {
            this.myProjectBuilder.cleanAndGenerateSources();
            return;
        }
        this.myProjectBuilder.generateSources();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectInfo";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncInvoker";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencySetupIssues";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginVersionUpgrade";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionCompatibilityChecker";
                break;
            }
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBuilder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetup";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetup";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleValidatorFactory";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provistionTasks";
                break;
            }
            case 25: 
            case 27: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "makeTaskName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProvider";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onCachedModelsSetupFailure";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "notifySyncFinished";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setMakeStepInJunitRunConfigurations";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setMakeStepInJUnitConfiguration";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "attemptToGenerateSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        @NotNull
        public static final Request DEFAULT_REQUEST = new Request(){

            @Override
            @NotNull
            public Request setCleanProjectAfterSync(boolean cleanProjectAfterSync) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setLastSyncTimestamp(long lastSyncTimestamp) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setUsingCachedGradleModels(boolean usingCachedGradleModels) {
                throw new UnsupportedOperationException();
            }
        };
        private boolean myUsingCachedGradleModels;
        private boolean myCleanProjectAfterSync;
        private boolean myGenerateSourcesAfterSync = true;
        private boolean mySkipAndroidPluginUpgrade;
        private long myLastSyncTimestamp = -1L;

        public boolean isUsingCachedGradleModels() {
            return this.myUsingCachedGradleModels;
        }

        @NotNull
        public Request setUsingCachedGradleModels(boolean usingCachedGradleModels) {
            this.myUsingCachedGradleModels = usingCachedGradleModels;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(0);
            }
            return request;
        }

        public boolean isCleanProjectAfterSync() {
            return this.myCleanProjectAfterSync;
        }

        @NotNull
        public Request setCleanProjectAfterSync(boolean cleanProjectAfterSync) {
            this.myCleanProjectAfterSync = cleanProjectAfterSync;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(1);
            }
            return request;
        }

        public boolean isGenerateSourcesAfterSync() {
            return this.myGenerateSourcesAfterSync;
        }

        @NotNull
        public Request setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
            this.myGenerateSourcesAfterSync = generateSourcesAfterSync;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(2);
            }
            return request;
        }

        public long getLastSyncTimestamp() {
            return this.myLastSyncTimestamp;
        }

        public boolean isSkipAndroidPluginUpgrade() {
            return this.mySkipAndroidPluginUpgrade;
        }

        public void setSkipAndroidPluginUpgrade() {
            this.mySkipAndroidPluginUpgrade = true;
        }

        @NotNull
        public Request setLastSyncTimestamp(long lastSyncTimestamp) {
            this.myLastSyncTimestamp = lastSyncTimestamp;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(3);
            }
            return request;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.myUsingCachedGradleModels == request.myUsingCachedGradleModels && this.myCleanProjectAfterSync == request.myCleanProjectAfterSync && this.myGenerateSourcesAfterSync == request.myGenerateSourcesAfterSync && this.myLastSyncTimestamp == request.myLastSyncTimestamp;
        }

        public int hashCode() {
            return Objects.hash(this.myUsingCachedGradleModels, this.myCleanProjectAfterSync, this.myGenerateSourcesAfterSync, this.myLastSyncTimestamp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup$Request";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setUsingCachedGradleModels";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCleanProjectAfterSync";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setGenerateSourcesAfterSync";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLastSyncTimestamp";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

