/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.idea.gradle.structure.dependencies.AbstractAddDependenciesDialog;
import com.android.tools.idea.gradle.structure.dependencies.AbstractDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.dependencies.LibraryDependenciesForm;
import com.android.tools.idea.gradle.structure.dependencies.android.AndroidDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.dependency.PsNewDependencyScopes;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddLibraryDependencyDialog
extends AbstractAddDependenciesDialog {
    @NotNull
    public static final String TITLE = "Add Library Dependency";
    private LibraryDependenciesForm myLibraryDependenciesForm;

    public AddLibraryDependencyDialog(@NotNull PsModule module) {
        if (module == null) {
            AddLibraryDependencyDialog.$$$reportNull$$$0(0);
        }
        super(module);
        this.setTitle(TITLE);
    }

    @Override
    public void addNewDependencies() {
        String library = this.myLibraryDependenciesForm.getSelectedLibrary();
        assert (library != null);
        AbstractDependencyScopesPanel scopesPanel = this.getScopesPanel();
        List<String> scopesNames = scopesPanel.getSelectedScopeNames();
        PsModule module = this.getModule();
        if (module instanceof PsAndroidModule) {
            PsNewDependencyScopes newScopes = ((AndroidDependencyScopesPanel)scopesPanel).getNewScopes();
            assert (newScopes != null);
            ((PsAndroidModule)module).addLibraryDependency(library, newScopes, scopesNames);
        } else if (module instanceof PsJavaModule) {
            ((PsJavaModule)module).addLibraryDependency(library, scopesNames);
        }
    }

    @Override
    @NotNull
    protected String getSplitterProportionKey() {
        if ("psd.add.library.dependency.main.horizontal.splitter.proportion" == null) {
            AddLibraryDependencyDialog.$$$reportNull$$$0(1);
        }
        return "psd.add.library.dependency.main.horizontal.splitter.proportion";
    }

    @Override
    @NotNull
    protected JComponent getDependencySelectionView() {
        if (this.myLibraryDependenciesForm == null) {
            this.myLibraryDependenciesForm = new LibraryDependenciesForm(this.getModule());
        }
        JPanel jPanel = this.myLibraryDependenciesForm.getPanel();
        if (jPanel == null) {
            AddLibraryDependencyDialog.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected String getInstructions() {
        if ("Use the form below to find the library to add. This form uses the repositories specified in  the project's build files (e.g. JCenter, Maven Central, etc.)" == null) {
            AddLibraryDependencyDialog.$$$reportNull$$$0(3);
        }
        return "Use the form below to find the library to add. This form uses the repositories specified in  the project's build files (e.g. JCenter, Maven Central, etc.)";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        if ("psd.add.library.dependency.panel.dimension" == null) {
            AddLibraryDependencyDialog.$$$reportNull$$$0(4);
        }
        return "psd.add.library.dependency.panel.dimension";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myLibraryDependenciesForm != null ? this.myLibraryDependenciesForm.getPreferredFocusedComponent() : null;
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.myLibraryDependenciesForm != null) {
            Disposer.dispose((Disposable)this.myLibraryDependenciesForm);
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        List<Exception> searchErrors = this.myLibraryDependenciesForm.getSearchErrors();
        if (!searchErrors.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            searchErrors.forEach(e -> buffer.append(AddLibraryDependencyDialog.getErrorMessage(e)).append("\n"));
            return new ValidationInfo(buffer.toString(), this.myLibraryDependenciesForm.getPreferredFocusedComponent());
        }
        String selectedLibrary = this.myLibraryDependenciesForm.getSelectedLibrary();
        if (StringUtil.isEmpty((String)selectedLibrary)) {
            return new ValidationInfo("Please specify the library to add as dependency", this.myLibraryDependenciesForm.getPreferredFocusedComponent());
        }
        PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(selectedLibrary);
        PsModule module = this.getModule();
        if (spec != null && module instanceof PsAndroidModule) {
            PsAndroidModule androidModule = (PsAndroidModule)module;
            Ref found = new Ref((Object)false);
            androidModule.forEachDeclaredDependency(dependency -> {
                if (dependency instanceof PsLibraryAndroidDependency) {
                    PsLibraryAndroidDependency libraryDependency = (PsLibraryAndroidDependency)dependency;
                    PsArtifactDependencySpec resolvedSpec = libraryDependency.getResolvedSpec();
                    if (Objects.equals(spec.getGroup(), resolvedSpec.getGroup()) && Objects.equals(spec.getName(), resolvedSpec.getName())) {
                        found.set((Object)true);
                    }
                }
            });
            if (((Boolean)found.get()).booleanValue()) {
                String msg = String.format("Library '%1$s' is already a dependency", spec.getName());
                return new ValidationInfo(msg, this.myLibraryDependenciesForm.getPreferredFocusedComponent());
            }
        }
        return this.getScopesPanel().validateInput();
    }

    @NotNull
    private static String getErrorMessage(@NotNull Exception error) {
        if (error == null) {
            AddLibraryDependencyDialog.$$$reportNull$$$0(5);
        }
        if (error instanceof UnknownHostException) {
            String string = "Failed to connect to host '" + error.getMessage() + "'. Please check your Internet connection.";
            if (string == null) {
                AddLibraryDependencyDialog.$$$reportNull$$$0(6);
            }
            return string;
        }
        String msg = error.getMessage();
        if (StringUtil.isNotEmpty((String)msg)) {
            String string = msg;
            if (string == null) {
                AddLibraryDependencyDialog.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = error.getClass().getName();
        if (string == null) {
            AddLibraryDependencyDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitterProportionKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencySelectionView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

