/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.rendering.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidAdaptiveIconGenerator
extends AndroidIconGenerator {
    private final BoolProperty myUseForegroundColor;
    private final ObjectProperty<Color> myForegroundColor;
    private final ObjectProperty<Color> myBackgroundColor;
    private final BoolProperty myGenerateLegacyIcon;
    private final BoolProperty myGenerateRoundIcon;
    private final BoolProperty myGenerateWebIcon;
    private final ObjectProperty<GraphicGenerator.Shape> myLegacyIconShape;
    private final ObjectProperty<GraphicGenerator.Shape> myWebIconShape;
    private final BoolProperty myShowGrid;
    private final BoolProperty myShowSafeZone;
    private final ObjectValueProperty<Density> myPreviewDensity;
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    private final StringProperty myForegroundLayerName;
    private final StringProperty myBackgroundLayerName;

    public AndroidAdaptiveIconGenerator(@NotNull AndroidFacet facet, int minSdkVersion) {
        if (facet == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(0);
        }
        super(minSdkVersion, new AdaptiveIconGenerator(), new GraphicGeneratorContext(40, new MyDrawableRenderer(facet)));
        this.myUseForegroundColor = new BoolValueProperty(true);
        this.myForegroundColor = new ObjectValueProperty<Color>(Color.BLACK);
        this.myBackgroundColor = new ObjectValueProperty<Color>(new Color(2533018));
        this.myGenerateLegacyIcon = new BoolValueProperty(true);
        this.myGenerateRoundIcon = new BoolValueProperty(true);
        this.myGenerateWebIcon = new BoolValueProperty(true);
        this.myLegacyIconShape = new ObjectValueProperty<GraphicGenerator.Shape>(GraphicGenerator.Shape.SQUARE);
        this.myWebIconShape = new ObjectValueProperty<GraphicGenerator.Shape>(GraphicGenerator.Shape.SQUARE);
        this.myShowGrid = new BoolValueProperty();
        this.myShowSafeZone = new BoolValueProperty(true);
        this.myPreviewDensity = new ObjectValueProperty<Density>(Density.XHIGH);
        this.myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>();
        this.myForegroundLayerName = new StringValueProperty();
        this.myBackgroundLayerName = new StringValueProperty();
    }

    @NotNull
    public BoolProperty useForegroundColor() {
        BoolProperty boolProperty = this.myUseForegroundColor;
        if (boolProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(1);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<Color> foregroundColor() {
        ObjectProperty<Color> objectProperty = this.myForegroundColor;
        if (objectProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(2);
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        ObjectProperty<Color> objectProperty = this.myBackgroundColor;
        if (objectProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(3);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty generateLegacyIcon() {
        BoolProperty boolProperty = this.myGenerateLegacyIcon;
        if (boolProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(4);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty generateRoundIcon() {
        BoolProperty boolProperty = this.myGenerateRoundIcon;
        if (boolProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(5);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty generateWebIcon() {
        BoolProperty boolProperty = this.myGenerateWebIcon;
        if (boolProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(6);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<GraphicGenerator.Shape> legacyIconShape() {
        ObjectProperty<GraphicGenerator.Shape> objectProperty = this.myLegacyIconShape;
        if (objectProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(7);
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<GraphicGenerator.Shape> webIconShape() {
        ObjectProperty<GraphicGenerator.Shape> objectProperty = this.myWebIconShape;
        if (objectProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(8);
        }
        return objectProperty;
    }

    @NotNull
    public OptionalProperty<ImageAsset> backgroundImageAsset() {
        OptionalProperty<ImageAsset> optionalProperty = this.myBackgroundImageAsset;
        if (optionalProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(9);
        }
        return optionalProperty;
    }

    @NotNull
    public BoolProperty showGrid() {
        BoolProperty boolProperty = this.myShowGrid;
        if (boolProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(10);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty showSafeZone() {
        BoolProperty boolProperty = this.myShowSafeZone;
        if (boolProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(11);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectValueProperty<Density> previewDensity() {
        ObjectValueProperty<Density> objectValueProperty = this.myPreviewDensity;
        if (objectValueProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(12);
        }
        return objectValueProperty;
    }

    @NotNull
    public StringProperty foregroundLayerName() {
        StringProperty stringProperty = this.myForegroundLayerName;
        if (stringProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(13);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty backgroundLayerName() {
        StringProperty stringProperty = this.myBackgroundLayerName;
        if (stringProperty == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(14);
        }
        return stringProperty;
    }

    @Override
    @NotNull
    public GraphicGenerator.Options createOptions(boolean forPreview) {
        ImageAsset backgroundAsset;
        AdaptiveIconGenerator.AdaptiveIconOptions options = new AdaptiveIconGenerator.AdaptiveIconOptions();
        options.generateOutputIcons = !forPreview;
        options.generatePreviewIcons = forPreview;
        options.minSdk = this.getMinSdkVersion();
        options.useForegroundColor = (Boolean)this.myUseForegroundColor.get();
        options.foregroundColor = ((Color)this.myForegroundColor.get()).getRGB();
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            double scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            if (foregroundAsset instanceof VectorAsset) {
                scaleFactor *= 0.58;
            } else if (foregroundAsset instanceof TextAsset) {
                scaleFactor *= 0.46;
            } else if (((Boolean)foregroundAsset.trimmed().get()).booleanValue()) {
                scaleFactor *= AdaptiveIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / AdaptiveIconGenerator.SIZE_FULL_BLEED_DP.getWidth();
            }
            options.foregroundImage = new AdaptiveIconGenerator.ImageAssetSnapshot(foregroundAsset, scaleFactor, this.getGraphicGeneratorContext());
        }
        if ((backgroundAsset = this.myBackgroundImageAsset.getValueOrNull()) != null) {
            double scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options.backgroundImage = new AdaptiveIconGenerator.ImageAssetSnapshot(backgroundAsset, scaleFactor, this.getGraphicGeneratorContext());
        }
        options.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options.showGrid = (Boolean)this.myShowGrid.get();
        options.showSafeZone = (Boolean)this.myShowSafeZone.get();
        options.previewDensity = this.myPreviewDensity.get();
        options.foregroundLayerName = (String)this.myForegroundLayerName.get();
        options.backgroundLayerName = (String)this.myBackgroundLayerName.get();
        options.generateLegacyIcon = (Boolean)this.myGenerateLegacyIcon.get();
        options.legacyIconShape = (GraphicGenerator.Shape)((Object)this.myLegacyIconShape.get());
        options.webIconShape = (GraphicGenerator.Shape)((Object)this.myWebIconShape.get());
        options.generateRoundIcon = (Boolean)this.myGenerateRoundIcon.get();
        options.generateWebIcon = (Boolean)this.myGenerateWebIcon.get();
        AdaptiveIconGenerator.AdaptiveIconOptions adaptiveIconOptions = options;
        if (adaptiveIconOptions == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(15);
        }
        return adaptiveIconOptions;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(AndroidAdaptiveIconGenerator.class);
        if (logger == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(16);
        }
        return logger;
    }

    @NotNull
    private static PsiFile createEphemeralPsiFile(@NotNull Project project, @NotNull String filename, @NotNull LanguageFileType fileType, @NotNull String contents) {
        LightVirtualFile virtualFile;
        PsiManager psiManager;
        SingleRootFileViewProvider viewProvider;
        PsiFile psiFile;
        if (project == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(17);
        }
        if (filename == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(18);
        }
        if (fileType == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(19);
        }
        if (contents == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(20);
        }
        if ((psiFile = (viewProvider = new SingleRootFileViewProvider(psiManager = PsiManager.getInstance((Project)project), (VirtualFile)(virtualFile = new LightVirtualFile(filename, (FileType)fileType, (CharSequence)contents)))).getPsi(fileType.getLanguage())) == null) {
            throw new IllegalArgumentException("Unsupported language: " + fileType.getLanguage().getDisplayName());
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            AndroidAdaptiveIconGenerator.$$$reportNull$$$0(21);
        }
        return psiFile2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/icon/AndroidAdaptiveIconGenerator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/icon/AndroidAdaptiveIconGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "useForegroundColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "foregroundColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLegacyIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRoundIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateWebIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "legacyIconShape";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "webIconShape";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundImageAsset";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "showGrid";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "showSafeZone";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "previewDensity";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "foregroundLayerName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundLayerName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createEphemeralPsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createEphemeralPsiFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDrawableRenderer
    implements GraphicGeneratorContext.DrawableRenderer {
        @NotNull
        private final ListenableFuture<RenderTask> myRenderTaskFuture;
        @NotNull
        private final Object myRenderLock;
        @NotNull
        private final MyLayoutPullParserFactory myParserFactory;
        @NotNull
        private final AtomicInteger myCounter;

        public MyDrawableRenderer(@NotNull AndroidFacet facet) {
            if (facet == null) {
                MyDrawableRenderer.$$$reportNull$$$0(0);
            }
            this.myRenderLock = new Object();
            this.myCounter = new AtomicInteger();
            Module module = facet.getModule();
            RenderLogger logger = new RenderLogger(AndroidAdaptiveIconGenerator.class.getSimpleName(), module);
            this.myParserFactory = new MyLayoutPullParserFactory(module.getProject(), logger);
            this.myRenderTaskFuture = FutureUtils.executeOnPooledThread(() -> {
                if (facet == null) {
                    MyDrawableRenderer.$$$reportNull$$$0(5);
                }
                try {
                    Configuration configuration = ThemeEditorUtils.getConfigurationForModule(module);
                    RenderService service = RenderService.getInstance(facet);
                    RenderTask renderTask = service.createTask(null, configuration, logger, null, this.myParserFactory);
                    assert (renderTask != null);
                    renderTask.getLayoutlibCallback().setLogger(logger);
                    if (logger.hasProblems()) {
                        AndroidAdaptiveIconGenerator.getLog().error(RenderProblem.format(logger.getMessages()));
                    }
                    return renderTask;
                }
                catch (Error | RuntimeException e) {
                    AndroidAdaptiveIconGenerator.getLog().error(e);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Object object = this.myRenderLock;
            synchronized (object) {
                RenderTask renderTask = this.getRenderTask();
                if (renderTask != null) {
                    renderTask.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public ListenableFuture<BufferedImage> renderDrawable(@NotNull String xmlDrawableText, @NotNull Dimension size) {
            if (xmlDrawableText == null) {
                MyDrawableRenderer.$$$reportNull$$$0(1);
            }
            if (size == null) {
                MyDrawableRenderer.$$$reportNull$$$0(2);
            }
            String xmlText = VectorDrawableTransformer.resizeAndCenter(xmlDrawableText, size, 1.0, null);
            ResourceUrl url = ResourceUrl.create(null, (ResourceType)ResourceType.DRAWABLE, (String)"ic_image_preview");
            String resourceName = String.format("preview_%x.xml", this.myCounter.getAndIncrement());
            ResourceValue value = new ResourceValue(url, resourceName);
            RenderTask renderTask = this.getRenderTask();
            if (renderTask == null) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)AssetStudioUtils.createDummyImage());
                if (listenableFuture != null) return listenableFuture;
                MyDrawableRenderer.$$$reportNull$$$0(3);
                return listenableFuture;
            }
            Object object = this.myRenderLock;
            // MONITORENTER : object
            this.myParserFactory.addFileContent(new File(resourceName), xmlText);
            renderTask.setOverrideRenderSize(size.width, size.height);
            renderTask.setMaxRenderSize(size.width, size.height);
            ListenableFuture<BufferedImage> listenableFuture = renderTask.renderDrawable(value);
            // MONITOREXIT : object
            if (listenableFuture != null) return listenableFuture;
            MyDrawableRenderer.$$$reportNull$$$0(4);
            return listenableFuture;
        }

        @Nullable
        private RenderTask getRenderTask() {
            try {
                return (RenderTask)this.myRenderTaskFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlDrawableText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/icon/AndroidAdaptiveIconGenerator$MyDrawableRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/icon/AndroidAdaptiveIconGenerator$MyDrawableRenderer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "renderDrawable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "renderDrawable";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$new$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyLayoutPullParserFactory
    implements ILayoutPullParserFactory {
        @NotNull
        private final ConcurrentMap<File, String> myFileContent;
        @NotNull
        private final Project myProject;
        @NotNull
        private final RenderLogger myLogger;

        public MyLayoutPullParserFactory(@NotNull Project project, @NotNull RenderLogger logger) {
            if (project == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(0);
            }
            if (logger == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(1);
            }
            this.myFileContent = new ConcurrentHashMap<File, String>();
            this.myProject = project;
            this.myLogger = logger;
        }

        @Override
        @Nullable
        public ILayoutPullParser create(@NotNull File file, @NotNull LayoutlibCallback layoutlibCallback) {
            String content;
            if (file == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(2);
            }
            if (layoutlibCallback == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(3);
            }
            if ((content = (String)this.myFileContent.remove(file)) == null) {
                return null;
            }
            XmlFile xmlFile = (XmlFile)AndroidAdaptiveIconGenerator.createEphemeralPsiFile(this.myProject, file.getName(), StdFileTypes.XML, content);
            return LayoutPsiPullParser.create(xmlFile, this.myLogger);
        }

        void addFileContent(@NotNull File file, @NotNull String content) {
            if (file == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(4);
            }
            if (content == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(5);
            }
            this.myFileContent.put(file, content);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logger";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layoutlibCallback";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/npw/assetstudio/icon/AndroidAdaptiveIconGenerator$MyLayoutPullParserFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFileContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

