/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.idea.profilers.TraceSignatureConverter;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntellijCodeNavigator
extends CodeNavigator {
    private final Project myProject;

    public IntellijCodeNavigator(@NotNull Project project, @NotNull FeatureTracker featureTracker) {
        if (project == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(0);
        }
        if (featureTracker == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(1);
        }
        super(featureTracker);
        this.myProject = project;
    }

    protected void handleNavigate(@NotNull CodeLocation location) {
        Navigatable nav;
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(2);
        }
        if ((nav = this.getNavigatable(location)) != null) {
            nav.navigate(true);
        }
    }

    @Nullable
    private Navigatable getNavigatable(@NotNull CodeLocation location) {
        PsiClass psiClass;
        if (location == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(3);
        }
        if ((psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)location.getClassName())) == null && location.getLineNumber() >= 0) {
            psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)location.getOuterClassName());
        }
        if (psiClass == null) {
            return null;
        }
        if (location.getLineNumber() >= 0) {
            return new OpenFileDescriptor(this.myProject, psiClass.getNavigationElement().getContainingFile().getVirtualFile(), location.getLineNumber(), 0);
        }
        if (location.getMethodName() != null && location.getSignature() != null) {
            PsiMethod method = IntellijCodeNavigator.findMethod(psiClass, location.getMethodName(), location.getSignature());
            return method != null ? method : psiClass;
        }
        return psiClass;
    }

    @Nullable
    private static PsiMethod findMethod(@NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String signature) {
        if (psiClass == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(4);
        }
        if (methodName == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(5);
        }
        if (signature == null) {
            IntellijCodeNavigator.$$$reportNull$$$0(6);
        }
        for (PsiMethod method : psiClass.findMethodsByName(methodName, true)) {
            if (!signature.equals(TraceSignatureConverter.getTraceSignature(method))) continue;
            return method;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/profilers/stacktrace/IntellijCodeNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleNavigate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNavigatable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

