/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.AaptAttrAttributeSnapshot;
import com.android.tools.idea.rendering.AaptAttrParser;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.LayoutPullParser;
import com.android.tools.idea.rendering.MenuPsiPullParser;
import com.android.tools.idea.rendering.PaddingLayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutPsiPullParser
extends LayoutPullParser
implements AaptAttrParser {
    private static final ImmutableSet<String> TAGS_SUPPORTING_SRC_COMPAT = ImmutableSet.of((Object)"ImageButton", (Object)"ImageView");
    private static final TagSnapshot EMPTY_LAYOUT = TagSnapshot.createSyntheticTag(null, "LinearLayout", "android", "http://schemas.android.com/apk/res/android", (List<AttributeSnapshot>)ImmutableList.of((Object)new AttributeSnapshot("http://schemas.android.com/apk/res/android", "android", "layout_width", "match_parent"), (Object)new AttributeSnapshot("http://schemas.android.com/apk/res/android", "android", "layout_height", "match_parent")), (List<TagSnapshot>)ImmutableList.of());
    private static final Consumer<TagSnapshot> TAG_SNAPSHOT_DECORATOR = tag -> {
        if ("com.google.android.gms.ads.AdView".equals(tag.tagName) || "com.google.android.gms.maps.MapView".equals(tag.tagName)) {
            tag.setAttribute("minWidth", "http://schemas.android.com/tools", "tools", "50dp", false);
            tag.setAttribute("minHeight", "http://schemas.android.com/tools", "tools", "50dp", false);
            tag.setAttribute("background", "http://schemas.android.com/tools", "tools", "#AAA", false);
        }
    };
    @NotNull
    private final ILayoutLog myLogger;
    @NotNull
    private final List<TagSnapshot> myNodeStack;
    protected final TagSnapshot myRoot;
    @NotNull
    protected final ImmutableMap<String, String> myNamespacePrefixes;
    protected boolean myProvideViewCookies;
    private boolean myUseSrcCompat;
    private final ImmutableMap<String, TagSnapshot> myDeclaredAaptAttrs;

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull IRenderLogger logger, boolean honorMergeParentTag) {
        if (file == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(1);
        }
        if (ResourceHelper.getFolderType((PsiFile)file) == ResourceFolderType.MENU) {
            MenuPsiPullParser menuPsiPullParser = new MenuPsiPullParser(file, (ILayoutLog)logger);
            if (menuPsiPullParser == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(2);
            }
            return menuPsiPullParser;
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(file, (ILayoutLog)logger, honorMergeParentTag);
        if (layoutPsiPullParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(3);
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull IRenderLogger logger) {
        if (file == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(4);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(5);
        }
        LayoutPsiPullParser layoutPsiPullParser = LayoutPsiPullParser.create(file, logger, true);
        if (layoutPsiPullParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(6);
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull IRenderLogger logger, Set<XmlTag> explodeNodes, @NotNull Density density) {
        if (file == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(7);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(8);
        }
        if (density == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(9);
        }
        if (explodeNodes != null && !explodeNodes.isEmpty()) {
            PaddingLayoutPsiPullParser paddingLayoutPsiPullParser = new PaddingLayoutPsiPullParser(file, logger, explodeNodes, density);
            if (paddingLayoutPsiPullParser == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(10);
            }
            return paddingLayoutPsiPullParser;
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(file, (ILayoutLog)logger, true);
        if (layoutPsiPullParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(11);
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(RenderTask.AttributeFilter filter, @NotNull XmlTag root, @NotNull IRenderLogger logger) {
        if (root == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(12);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(13);
        }
        AttributeFilteredLayoutParser attributeFilteredLayoutParser = new AttributeFilteredLayoutParser(root, (ILayoutLog)logger, filter);
        if (attributeFilteredLayoutParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(14);
        }
        return attributeFilteredLayoutParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull TagSnapshot root, @NotNull ILayoutLog log) {
        if (root == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(15);
        }
        if (log == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(16);
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(root, log);
        if (layoutPsiPullParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(17);
        }
        return layoutPsiPullParser;
    }

    protected LayoutPsiPullParser(@NotNull XmlFile file, @NotNull ILayoutLog logger, boolean honorMergeParentTag) {
        if (file == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(18);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(19);
        }
        this(AndroidPsiUtils.getRootTagSafely(file), logger, honorMergeParentTag);
    }

    @NotNull
    private static ImmutableMap<String, String> buildNamespacesMap(TagSnapshot root) {
        XmlTag rootTag;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ImmutableMap immutableMap = (ImmutableMap)ApplicationManager.getApplication().runReadAction(() -> LayoutPsiPullParser.buildNamespacesMap(root));
            if (immutableMap == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(20);
            }
            return immutableMap;
        }
        XmlTag xmlTag = rootTag = root != null ? root.tag : null;
        if (rootTag == null || !rootTag.isValid()) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(21);
            }
            return immutableMap;
        }
        ImmutableMap.Builder prefixesBuilder = ImmutableMap.builder();
        for (String uri : new String[]{"http://schemas.android.com/apk/res/android", "http://schemas.android.com/tools", "http://schemas.android.com/apk/res-auto"}) {
            String prefix = rootTag.getPrefixByNamespace(uri);
            if (prefix == null) continue;
            prefixesBuilder.put((Object)uri, (Object)prefix);
        }
        ImmutableMap immutableMap = prefixesBuilder.build();
        if (immutableMap == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(22);
        }
        return immutableMap;
    }

    protected LayoutPsiPullParser(XmlTag root, @NotNull ILayoutLog logger, boolean honorMergeParentTag) {
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(23);
        }
        this.myNodeStack = new ArrayList<TagSnapshot>();
        this.myProvideViewCookies = true;
        this.myLogger = logger;
        this.myRoot = root != null ? (TagSnapshot)ApplicationManager.getApplication().runReadAction(() -> {
            if (root.isValid()) {
                return LayoutPsiPullParser.createSnapshot(root, honorMergeParentTag);
            }
            return EMPTY_LAYOUT;
        }) : EMPTY_LAYOUT;
        this.myNamespacePrefixes = LayoutPsiPullParser.buildNamespacesMap(this.myRoot);
        this.myDeclaredAaptAttrs = LayoutPsiPullParser.findDeclaredAaptAttrs(this.myRoot);
    }

    protected LayoutPsiPullParser(@NotNull TagSnapshot root, @NotNull ILayoutLog log) {
        if (root == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(24);
        }
        if (log == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(25);
        }
        this.myNodeStack = new ArrayList<TagSnapshot>();
        this.myProvideViewCookies = true;
        this.myLogger = log;
        this.myDeclaredAaptAttrs = ImmutableMap.of();
        this.myRoot = (TagSnapshot)ApplicationManager.getApplication().runReadAction(() -> {
            if (root == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(43);
            }
            if (root.tag != null && root.tag.isValid()) {
                return root;
            }
            return null;
        });
        this.myNamespacePrefixes = LayoutPsiPullParser.buildNamespacesMap(this.myRoot);
    }

    @Override
    @NotNull
    public ImmutableMap<String, TagSnapshot> getAaptDeclaredAttrs() {
        ImmutableMap<String, TagSnapshot> immutableMap = this.myDeclaredAaptAttrs;
        if (immutableMap == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(26);
        }
        return immutableMap;
    }

    @NotNull
    private static ImmutableMap<String, TagSnapshot> findDeclaredAaptAttrs(TagSnapshot tag) {
        if (tag == null || !tag.hasDeclaredAaptAttrs) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(27);
            }
            return immutableMap;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        tag.attributes.stream().filter(attr -> attr instanceof AaptAttrAttributeSnapshot).map(attr -> (AaptAttrAttributeSnapshot)attr).forEach(attr -> builder.put((Object)attr.getId(), (Object)attr.getBundledTag()));
        for (TagSnapshot child : tag.children) {
            builder.putAll(LayoutPsiPullParser.findDeclaredAaptAttrs(child));
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(28);
        }
        return immutableMap;
    }

    protected final TagSnapshot getCurrentNode() {
        if (!this.myNodeStack.isEmpty()) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    protected final TagSnapshot getPreviousNode() {
        if (this.myNodeStack.size() > 1) {
            return this.myNodeStack.get(this.myNodeStack.size() - 2);
        }
        return null;
    }

    protected final AttributeSnapshot getAttribute(int i) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        TagSnapshot uiNode = this.getCurrentNode();
        if (uiNode != null) {
            return uiNode.attributes.get(i);
        }
        return null;
    }

    protected void push(@NotNull TagSnapshot node) {
        if (node == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(29);
        }
        this.myNodeStack.add(node);
    }

    @NotNull
    protected TagSnapshot pop() {
        TagSnapshot tagSnapshot = this.myNodeStack.remove(this.myNodeStack.size() - 1);
        if (tagSnapshot == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(30);
        }
        return tagSnapshot;
    }

    public Object getViewCookie() {
        if (this.myProvideViewCookies) {
            return this.getCurrentNode();
        }
        return null;
    }

    public ILayoutPullParser getParser(String layoutName) {
        return null;
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    public int getAttributeCount() {
        TagSnapshot node = this.getCurrentNode();
        if (node != null) {
            return node.attributes.size();
        }
        return 0;
    }

    public String getAttributeName(int i) {
        AttributeSnapshot attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.name;
        }
        return null;
    }

    public String getAttributeNamespace(int i) {
        AttributeSnapshot attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.namespace;
        }
        return "";
    }

    public String getAttributePrefix(int i) {
        AttributeSnapshot attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.prefix;
        }
        return null;
    }

    public String getAttributeValue(int i) {
        AttributeSnapshot attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.value;
        }
        return null;
    }

    public String getAttributeValue(String namespace, String localName) {
        TagSnapshot tag = this.getCurrentNode();
        if (tag != null) {
            int n;
            String srcCompatValue;
            if ("layout".equals(localName) && "fragment".equals(tag.tagName)) {
                String layout = tag.getAttribute("layout", "http://schemas.android.com/tools");
                if (layout != null) {
                    return layout;
                }
            } else if (this.myUseSrcCompat && "src".equals(localName) && TAGS_SUPPORTING_SRC_COMPAT.contains((Object)tag.tagName) && (srcCompatValue = tag.getAttribute("srcCompat", "http://schemas.android.com/apk/res-auto")) != null) {
                return srcCompatValue;
            }
            String value = null;
            if (namespace == null) {
                value = tag.getAttribute(localName);
            } else if (namespace.equals("http://schemas.android.com/apk/res/android") || namespace.equals("http://schemas.android.com/apk/res-auto")) {
                String toolsPrefix = (String)this.myNamespacePrefixes.get((Object)"http://schemas.android.com/tools");
                if (toolsPrefix == null) {
                    return tag.getAttribute(localName, namespace);
                }
                int n2 = tag.attributes.size();
                for (int i = 0; i < n2; ++i) {
                    AttributeSnapshot attribute = tag.attributes.get(i);
                    if (!localName.equals(attribute.name)) continue;
                    if (toolsPrefix.equals(attribute.prefix)) {
                        value = attribute.value;
                        if (value != null && value.isEmpty()) {
                            value = tag.getAttribute(localName, "http://schemas.android.com/apk/res/android") != null ? null : value;
                        }
                        break;
                    }
                    if (!namespace.equals(attribute.namespace)) continue;
                    value = attribute.value;
                }
            } else if (!"http://schemas.android.com/tools".equals(namespace)) {
                n = tag.attributes.size();
                for (int i = 0; i < n; ++i) {
                    AttributeSnapshot attribute = tag.attributes.get(i);
                    if (!localName.equals(attribute.name) || !namespace.equals(attribute.namespace) && !"http://schemas.android.com/apk/res-auto".equals(attribute.namespace)) continue;
                    value = attribute.value;
                    break;
                }
            } else {
                value = tag.getAttribute(localName, namespace);
            }
            if (value != null) {
                if ("match_parent".equals(value) && ("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "fill_parent";
                }
                n = value.length();
                for (int i = 0; i < n; ++i) {
                    char c = value.charAt(i);
                    if (c != '&' && c != '\\') continue;
                    value = ValueXmlHelper.unescapeResourceString((String)value, (boolean)true, (boolean)false);
                    break;
                }
            }
            return value;
        }
        return null;
    }

    public int getDepth() {
        return this.myNodeStack.size();
    }

    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            String name = currentNode.tagName;
            String viewHandlerTag = currentNode.getAttribute("useHandler", "http://schemas.android.com/tools");
            if (StringUtil.isNotEmpty((String)viewHandlerTag)) {
                name = viewHandlerTag;
            }
            if (name.equals("fragment")) {
                String layout = currentNode.getAttribute("layout", "http://schemas.android.com/tools");
                if (layout != null) {
                    return "include";
                }
                String fragmentId = currentNode.getAttribute("class");
                if ((fragmentId == null || fragmentId.isEmpty()) && ((fragmentId = currentNode.getAttribute("name", "http://schemas.android.com/apk/res/android")) == null || fragmentId.isEmpty())) {
                    fragmentId = currentNode.getAttribute("id", "http://schemas.android.com/apk/res/android");
                }
                this.myLogger.warning("missing.fragment", "Missing fragment association", null, (Object)fragmentId);
            } else if (name.endsWith("Compat") && name.indexOf(46) == -1) {
                return name.substring(0, name.length() - "Compat".length());
            }
            return name;
        }
        return null;
    }

    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.namespace;
        }
        return null;
    }

    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.prefix;
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.children.isEmpty();
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        TagSnapshot node = this.getCurrentNode();
        assert (node != null);
        List<TagSnapshot> children = node.children;
        if (!children.isEmpty()) {
            this.push(children.get(0));
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        TagSnapshot node = this.getCurrentNode();
        assert (node != null);
        TagSnapshot sibling = node.getNextSibling();
        if (sibling != null) {
            node = sibling;
            this.pop();
            this.push(node);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    public void setProvideViewCookies(boolean provideViewCookies) {
        this.myProvideViewCookies = provideViewCookies;
    }

    private static int distanceToLayoutTag(@NotNull XmlTag tag) {
        if (tag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(31);
        }
        int distance = 0;
        while ((tag = tag.getParentTag()) != null) {
            String tagName = tag.getName();
            if (!"merge".equals(tagName)) {
                ++distance;
            }
            if (!"layout".equals(tagName)) continue;
            break;
        }
        return tag != null ? distance : -1;
    }

    private static TagSnapshot createSnapshot(@NotNull XmlTag tag, boolean honorMergeParentTag) {
        String prefix;
        XmlAttribute id;
        String rootTag;
        if (tag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(32);
        }
        Consumer<TagSnapshot> tagDecorator = TAG_SNAPSHOT_DECORATOR;
        if (tag.getName().equals("layout")) {
            final String layoutRootName = tag.getContainingFile().getVirtualFile().getNameWithoutExtension();
            tagDecorator = tagDecorator.andThen(new Consumer<TagSnapshot>(){
                int counter = 0;

                @Override
                public void accept(TagSnapshot snapshot) {
                    if (snapshot.tag == null) {
                        return;
                    }
                    if (LayoutPsiPullParser.distanceToLayoutTag(snapshot.tag) == 1) {
                        snapshot.setAttribute("tag", "http://schemas.android.com/apk/res/android", "android", "layout/" + layoutRootName + "_" + this.counter++, false);
                    }
                }
            });
        }
        if ((tag = LayoutPsiPullParser.getRootTag(tag)) == null || tag.isEmpty() && tag.getName().isEmpty()) {
            return EMPTY_LAYOUT;
        }
        switch (rootTag = tag.getName()) {
            case "fragment": {
                return LayoutPsiPullParser.createSnapshotForViewFragment(tag);
            }
            case "FrameLayout": {
                return LayoutPsiPullParser.createSnapshotForFrameLayout(tag, tagDecorator);
            }
            case "merge": {
                return LayoutPsiPullParser.createSnapshotForMerge(tag, honorMergeParentTag, tagDecorator);
            }
        }
        TagSnapshot root = TagSnapshot.createTagSnapshot(tag, tagDecorator);
        if ((rootTag.equals("ListView") || rootTag.equals("ExpandableListView") || rootTag.equals("GridView") || rootTag.equals("Spinner")) && (id = tag.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null && (prefix = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android")) != null) {
            root.setAttribute("id", "http://schemas.android.com/apk/res/android", prefix, "@+id/_dynamic");
        }
        return root;
    }

    @NotNull
    private static TagSnapshot createSnapshotForViewFragment(@NotNull XmlTag rootTag) {
        if (rootTag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(33);
        }
        XmlAttribute[] psiAttributes = rootTag.getAttributes();
        ArrayList attributes = Lists.newArrayListWithCapacity((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute);
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        ArrayList includeAttributes = Lists.newArrayListWithCapacity((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute;
            String localName;
            String name = psiAttribute.getName();
            if (name.startsWith("xmlns:") || (localName = psiAttribute.getLocalName()).startsWith("layout_margin") || localName.startsWith("padding") || localName.equals("id") || (attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute)) == null) continue;
            includeAttributes.add(attribute);
        }
        TagSnapshot include = TagSnapshot.createSyntheticTag(null, "fragment", "", "", includeAttributes, Collections.emptyList());
        TagSnapshot tagSnapshot = TagSnapshot.createSyntheticTag(rootTag, "FrameLayout", "", "", attributes, Collections.singletonList(include));
        if (tagSnapshot == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(34);
        }
        return tagSnapshot;
    }

    @NotNull
    private static TagSnapshot createSnapshotForFrameLayout(@NotNull XmlTag rootTag, @NotNull Consumer<TagSnapshot> tagDecorator) {
        String visibleChild;
        String prefix;
        if (rootTag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(35);
        }
        if (tagDecorator == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(36);
        }
        TagSnapshot root = TagSnapshot.createTagSnapshot(rootTag, tagDecorator);
        String layout = rootTag.getAttributeValue("layout", "http://schemas.android.com/tools");
        if (layout != null && root.children.isEmpty() && (prefix = rootTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android")) != null) {
            ArrayList children;
            root.children = children = Lists.newArrayList();
            ArrayList attributes = Lists.newArrayListWithExpectedSize((int)3);
            attributes.add(new AttributeSnapshot("", "", "layout", layout));
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix, "layout_width", "fill_parent"));
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix, "layout_height", "fill_parent"));
            TagSnapshot element = TagSnapshot.createSyntheticTag(null, "include", "", "", attributes, Collections.emptyList());
            children.add(element);
        }
        if ((visibleChild = rootTag.getAttributeValue("visibleChildren", "http://schemas.android.com/tools")) != null) {
            HashSet indices = Sets.newHashSet();
            for (String s : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)visibleChild)) {
                try {
                    indices.add(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String prefix2 = rootTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            if (prefix2 != null) {
                int n = root.children.size();
                for (int i = 0; i < n; ++i) {
                    TagSnapshot child = root.children.get(i);
                    boolean visible = indices.contains(i);
                    child.setAttribute("visibility", "http://schemas.android.com/apk/res/android", prefix2, visible ? "visible" : "gone");
                }
            }
        }
        TagSnapshot tagSnapshot = root;
        if (tagSnapshot == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(37);
        }
        return tagSnapshot;
    }

    @NotNull
    private static TagSnapshot createSnapshotForMerge(@NotNull XmlTag rootTag, boolean honorMergeParentTag, @NotNull Consumer<TagSnapshot> tagDecorator) {
        String parentTag;
        if (rootTag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(38);
        }
        if (tagDecorator == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(39);
        }
        TagSnapshot root = TagSnapshot.createTagSnapshot(rootTag, tagDecorator);
        String string = parentTag = honorMergeParentTag ? rootTag.getAttributeValue("parentTag", "http://schemas.android.com/tools") : null;
        if (parentTag == null) {
            TagSnapshot tagSnapshot = root;
            if (tagSnapshot == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(40);
            }
            return tagSnapshot;
        }
        TagSnapshot tagSnapshot = TagSnapshot.createSyntheticTag(rootTag, parentTag, "", "", AttributeSnapshot.createAttributesForTag(rootTag), root.children);
        if (tagSnapshot == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(41);
        }
        return tagSnapshot;
    }

    public static XmlTag getRootTag(@NotNull XmlTag tag) {
        if (tag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(42);
        }
        if (tag.getName().equals("layout")) {
            for (XmlTag subTag : tag.getSubTags()) {
                String subTagName = subTag.getName();
                if (subTagName.equals("data")) continue;
                return subTag;
            }
            return null;
        }
        return tag;
    }

    public void setUseSrcCompat(boolean useSrcCompat) {
        this.myUseSrcCompat = useSrcCompat;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/LayoutPsiPullParser";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 12: 
            case 15: 
            case 24: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 31: 
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 33: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/LayoutPsiPullParser";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNamespacesMap";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAaptDeclaredAttrs";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclaredAaptAttrs";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "pop";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createSnapshotForViewFragment";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createSnapshotForFrameLayout";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createSnapshotForMerge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 41: {
                break;
            }
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "distanceToLayoutTag";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createSnapshot";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createSnapshotForViewFragment";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSnapshotForFrameLayout";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createSnapshotForMerge";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getRootTag";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AttributeFilteredLayoutParser
    extends LayoutPsiPullParser {
        private final RenderTask.AttributeFilter myFilter;

        public AttributeFilteredLayoutParser(@NotNull XmlTag root, @NotNull ILayoutLog logger, RenderTask.AttributeFilter filter) {
            if (root == null) {
                AttributeFilteredLayoutParser.$$$reportNull$$$0(0);
            }
            if (logger == null) {
                AttributeFilteredLayoutParser.$$$reportNull$$$0(1);
            }
            super(root, logger, true);
            this.myFilter = filter;
        }

        public AttributeFilteredLayoutParser(@NotNull XmlFile file, @NotNull ILayoutLog logger, RenderTask.AttributeFilter filter) {
            if (file == null) {
                AttributeFilteredLayoutParser.$$$reportNull$$$0(2);
            }
            if (logger == null) {
                AttributeFilteredLayoutParser.$$$reportNull$$$0(3);
            }
            super(file, logger, true);
            this.myFilter = filter;
        }

        @Override
        public String getAttributeValue(String namespace, String localName) {
            String value;
            XmlTag tag;
            TagSnapshot element;
            if (this.myFilter != null && (element = this.getCurrentNode()) != null && (tag = element.tag) != null && (value = ApplicationManager.getApplication().isReadAccessAllowed() ? this.myFilter.getAttribute(tag, namespace, localName) : (String)ApplicationManager.getApplication().runReadAction(() -> this.myFilter.getAttribute(tag, namespace, localName))) != null) {
                if (value.isEmpty()) {
                    return null;
                }
                return value;
            }
            return super.getAttributeValue(namespace, localName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logger";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/rendering/LayoutPsiPullParser$AttributeFilteredLayoutParser";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

