/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeviceStateAtLaunch {
    private final Set<String> myDevicesUsedInLaunch;
    private final Set<String> myDevicesAvailableAtLaunch;

    public DeviceStateAtLaunch(@NotNull Collection<IDevice> usedDevices, @NotNull Collection<IDevice> allDevices) {
        if (usedDevices == null) {
            DeviceStateAtLaunch.$$$reportNull$$$0(0);
        }
        if (allDevices == null) {
            DeviceStateAtLaunch.$$$reportNull$$$0(1);
        }
        this.myDevicesUsedInLaunch = DeviceStateAtLaunch.serialize(usedDevices);
        this.myDevicesAvailableAtLaunch = DeviceStateAtLaunch.serialize(allDevices);
    }

    public Collection<IDevice> filterByUsed(@NotNull Collection<IDevice> devices) {
        if (devices == null) {
            DeviceStateAtLaunch.$$$reportNull$$$0(2);
        }
        HashSet used = Sets.newHashSetWithExpectedSize((int)this.myDevicesUsedInLaunch.size());
        for (IDevice d : devices) {
            if (!this.myDevicesUsedInLaunch.contains(d.getSerialNumber())) continue;
            used.add(d);
        }
        return used;
    }

    public boolean matchesCurrentAvailableDevices(@NotNull Collection<IDevice> devices) {
        if (devices == null) {
            DeviceStateAtLaunch.$$$reportNull$$$0(3);
        }
        if (this.myDevicesAvailableAtLaunch.size() != devices.size()) {
            return false;
        }
        for (IDevice d : devices) {
            if (this.myDevicesAvailableAtLaunch.contains(d.getSerialNumber())) continue;
            return false;
        }
        return true;
    }

    public boolean usedDevice(@NotNull IDevice device) {
        if (device == null) {
            DeviceStateAtLaunch.$$$reportNull$$$0(4);
        }
        return this.myDevicesUsedInLaunch.contains(device.getSerialNumber());
    }

    private static Set<String> serialize(Collection<IDevice> usedDevices) {
        HashSet s = Sets.newHashSetWithExpectedSize((int)usedDevices.size());
        for (IDevice d : usedDevices) {
            s.add(d.getSerialNumber());
        }
        return s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedDevices";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDevices";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/DeviceStateAtLaunch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "filterByUsed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesCurrentAvailableDevices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "usedDevice";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

