/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.util.LaunchStatus;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorMatchingReceiver
extends AndroidOutputReceiver {
    public static final int NO_ERROR = -2;
    public static final int UNTYPED_ERROR = -1;
    private static final Pattern FAILURE = Pattern.compile("Failure\\s+\\[(.*)\\]");
    private static final Pattern TYPED_ERROR = Pattern.compile("Error\\s+[Tt]ype\\s+(\\d+).*");
    private static final String ERROR_PREFIX = "Error";
    @NotNull
    private final LaunchStatus myLaunchStatus;
    private int errorType;
    private String failureMessage;
    private final StringBuilder output;

    public ErrorMatchingReceiver(@NotNull LaunchStatus launchStatus) {
        if (launchStatus == null) {
            ErrorMatchingReceiver.$$$reportNull$$$0(0);
        }
        this.errorType = -2;
        this.failureMessage = null;
        this.output = new StringBuilder();
        this.myLaunchStatus = launchStatus;
    }

    @Override
    protected void processNewLine(@NotNull String line) {
        if (line == null) {
            ErrorMatchingReceiver.$$$reportNull$$$0(1);
        }
        if (!line.isEmpty()) {
            Matcher errorMatcher;
            Matcher failureMatcher = FAILURE.matcher(line);
            if (failureMatcher.matches()) {
                this.failureMessage = failureMatcher.group(1);
            }
            if ((errorMatcher = TYPED_ERROR.matcher(line)).matches()) {
                this.errorType = Integer.parseInt(errorMatcher.group(1));
            } else if (line.startsWith(ERROR_PREFIX) && this.errorType == -2) {
                this.errorType = -1;
            }
        }
        this.output.append(line).append('\n');
    }

    public int getErrorType() {
        return this.errorType;
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMessage;
    }

    public boolean isCancelled() {
        return this.myLaunchStatus.isLaunchTerminated();
    }

    public boolean hasError() {
        return this.errorType != -2;
    }

    public StringBuilder getOutput() {
        return this.output;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/ErrorMatchingReceiver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processNewLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

