/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.collections.ObservableList;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.Stack;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public final class ServicePanelBuilder {
    @NotNull
    private final JPanel myRootPanel;
    @NotNull
    private final BindingsManager myBindings = new BindingsManager();
    @NotNull
    private final Stack<UiGrid> myGrids = new Stack();

    public ServicePanelBuilder() {
        this.myRootPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myRootPanel.putClientProperty("bindings", this.myBindings);
    }

    public JPanel getPanel() {
        assert (this.myGrids.isEmpty()) : "startGrid called without matching endGrid";
        return this.myRootPanel;
    }

    @NotNull
    public BindingsManager getBindings() {
        BindingsManager bindingsManager = this.myBindings;
        if (bindingsManager == null) {
            ServicePanelBuilder.$$$reportNull$$$0(0);
        }
        return bindingsManager;
    }

    public JPanel startGrid(@NotNull String colDefinitions) {
        if (colDefinitions == null) {
            ServicePanelBuilder.$$$reportNull$$$0(1);
        }
        UiGrid uiGrid = new UiGrid(colDefinitions);
        this.myGrids.push((Object)uiGrid);
        return uiGrid.getPanel();
    }

    public void endGrid() {
        assert (!this.myGrids.isEmpty()) : "endGrid called without matching startGrid";
        this.addComponent(((UiGrid)this.myGrids.pop()).getPanel());
    }

    public void setRow(int row) {
        assert (!this.myGrids.isEmpty()) : "setRow called without calling startGrid";
        ((UiGrid)this.myGrids.peek()).setCurrRow(row);
    }

    public void setCol(int col) {
        assert (!this.myGrids.isEmpty()) : "setCol called without calling startGrid";
        ((UiGrid)this.myGrids.peek()).setCurrCol(col);
    }

    public JButton addButton() {
        JButton button = new JButton();
        this.addComponent(button);
        return button;
    }

    public JCheckBox addCheckbox() {
        JCheckBox checkbox = new JCheckBox();
        this.addComponent(checkbox);
        return checkbox;
    }

    public JLabel addLabel() {
        JLabel label = new JLabel();
        this.addComponent(label);
        return label;
    }

    public HyperlinkLabel addLink(@NotNull String text, final @NotNull URI uri) {
        if (text == null) {
            ServicePanelBuilder.$$$reportNull$$$0(2);
        }
        if (uri == null) {
            ServicePanelBuilder.$$$reportNull$$$0(3);
        }
        HyperlinkLabel linkLabel = new HyperlinkLabel(text);
        linkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    Desktop.getDesktop().browse(uri);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.addComponent((JComponent)linkLabel);
        return linkLabel;
    }

    public JTextField addField() {
        JTextField field = new JTextField();
        this.addComponent(field);
        return field;
    }

    public JComboBox addComboBox(final @NotNull ObservableList<String> backingList) {
        if (backingList == null) {
            ServicePanelBuilder.$$$reportNull$$$0(4);
        }
        CollectionComboBoxModel<String> model = new CollectionComboBoxModel<String>(backingList){

            @NotNull
            public List<String> getItems() {
                ObservableList observableList = backingList;
                if (observableList == null) {
                    2.$$$reportNull$$$0(0);
                }
                return observableList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServicePanelBuilder$2", "getItems"));
            }
        };
        ComboBox comboBox = new ComboBox((ComboBoxModel)model);
        InvalidationListener onListModified = new InvalidationListener((CollectionComboBoxModel)model, backingList, comboBox){
            final /* synthetic */ CollectionComboBoxModel val$model;
            final /* synthetic */ ObservableList val$backingList;
            final /* synthetic */ ComboBox val$comboBox;
            {
                this.val$model = collectionComboBoxModel;
                this.val$backingList = observableList;
                this.val$comboBox = comboBox;
            }

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.val$model.update();
                if (!this.val$backingList.isEmpty() && this.val$comboBox.getSelectedIndex() < 0) {
                    this.val$comboBox.setSelectedIndex(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/structure/services/ServicePanelBuilder$3", "onInvalidated"));
            }
        };
        this.addComponent((JComponent)comboBox);
        backingList.addWeakListener(onListModified);
        comboBox.putClientProperty((Object)"onListModified", (Object)onListModified);
        return comboBox;
    }

    private void addComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            ServicePanelBuilder.$$$reportNull$$$0(5);
        }
        if (!this.myGrids.isEmpty()) {
            ((UiGrid)this.myGrids.peek()).addComponent(component2);
        } else {
            this.myRootPanel.add(component2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/structure/services/ServicePanelBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colDefinitions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backingList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/structure/services/ServicePanelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startGrid";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addLink";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addComboBox";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UiGrid {
        @NotNull
        private final JPanel myPanel;
        private final int myNumCols;
        private int myCurrCol;
        private int myCurrRow;

        public UiGrid(@NotNull String colDefinitions) {
            if (colDefinitions == null) {
                UiGrid.$$$reportNull$$$0(0);
            }
            TabularLayout layout = new TabularLayout(colDefinitions).setVGap(10);
            this.myNumCols = layout.getNumColumns();
            this.myPanel = new JPanel((LayoutManager)layout);
        }

        @NotNull
        public JPanel getPanel() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                UiGrid.$$$reportNull$$$0(1);
            }
            return jPanel;
        }

        public void setCurrCol(int col) {
            if (col >= this.myNumCols) {
                throw new IllegalArgumentException(String.format("Can't set col = %1$d on a grid with only %2$d columns", col, this.myNumCols));
            }
            this.myCurrCol = col;
        }

        public void setCurrRow(int row) {
            this.myCurrRow = row;
        }

        public void addComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                UiGrid.$$$reportNull$$$0(2);
            }
            this.myPanel.add((Component)component2, new TabularLayout.Constraint(this.myCurrRow, this.myCurrCol));
            this.myCurrRow = 0;
            this.myCurrCol = 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colDefinitions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/structure/services/ServicePanelBuilder$UiGrid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/structure/services/ServicePanelBuilder$UiGrid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addComponent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

