/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.DefaultResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.utils.XmlUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LinearResizeHandler
extends DefaultResizeHandler {
    public boolean useWeight;
    private float mNewWeightSum;
    private float mWeight;
    public final Map<NlComponent, Dimension> unweightedSizes;
    public int totalLength;
    public List<NlComponent> mClearWeights;
    protected LinearLayoutHandler myHandler;

    public LinearResizeHandler(@NotNull ViewEditor editor, @NotNull LinearLayoutHandler handler, @NotNull NlComponent component2, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        if (editor == null) {
            LinearResizeHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            LinearResizeHandler.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            LinearResizeHandler.$$$reportNull$$$0(2);
        }
        super(editor, handler, component2, horizontalEdgeType, verticalEdgeType);
        this.myHandler = handler;
        this.unweightedSizes = editor.measureChildren(this.layout, (n, namespace, localName) -> {
            if ("layout_weight".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "";
            }
            return null;
        });
        this.totalLength = 0;
        boolean isVertical = handler.isVertical(this.layout);
        if (this.unweightedSizes != null) {
            for (Map.Entry<NlComponent, Dimension> entry : this.unweightedSizes.entrySet()) {
                Dimension preferredSize = entry.getValue();
                if (isVertical) {
                    this.totalLength += preferredSize.height;
                    continue;
                }
                this.totalLength += preferredSize.width;
            }
        }
    }

    void reset() {
        this.mNewWeightSum = -1.0f;
        this.useWeight = false;
        this.mClearWeights = null;
    }

    void setWeight(float weight) {
        this.useWeight = true;
        this.mWeight = weight;
    }

    void setWeightSum(float weightSum) {
        this.mNewWeightSum = weightSum;
    }

    void clearWeight(NlComponent n) {
        if (this.mClearWeights == null) {
            this.mClearWeights = new ArrayList<NlComponent>();
        }
        this.mClearWeights.add(n);
    }

    public void apply() {
        assert (this.useWeight);
        String value = this.mWeight > 0.0f ? XmlUtils.formatFloatAttribute((double)this.mWeight) : null;
        this.component.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value);
        if (this.mClearWeights != null) {
            for (NlComponent n : this.mClearWeights) {
                if (!(LinearLayoutHandler.getWeight(n) > 0.0f)) continue;
                n.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            }
        }
        if ((double)this.mNewWeightSum > 0.0) {
            this.layout.setAttribute("http://schemas.android.com/apk/res/android", "weightSum", XmlUtils.formatFloatAttribute((double)this.mNewWeightSum));
        }
    }

    protected void updateResizeState(NlComponent component2, NlComponent layout, Rectangle oldBounds, Rectangle newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        Dimension nodeBounds;
        Map<NlComponent, Dimension> sizes;
        Dimension nodePreferredSize;
        float sum;
        this.reset();
        if (oldBounds.equals(newBounds)) {
            return;
        }
        boolean isVertical = this.myHandler.isVertical(layout);
        if (!isVertical && verticalEdge != null) {
            if (this.wrapWidth || this.fillWidth) {
                this.clearWeight(component2);
                return;
            }
            if (newBounds.width == oldBounds.width) {
                return;
            }
        }
        if (isVertical && horizontalEdge != null) {
            if (this.wrapHeight || this.fillHeight) {
                this.clearWeight(component2);
                return;
            }
            if (newBounds.height == oldBounds.height) {
                return;
            }
        }
        if ((sum = LinearLayoutHandler.getWeightSum(layout)) <= 0.0f) {
            sum = 1.0f;
            this.setWeightSum(sum);
        }
        Dimension dimension = nodePreferredSize = (sizes = this.unweightedSizes) != null ? sizes.get(component2) : null;
        if (nodePreferredSize != null && (horizontalEdge != null && newBounds.height < nodePreferredSize.height || verticalEdge != null && newBounds.width < nodePreferredSize.width)) {
            return;
        }
        Rectangle layoutBounds = new Rectangle(NlComponentHelperKt.getX(layout), NlComponentHelperKt.getY(layout), NlComponentHelperKt.getW(layout), NlComponentHelperKt.getH(layout));
        int remaining = (isVertical ? layoutBounds.height : layoutBounds.width) - this.totalLength;
        Dimension dimension2 = nodeBounds = sizes != null ? sizes.get(component2) : null;
        if (nodeBounds == null) {
            return;
        }
        if (remaining > 0) {
            int missing = 0;
            if (isVertical) {
                if (newBounds.height > nodeBounds.height) {
                    missing = newBounds.height - nodeBounds.height;
                } else if (this.wrapBounds != null && newBounds.height > this.wrapBounds.height) {
                    missing = newBounds.height - this.wrapBounds.height;
                    remaining += nodeBounds.height - this.wrapBounds.height;
                    this.wrapHeight = true;
                }
            } else if (newBounds.width > nodeBounds.width) {
                missing = newBounds.width - nodeBounds.width;
            } else if (this.wrapBounds != null && newBounds.width > this.wrapBounds.width) {
                missing = newBounds.width - this.wrapBounds.width;
                remaining += nodeBounds.width - this.wrapBounds.width;
                this.wrapWidth = true;
            }
            if (missing > 0) {
                float weight = (float)missing * sum / (float)remaining;
                this.setWeight(weight);
            }
        }
    }

    @Override
    protected void setNewSizeBounds(@NotNull NlComponent component2, @NotNull NlComponent layout, @NotNull Rectangle oldBounds, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
        if (component2 == null) {
            LinearResizeHandler.$$$reportNull$$$0(3);
        }
        if (layout == null) {
            LinearResizeHandler.$$$reportNull$$$0(4);
        }
        if (oldBounds == null) {
            LinearResizeHandler.$$$reportNull$$$0(5);
        }
        if (newBounds == null) {
            LinearResizeHandler.$$$reportNull$$$0(6);
        }
        this.updateResizeState(component2, layout, oldBounds, newBounds, horizontalEdge, verticalEdge);
        if (this.useWeight) {
            this.apply();
            boolean isVertical = this.myHandler.isVertical(layout);
            if (!isVertical && horizontalEdge != null && (newBounds.height != oldBounds.height || this.wrapHeight || this.fillHeight)) {
                component2.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", this.getHeightAttribute());
            }
            if (isVertical && verticalEdge != null && (newBounds.width != oldBounds.width || this.wrapWidth || this.fillWidth)) {
                component2.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", this.getWidthAttribute());
            }
        } else {
            component2.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            super.setNewSizeBounds(component2, layout, oldBounds, newBounds, horizontalEdge, verticalEdge);
        }
    }

    @Override
    protected String getResizeUpdateMessage(@NotNull NlComponent child, @NotNull NlComponent parent, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
        if (child == null) {
            LinearResizeHandler.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            LinearResizeHandler.$$$reportNull$$$0(8);
        }
        if (newBounds == null) {
            LinearResizeHandler.$$$reportNull$$$0(9);
        }
        this.updateResizeState(child, parent, newBounds, newBounds, horizontalEdge, verticalEdge);
        if (this.useWeight) {
            String height;
            String width;
            String weight = XmlUtils.formatFloatAttribute((double)this.mWeight);
            String dimension = String.format("weight %1$s", weight);
            if (this.myHandler.isVertical(parent)) {
                width = this.getWidthAttribute();
                height = dimension;
            } else {
                width = dimension;
                height = this.getHeightAttribute();
            }
            if (horizontalEdge == null) {
                return width;
            }
            if (verticalEdge == null) {
                return height;
            }
            return String.format("%s \u00d7 %s", width, height);
        }
        return super.getResizeUpdateMessage(child, parent, newBounds, horizontalEdge, verticalEdge);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldBounds";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBounds";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/linear/LinearResizeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setNewSizeBounds";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getResizeUpdateMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

