/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.ide.common.repository.GradleVersion;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.common.editor.NlEditor;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.util.XmlTagUtil;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\"\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r\u001a \u0010\u000e\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a8\u0010\u0010\u001a\u0004\u0018\u00010\u000b*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u001a(\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0005\u001a0\u0010\u001d\u001a\u00020\u001e*\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!\u001a\u0012\u0010\"\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0005\u001a\u0012\u0010#\u001a\u00020\u001e*\u00020\b2\u0006\u0010$\u001a\u00020%\u001a\u001e\u0010&\u001a\u00020\u001e*\u00020\b2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u0010)\u001a\u00020(\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"BASE_ID_PATTERN", "Lkotlin/text/Regex;", "getBASE_ID_PATTERN", "()Lkotlin/text/Regex;", "CUSTOM_DENSITY_ID", "", "addDependencies", "", "Lcom/android/tools/idea/common/model/NlModel;", "toAdd", "", "Lcom/android/tools/idea/common/model/NlComponent;", "insertType", "Lcom/android/tools/idea/uibuilder/api/InsertType;", "canAddComponents", "receiver", "createComponent", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "parent", "before", "createComponents", "item", "Lcom/android/tools/idea/uibuilder/model/DnDTransferItem;", "getModuleDependencyVersion", "Lcom/android/ide/common/repository/GradleVersion;", "artifact", "handleAddition", "", "added", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "isModuleDependency", "overrideConfigurationDensity", "density", "Lcom/android/resources/Density;", "overrideConfigurationScreenSize", "xDimension", "", "yDimension", "intellij.android.designer"})
public final class NlModelHelperKt {
    @NotNull
    public static final String CUSTOM_DENSITY_ID = "Custom Density";
    @NotNull
    private static final Regex BASE_ID_PATTERN = new Regex("(.*[^0-9])([0-9]+)?");

    @NotNull
    public static final Regex getBASE_ID_PATTERN() {
        return BASE_ID_PATTERN;
    }

    public static final boolean isModuleDependency(@NotNull NlModel $receiver, @NotNull String artifact) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        AndroidModuleModel gradleModel = AndroidModuleModel.get($receiver.getFacet());
        return gradleModel != null && GradleUtil.dependsOn(gradleModel, artifact);
    }

    @Nullable
    public static final GradleVersion getModuleDependencyVersion(@NotNull NlModel $receiver, @NotNull String artifact) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        AndroidModuleModel gradleModel = AndroidModuleModel.get($receiver.getFacet());
        return gradleModel != null ? GradleUtil.getModuleDependencyVersion(gradleModel, artifact) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationScreenSize(@NotNull NlModel $receiver, int xDimension, int yDimension) {
        State newState;
        VirtualFile better;
        Device device;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Configuration configuration = $receiver.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"configuration");
        Device original = configuration.getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device2 = device = deviceBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)device2, (String)"device");
        Iterator iterator = device2.getAllStates().iterator();
        while (iterator.hasNext()) {
            Screen screen;
            State state;
            State state2 = state = (State)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)state2, (String)"state");
            Hardware hardware = state2.getHardware();
            Intrinsics.checkExpressionValueIsNotNull((Object)hardware, (String)"state.hardware");
            Screen screen2 = screen = hardware.getScreen();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen2, (String)"screen");
            screen2.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            Density density = screen.getPixelDensity();
            Intrinsics.checkExpressionValueIsNotNull((Object)density, (String)"screen.pixelDensity");
            double dpi = density.getDpiValue();
            double width = (double)xDimension / dpi;
            double height = (double)yDimension / dpi;
            double diagonalLength = Math.sqrt(width * width + height * height);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(AvdScreenData.getScreenSize(diagonalLength));
            screen.setRatio(AvdScreenData.getScreenRatio(xDimension, yDimension));
            Hardware hardware2 = device.getDefaultHardware();
            Intrinsics.checkExpressionValueIsNotNull((Object)hardware2, (String)"device.defaultHardware");
            Screen screen3 = hardware2.getScreen();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen3, (String)"device.defaultHardware.screen");
            screen.setScreenRound(screen3.getScreenRound());
            Hardware hardware3 = device.getDefaultHardware();
            Intrinsics.checkExpressionValueIsNotNull((Object)hardware3, (String)"device.defaultHardware");
            Screen screen4 = hardware3.getScreen();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen4, (String)"device.defaultHardware.screen");
            screen.setChin(screen4.getChin());
        }
        Configuration configuration2 = $receiver.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
        ConfigurationManager configurationManager = configuration2.getConfigurationManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationManager, (String)"configuration.configurationManager");
        List<Device> devices = configurationManager.getDevices();
        boolean customDeviceReplaced = false;
        int screen = 0;
        List<Device> list = devices;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"devices");
        int dpi = ((Collection)list).size();
        while (screen < dpi) {
            void i;
            Device device3 = devices.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)device3, (String)"devices[i]");
            if (Intrinsics.areEqual((Object)"Custom", (Object)device3.getId())) {
                devices.set((int)i, device);
                customDeviceReplaced = true;
                break;
            }
            ++i;
        }
        if (!customDeviceReplaced) {
            devices.add(device);
        }
        if (xDimension > yDimension) {
            better = ConfigurationMatcher.getBetterMatch($receiver.getConfiguration(), device, "Landscape", null, null);
            newState = device.getState("Landscape");
        } else {
            better = ConfigurationMatcher.getBetterMatch($receiver.getConfiguration(), device, "Portrait", null, null);
            newState = device.getState("Portrait");
        }
        if (better != null) {
            Configuration configuration3 = $receiver.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
            VirtualFile virtualFile = configuration3.getFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile old = virtualFile;
            Project project = $receiver.getProject();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, better, -1);
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor selectedEditor = manager.getSelectedEditor(old);
            manager.openEditor(descriptor, true);
            if (selectedEditor instanceof NlEditor) {
                manager.setSelectedEditor(better, "android-designer2");
            } else if (selectedEditor != null) {
                TextEditorProvider textEditorProvider = TextEditorProvider.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)textEditorProvider, (String)"TextEditorProvider.getInstance()");
                manager.setSelectedEditor(better, textEditorProvider.getEditorTypeId());
            }
            Configuration configuration4 = $receiver.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration4, (String)"configuration");
            AndroidFacet facet = AndroidFacet.getInstance(configuration4.getModule());
            if (facet != null) {
                Configuration configuration5 = ConfigurationManager.getOrCreateInstance(facet).getConfiguration(better);
                configuration5.setEffectiveDevice(device, newState);
            }
        } else {
            $receiver.getConfiguration().setEffectiveDevice(device, newState);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationDensity(@NotNull NlModel $receiver, @NotNull Density density) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Device device;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Configuration configuration = $receiver.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"configuration");
        Device original = configuration.getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId(CUSTOM_DENSITY_ID);
        Device device2 = device = deviceBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)device2, (String)"device");
        List list = device2.getAllStates();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"device.allStates");
        Iterable iterable = list;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            State state = (State)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            Hardware hardware = v3.getHardware();
            Intrinsics.checkExpressionValueIsNotNull((Object)hardware, (String)"it.hardware");
            Screen screen = hardware.getScreen();
            collection.add(screen);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Screen it;
            Screen screen = it = (Screen)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)screen, (String)"it");
            screen.setPixelDensity(density);
        }
        $receiver.getConfiguration().setEffectiveDevice(device, device.getDefaultState());
    }

    public static final boolean canAddComponents(@NotNull NlModel $receiver, @NotNull NlComponent receiver, @NotNull List<? extends NlComponent> toAdd) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        Intrinsics.checkParameterIsNotNull(toAdd, (String)"toAdd");
        if (!NlComponentHelperKt.getHasNlComponentInfo(receiver)) {
            return false;
        }
        ViewHandler viewHandler = NlComponentHelperKt.getViewHandler(receiver);
        if (!(viewHandler instanceof ViewGroupHandler)) {
            viewHandler = null;
        }
        ViewGroupHandler viewGroupHandler = (ViewGroupHandler)viewHandler;
        if (viewGroupHandler == null) {
            return false;
        }
        ViewGroupHandler parentHandler = viewGroupHandler;
        for (NlComponent nlComponent : toAdd) {
            if (!parentHandler.acceptsChild(receiver, nlComponent)) {
                return false;
            }
            ViewHandler handler = ViewHandlerManager.get($receiver.getProject()).getHandler(nlComponent);
            if (handler == null || handler.acceptsParent(receiver, nlComponent)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static final NlComponent createComponent(@NotNull NlModel $receiver, @NotNull SceneView sceneView, @NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before, @NotNull InsertType insertType) {
        ViewHandler parentHandler;
        NlComponent child;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)sceneView, (String)"sceneView");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        NlComponent nlComponent = child = $receiver.createComponent(tag, parent, before);
        Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"child");
        XmlTag realTag = nlComponent.getTag();
        if (parent != null) {
            if (realTag.getAttribute("layout_width", "http://schemas.android.com/apk/res/android") == null) {
                realTag.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", "wrap_content");
            }
            if (realTag.getAttribute("layout_height", "http://schemas.android.com/apk/res/android") == null) {
                realTag.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", "wrap_content");
            }
        } else {
            if (realTag.getAttribute("android:layout_width") == null) {
                realTag.setAttribute("android:layout_width", "wrap_content");
            }
            if (realTag.getAttribute("android:layout_height") == null) {
                realTag.setAttribute("android:layout_height", "wrap_content");
            }
        }
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get($receiver.getProject());
        ViewHandler childHandler = viewHandlerManager.getHandler(child);
        ViewEditorImpl editor = new ViewEditorImpl(sceneView);
        if (childHandler != null) {
            boolean ok = childHandler.onCreate(editor, parent, child, insertType);
            if (parent != null) {
                ok &= NlModelHelperKt.addDependencies($receiver, (List)ImmutableList.of((Object)child), InsertType.CREATE);
            }
            if (!ok) {
                NlComponent nlComponent2 = parent;
                if (nlComponent2 != null) {
                    nlComponent2.removeChild(child);
                }
                realTag.delete();
                return null;
            }
        }
        if (parent != null && (parentHandler = viewHandlerManager.getHandler(parent)) instanceof ViewGroupHandler) {
            ((ViewGroupHandler)parentHandler).onChildInserted(editor, parent, child, insertType);
        }
        return child;
    }

    public static final boolean addDependencies(@NotNull NlModel $receiver, @Nullable List<? extends NlComponent> toAdd, @NotNull InsertType insertType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        if (toAdd == null || insertType.isMove()) {
            return true;
        }
        HashSet artifacts = new HashSet();
        Iterable $receiver$iv = toAdd;
        for (Object element$iv : $receiver$iv) {
            NlComponent it = (NlComponent)element$iv;
            NlComponentHelperKt.getDependencies(it, artifacts);
        }
        List dependencies2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)artifacts), (Function1)addDependencies.dependencies.1.INSTANCE), (Function1)addDependencies.dependencies.2.INSTANCE));
        GradleDependencyManager manager = GradleDependencyManager.getInstance($receiver.getProject());
        return manager.ensureLibraryIsIncluded($receiver.getModule(), dependencies2, null);
    }

    @NotNull
    public static final List<NlComponent> createComponents(@NotNull NlModel $receiver, @NotNull SceneView sceneView, @NotNull DnDTransferItem item, @NotNull InsertType insertType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)sceneView, (String)"sceneView");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        ArrayList<NlComponent> components = new ArrayList<NlComponent>(item.getComponents().size());
        for (DnDTransferComponent dndComponent : item.getComponents()) {
            NlComponent component2;
            XmlTag tag;
            NlModel nlModel = sceneView.getModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)nlModel, (String)"sceneView.model");
            Project project = nlModel.getProject();
            DnDTransferComponent dnDTransferComponent = dndComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)dnDTransferComponent, (String)"dndComponent");
            XmlTag xmlTag = tag = XmlTagUtil.createTag(project, dnDTransferComponent.getRepresentation());
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag, (String)"tag");
            if (NlModelHelperKt.createComponent($receiver, sceneView, xmlTag, null, null, insertType) == null) {
                List<NlComponent> list = Collections.emptyList();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
                return list;
            }
            NlComponentHelperKt.setW(component2, dndComponent.getWidth());
            NlComponentHelperKt.setH(component2, dndComponent.getHeight());
            components.add(component2);
        }
        return components;
    }

    public static final void handleAddition(@NotNull NlModel $receiver, @NotNull List<? extends NlComponent> added, @NotNull NlComponent receiver, @NotNull InsertType insertType, @NotNull DesignSurface surface) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(added, (String)"added");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        Intrinsics.checkParameterIsNotNull((Object)surface, (String)"surface");
        InsertType realInsertType = insertType;
        if (!NlComponentHelperKt.getHasNlComponentInfo(receiver)) {
            return;
        }
        HashSet ids = Sets.newHashSet((Iterable)NlComponent.getIds($receiver));
        ViewGroupHandler viewGroupHandler = (ViewGroupHandler)NlComponentHelperKt.getViewHandler(receiver);
        if (viewGroupHandler == null) {
            Intrinsics.throwNpe();
        }
        ViewGroupHandler groupHandler = viewGroupHandler;
        SceneView sceneView = surface.getCurrentSceneView();
        if (sceneView == null) {
            Intrinsics.throwNpe();
        }
        SceneView view = sceneView;
        ViewEditorImpl editor = new ViewEditorImpl(view);
        for (NlComponent nlComponent : added) {
            if (insertType.isMove()) {
                InsertType insertType2 = realInsertType = nlComponent.getParent() == receiver ? InsertType.MOVE_WITHIN : InsertType.MOVE_INTO;
            }
            if (NlComponentHelperKt.needsDefaultId(nlComponent) && !realInsertType.isMove()) {
                String id = nlComponent.getId();
                CharSequence charSequence = id;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    ids.add(nlComponent.assignId(ids));
                } else {
                    String string = id;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id!!");
                    Object object = Regex.find$default((Regex)BASE_ID_PATTERN, (CharSequence)string, (int)0, (int)2, null);
                    if (object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null) {
                        CharSequence it = charSequence = object;
                        ids.add(nlComponent.assignId((String)it, ids));
                    }
                }
            }
            groupHandler.onChildInserted(editor, receiver, nlComponent, realInsertType);
        }
    }
}

