/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.editor.LayoutNavigationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackNavigationComponent
extends JPanel {
    public static final String BACK_NAVIGATION_COMPONENT_NAME = "BackNavigationComponent";
    private static final Color BACKGROUND = UIUtil.getPanelBackground();
    private static final Color HOVER_BACKGROUND = UIUtil.getPanelBackground().darker();
    private final DesignSurfaceListener mySurfaceListener;
    private final JLabel myBackLabel;
    @Nullable
    private DesignSurface myDesignSurface;
    private final BackNavigationListener myMouseAdapter;

    public BackNavigationComponent() {
        super(new FlowLayout(0));
        this.setName(BACK_NAVIGATION_COMPONENT_NAME);
        this.mySurfaceListener = this.createDesignSurfaceListener();
        this.myBackLabel = new JLabel(StudioIcons.Common.BACK_ARROW);
        this.myBackLabel.setIconTextGap(8);
        this.myMouseAdapter = new BackNavigationListener();
        this.addMouseListener(this.myMouseAdapter);
        this.addMouseMotionListener(this.myMouseAdapter);
        this.setVisible(false);
        this.add(this.myBackLabel);
        this.setBorder(IdeBorderFactory.createBorder((int)8));
        this.setBackground(BACKGROUND);
    }

    private void updateBackNavigation() {
        if (this.myDesignSurface == null) {
            return;
        }
        NlModel model = this.myDesignSurface.getModel();
        if (model != null) {
            VirtualFile modelFile;
            LayoutNavigationManager layoutNavigationManager = LayoutNavigationManager.getInstance(this.myDesignSurface.getProject());
            VirtualFile parentFile = layoutNavigationManager.get(modelFile = model.getFile().getVirtualFile());
            if (parentFile != null) {
                this.setVisible(true);
                this.myMouseAdapter.setNavigation(modelFile, parentFile, layoutNavigationManager);
                this.myBackLabel.setText(parentFile.getPresentableName());
            } else {
                this.setVisible(false);
            }
        }
    }

    @NotNull
    private DesignSurfaceListener createDesignSurfaceListener() {
        DesignSurfaceListener designSurfaceListener = new DesignSurfaceListener(){

            @Override
            public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
                if (surface == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newSelection == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void sceneChanged(@NotNull DesignSurface surface, @Nullable SceneView sceneView) {
                if (surface == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            @Override
            public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
                if (surface == null) {
                    1.$$$reportNull$$$0(3);
                }
                BackNavigationComponent.this.updateBackNavigation();
            }

            @Override
            public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
                if (surface == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (component2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "surface";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newSelection";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/structure/BackNavigationComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "componentSelectionChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sceneChanged";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelChanged";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "activatePreferredEditor";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (designSurfaceListener == null) {
            BackNavigationComponent.$$$reportNull$$$0(0);
        }
        return designSurfaceListener;
    }

    public void setDesignSurface(@Nullable DesignSurface designSurface) {
        if (this.myDesignSurface != null) {
            this.myDesignSurface.removeListener(this.mySurfaceListener);
        }
        this.myDesignSurface = designSurface;
        if (this.myDesignSurface != null) {
            this.myDesignSurface.addListener(this.mySurfaceListener);
            this.updateBackNavigation();
        }
    }

    @Nullable
    public DesignSurface getDesignSurface() {
        return this.myDesignSurface;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/BackNavigationComponent", "createDesignSurfaceListener"));
    }

    private class BackNavigationListener
    extends MouseAdapter {
        private VirtualFile myFrom;
        private VirtualFile myTo;
        private LayoutNavigationManager myManager;

        private BackNavigationListener() {
        }

        private void setNavigation(@NotNull VirtualFile from, @NotNull VirtualFile to, @NotNull LayoutNavigationManager layoutNavigationManager) {
            if (from == null) {
                BackNavigationListener.$$$reportNull$$$0(0);
            }
            if (to == null) {
                BackNavigationListener.$$$reportNull$$$0(1);
            }
            if (layoutNavigationManager == null) {
                BackNavigationListener.$$$reportNull$$$0(2);
            }
            this.myFrom = from;
            this.myTo = to;
            this.myManager = layoutNavigationManager;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.myManager.popFile(this.myFrom, this.myTo);
            BackNavigationComponent.this.setBackground(BACKGROUND);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BackNavigationComponent.this.setBackground(HOVER_BACKGROUND);
            BackNavigationComponent.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BackNavigationComponent.this.setBackground(BACKGROUND);
            BackNavigationComponent.this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "to";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "layoutNavigationManager";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/structure/BackNavigationComponent$BackNavigationListener";
            objectArray[2] = "setNavigation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

