/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.config.InstallerData;
import com.android.tools.idea.welcome.wizard.FirstRunWizardHost;
import com.google.common.util.concurrent.Atomics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JRootPane;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidStudioWelcomeScreenProvider
implements WelcomeScreenProvider {
    private static final String SYSTEM_PROPERTY_DISABLE_WIZARD = "disable.android.first.run";
    private static boolean ourWasShown;

    @Nullable
    public static FirstRunWizardMode getWizardMode() {
        AndroidFirstRunPersistentData persistentData = AndroidFirstRunPersistentData.getInstance();
        if (AndroidStudioWelcomeScreenProvider.isHandoff(persistentData)) {
            return FirstRunWizardMode.INSTALL_HANDOFF;
        }
        if (!persistentData.isSdkUpToDate()) {
            return FirstRunWizardMode.NEW_INSTALL;
        }
        if (IdeSdks.getInstance().getEligibleAndroidSdks().isEmpty()) {
            return FirstRunWizardMode.MISSING_SDK;
        }
        return null;
    }

    private static boolean isHandoff(AndroidFirstRunPersistentData persistentData) {
        if (!(!InstallerData.exists() || persistentData.isSdkUpToDate() && persistentData.isSameTimestamp(InstallerData.get().getTimestamp()))) {
            return InstallerData.get().isCurrentVersion();
        }
        return false;
    }

    @NotNull
    private static ConnectionState checkInternetConnection() {
        CommonProxy.isInstalledAssertion();
        ConnectionState result = null;
        while (result == null) {
            try {
                HttpURLConnection connection = HttpConfigurable.getInstance().openHttpConnection("http://developer.android.com");
                connection.connect();
                connection.disconnect();
                result = ConnectionState.OK;
            }
            catch (IOException | RuntimeException e) {
                result = AndroidStudioWelcomeScreenProvider.promptToRetryFailedConnection();
            }
            catch (Throwable e) {
                result = ConnectionState.NO_CONNECTION;
                String message = "Couldn't check internet connection";
                if (e.toString().contains("crypto")) {
                    message = message + "; check your JDK/JRE installation / consider running on a newer version.";
                }
                Logger.getInstance(AndroidStudioWelcomeScreenProvider.class).warn(message, e);
            }
        }
        ConnectionState connectionState = result;
        if (connectionState == null) {
            AndroidStudioWelcomeScreenProvider.$$$reportNull$$$0(0);
        }
        return connectionState;
    }

    @Nullable
    private static ConnectionState promptToRetryFailedConnection() {
        AtomicReference atomicBoolean = Atomics.newReference();
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> atomicBoolean.set(AndroidStudioWelcomeScreenProvider.promptUserForProxy()), application.getAnyModalityState());
        return (ConnectionState)((Object)atomicBoolean.get());
    }

    @Nullable
    private static ConnectionState promptUserForProxy() {
        int selection = Messages.showIdeaMessageDialog(null, (String)"Unable to access Android SDK add-on list", (String)"Android Studio First Run", (String[])new String[]{"Setup Proxy", "Cancel"}, (int)1, (Icon)Messages.getErrorIcon(), null);
        if (selection == 0) {
            HttpConfigurable.editConfigurable(null);
            return null;
        }
        return ConnectionState.NO_CONNECTION;
    }

    @NotNull
    public WelcomeScreen createWelcomeScreen(JRootPane rootPane) {
        AndroidStudioWelcomeScreenProvider.checkInternetConnection();
        FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
        assert (wizardMode != null);
        ourWasShown = true;
        FirstRunWizardHost firstRunWizardHost = new FirstRunWizardHost(wizardMode);
        if (firstRunWizardHost == null) {
            AndroidStudioWelcomeScreenProvider.$$$reportNull$$$0(1);
        }
        return firstRunWizardHost;
    }

    public boolean isAvailable() {
        boolean isWizardDisabled = AndroidPlugin.isGuiTestingMode() || Boolean.getBoolean(SYSTEM_PROPERTY_DISABLE_WIZARD);
        return !ourWasShown && !isWizardDisabled && AndroidStudioWelcomeScreenProvider.getWizardMode() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkInternetConnection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createWelcomeScreen";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static enum ConnectionState {
        OK,
        NO_CONNECTION;

    }
}

