/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidValueResourcesIndex
extends FileBasedIndexExtension<ResourceEntry, ImmutableSet<MyResourceInfo>> {
    public static final ID<ResourceEntry, ImmutableSet<MyResourceInfo>> INDEX_ID = ID.create((String)"android.value.resources.index");
    @NonNls
    private static final String RESOURCES_ROOT_TAG = "resources";
    @NonNls
    private static final String NAME_ATTRIBUTE_VALUE = "name";
    @NonNls
    private static final String TYPE_ATTRIBUTE_VALUE = "type";
    private final DataIndexer<ResourceEntry, ImmutableSet<MyResourceInfo>, FileContent> myIndexer = new DataIndexer<ResourceEntry, ImmutableSet<MyResourceInfo>, FileContent>(){

        @NotNull
        public Map<ResourceEntry, ImmutableSet<MyResourceInfo>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!AndroidValueResourcesIndex.isSimilarFile(inputData)) {
                Map<ResourceEntry, ImmutableSet<MyResourceInfo>> map = Collections.emptyMap();
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }
            PsiFile file = inputData.getPsiFile();
            if (!(file instanceof XmlFile)) {
                Map<ResourceEntry, ImmutableSet<MyResourceInfo>> map = Collections.emptyMap();
                if (map == null) {
                    1.$$$reportNull$$$0(2);
                }
                return map;
            }
            final HashMap resultBuilder = Maps.newHashMap();
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    ResourceType resType;
                    super.visitXmlTag(tag);
                    String resName = tag.getAttributeValue(AndroidValueResourcesIndex.NAME_ATTRIBUTE_VALUE);
                    if (resName == null) {
                        return;
                    }
                    String tagName = tag.getName();
                    String resTypeStr = "item".equals(tagName) ? tag.getAttributeValue(AndroidValueResourcesIndex.TYPE_ATTRIBUTE_VALUE) : AndroidCommonUtils.getResourceTypeByTagName((String)tagName);
                    ResourceType resourceType = resType = resTypeStr != null ? ResourceType.getEnum((String)resTypeStr) : null;
                    if (resType == null) {
                        return;
                    }
                    int offset = tag.getTextRange().getStartOffset();
                    if (resType == ResourceType.ATTR) {
                        XmlTag parentTag = tag.getParentTag();
                        String contextName = parentTag != null ? parentTag.getAttributeValue(AndroidValueResourcesIndex.NAME_ATTRIBUTE_VALUE) : null;
                        AndroidValueResourcesIndex.processResourceEntry(new ResourceEntry(resTypeStr, resName, contextName != null ? contextName : ""), resultBuilder, offset);
                    } else {
                        AndroidValueResourcesIndex.processResourceEntry(new ResourceEntry(resTypeStr, resName, ""), resultBuilder, offset);
                    }
                }
            });
            HashMap result = Maps.newHashMap();
            for (Map.Entry entry : resultBuilder.entrySet()) {
                result.put(entry.getKey(), ((ImmutableSet.Builder)entry.getValue()).build());
            }
            HashMap hashMap = result;
            if (hashMap == null) {
                1.$$$reportNull$$$0(3);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/AndroidValueResourcesIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/AndroidValueResourcesIndex$1";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final KeyDescriptor<ResourceEntry> myKeyDescriptor = new KeyDescriptor<ResourceEntry>(){

        public void save(@NotNull DataOutput out, ResourceEntry value) throws IOException {
            if (out == null) {
                3.$$$reportNull$$$0(0);
            }
            IOUtil.writeUTF((DataOutput)out, (String)value.getType());
            IOUtil.writeUTF((DataOutput)out, (String)value.getName());
            IOUtil.writeUTF((DataOutput)out, (String)value.getContext());
        }

        public ResourceEntry read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                3.$$$reportNull$$$0(1);
            }
            String resType = IOUtil.readUTF((DataInput)in);
            String resName = IOUtil.readUTF((DataInput)in);
            String resContext = IOUtil.readUTF((DataInput)in);
            return new ResourceEntry(resType, resName, resContext);
        }

        public int getHashCode(ResourceEntry value) {
            return value.hashCode();
        }

        public boolean isEqual(ResourceEntry val1, ResourceEntry val2) {
            return val1.equals((Object)val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/AndroidValueResourcesIndex$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DataExternalizer<ImmutableSet<MyResourceInfo>> myValueExternalizer = new DataExternalizer<ImmutableSet<MyResourceInfo>>(){

        public void save(@NotNull DataOutput out, ImmutableSet<MyResourceInfo> value) throws IOException {
            if (out == null) {
                4.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (MyResourceInfo entry : value) {
                IOUtil.writeUTF((DataOutput)out, (String)entry.getResourceEntry().getType());
                IOUtil.writeUTF((DataOutput)out, (String)entry.getResourceEntry().getName());
                IOUtil.writeUTF((DataOutput)out, (String)entry.getResourceEntry().getContext());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getOffset());
            }
        }

        @Nullable
        public ImmutableSet<MyResourceInfo> read(@NotNull DataInput in) throws IOException {
            int size;
            if (in == null) {
                4.$$$reportNull$$$0(1);
            }
            if ((size = DataInputOutputUtil.readINT((DataInput)in)) < 0 || size > 65535) {
                throw new IOException("Corrupt Index: Size " + size);
            }
            if (size == 0) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (int i = 0; i < size; ++i) {
                String type = IOUtil.readUTF((DataInput)in);
                String name = IOUtil.readUTF((DataInput)in);
                String context = IOUtil.readUTF((DataInput)in);
                int offset = DataInputOutputUtil.readINT((DataInput)in);
                result.add((Object)new MyResourceInfo(new ResourceEntry(type, name, context), offset));
            }
            return result.build();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/AndroidValueResourcesIndex$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private static boolean isSimilarFile(FileContent inputData) {
        if (CharArrayUtil.indexOf((CharSequence)inputData.getContentAsText(), (CharSequence)"<resources", (int)0) < 0) {
            return false;
        }
        final boolean[] ourRootTag = new boolean[]{false};
        NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                ourRootTag[0] = AndroidValueResourcesIndex.RESOURCES_ROOT_TAG.equals(name) && nsPrefix == null;
                2.stop();
            }
        });
        return ourRootTag[0];
    }

    private static void processResourceEntry(@NotNull ResourceEntry entry, @NotNull Map<ResourceEntry, ImmutableSet.Builder<MyResourceInfo>> resultBuilder, int offset) {
        if (entry == null) {
            AndroidValueResourcesIndex.$$$reportNull$$$0(0);
        }
        if (resultBuilder == null) {
            AndroidValueResourcesIndex.$$$reportNull$$$0(1);
        }
        MyResourceInfo info = new MyResourceInfo(entry, offset);
        resultBuilder.put(entry, (ImmutableSet.Builder<MyResourceInfo>)ImmutableSet.builder().add((Object)info));
        AndroidValueResourcesIndex.addEntryToMap(info, AndroidValueResourcesIndex.createTypeMarkerKey(entry.getType()), resultBuilder);
        AndroidValueResourcesIndex.addEntryToMap(info, AndroidValueResourcesIndex.createTypeNameMarkerKey(entry.getType(), entry.getName()), resultBuilder);
    }

    private static void addEntryToMap(MyResourceInfo info, ResourceEntry marker, Map<ResourceEntry, ImmutableSet.Builder<MyResourceInfo>> resultBuilder) {
        ImmutableSet.Builder setBuilder = resultBuilder.get(marker);
        if (setBuilder == null) {
            setBuilder = ImmutableSet.builder();
            resultBuilder.put(marker, (ImmutableSet.Builder<MyResourceInfo>)setBuilder);
        }
        setBuilder.add((Object)info);
    }

    @NotNull
    public static ResourceEntry createTypeMarkerKey(String type) {
        ResourceEntry resourceEntry = AndroidValueResourcesIndex.createTypeNameMarkerKey(type, "TYPE_MARKER_RESOURCE");
        if (resourceEntry == null) {
            AndroidValueResourcesIndex.$$$reportNull$$$0(2);
        }
        return resourceEntry;
    }

    @NotNull
    public static ResourceEntry createTypeNameMarkerKey(String type, String name) {
        ResourceEntry resourceEntry = new ResourceEntry(type, AndroidValueResourcesIndex.normalizeDelimiters(name), "TYPE_MARKER_CONTEXT");
        if (resourceEntry == null) {
            AndroidValueResourcesIndex.$$$reportNull$$$0(3);
        }
        return resourceEntry;
    }

    static String normalizeDelimiters(String s) {
        int length = s.length();
        int n = length;
        for (int j = 0; j < n; ++j) {
            char ch = s.charAt(j);
            if (Character.isLetterOrDigit(ch) || ch == '_') continue;
            StringBuilder result = new StringBuilder(length);
            for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    result.append(c);
                    continue;
                }
                result.append('_');
            }
            return result.toString();
        }
        return s;
    }

    @NotNull
    public ID<ResourceEntry, ImmutableSet<MyResourceInfo>> getName() {
        ID<ResourceEntry, ImmutableSet<MyResourceInfo>> iD = INDEX_ID;
        if (iD == null) {
            AndroidValueResourcesIndex.$$$reportNull$$$0(4);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<ResourceEntry, ImmutableSet<MyResourceInfo>, FileContent> getIndexer() {
        DataIndexer<ResourceEntry, ImmutableSet<MyResourceInfo>, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            AndroidValueResourcesIndex.$$$reportNull$$$0(5);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<ResourceEntry> getKeyDescriptor() {
        KeyDescriptor<ResourceEntry> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            AndroidValueResourcesIndex.$$$reportNull$$$0(6);
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<ImmutableSet<MyResourceInfo>> getValueExternalizer() {
        DataExternalizer<ImmutableSet<MyResourceInfo>> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            AndroidValueResourcesIndex.$$$reportNull$$$0(7);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    5.$$$reportNull$$$0(0);
                }
                return file.isInLocalFileSystem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/AndroidValueResourcesIndex$5", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            AndroidValueResourcesIndex.$$$reportNull$$$0(8);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 6;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/AndroidValueResourcesIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/AndroidValueResourcesIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeMarkerKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeNameMarkerKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processResourceEntry";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyResourceInfo {
        private final ResourceEntry myResourceEntry;
        private final int myOffset;

        private MyResourceInfo(@NotNull ResourceEntry resourceEntry, int offset) {
            if (resourceEntry == null) {
                MyResourceInfo.$$$reportNull$$$0(0);
            }
            this.myResourceEntry = resourceEntry;
            this.myOffset = offset;
        }

        @NotNull
        public ResourceEntry getResourceEntry() {
            ResourceEntry resourceEntry = this.myResourceEntry;
            if (resourceEntry == null) {
                MyResourceInfo.$$$reportNull$$$0(1);
            }
            return resourceEntry;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyResourceInfo info = (MyResourceInfo)o;
            if (this.myOffset != info.myOffset) {
                return false;
            }
            return this.myResourceEntry.equals((Object)info.myResourceEntry);
        }

        public int hashCode() {
            int result = this.myResourceEntry.hashCode();
            result = 31 * result + this.myOffset;
            return result;
        }

        public String toString() {
            return this.getClass().getDeclaringClass().getSimpleName() + '.' + this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + '(' + this.myResourceEntry + ',' + this.myOffset + ')';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/AndroidValueResourcesIndex$MyResourceInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/AndroidValueResourcesIndex$MyResourceInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

