/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.Client;
import com.android.tools.idea.ddms.actions.LayoutInspectorAction;
import com.android.tools.idea.fd.actions.RestartActivityAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidRunLayoutInspectorAction
extends AnAction {
    public AndroidRunLayoutInspectorAction() {
        super(AndroidBundle.message("android.ddms.actions.layoutinspector.title", new Object[0]), AndroidBundle.message("android.ddms.actions.layoutinspector.description", new Object[0]), AndroidIcons.Ddms.LayoutInspector);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        if (RestartActivityAction.isDebuggerPaused(e.getProject())) {
            e.getPresentation().setDescription(AndroidBundle.message("android.ddms.actions.layoutinspector.description.disabled", new Object[0]));
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setDescription(AndroidBundle.message("android.ddms.actions.layoutinspector.description", new Object[0]));
            e.getPresentation().setEnabled(true);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        if (!AndroidSdkUtils.activateDdmsIfNecessary(project)) {
            return;
        }
        AndroidProcessChooserDialog dialog = new AndroidProcessChooserDialog(project, false);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            Client client = dialog.getClient();
            if (client != null) {
                new LayoutInspectorAction.GetClientWindowsTask(project, client).queue();
            } else {
                Logger.getInstance(AndroidRunLayoutInspectorAction.class).warn("Not launching layout inspector - no client selected");
            }
        }
    }
}

