/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidXmlResourcesUtil {
    @NonNls
    public static final String SEARCHABLE_TAG_NAME = "searchable";
    @NonNls
    public static final String KEYBOARD_TAG_NAME = "Keyboard";
    @NonNls
    public static final String DEVICE_ADMIN_TAG_NAME = "device-admin";
    @NonNls
    public static final String ACCOUNT_AUTHENTICATOR_TAG_NAME = "account-authenticator";
    @NonNls
    public static final String PREFERENCE_HEADERS_TAG_NAME = "preference-headers";
    public static final ImmutableMap<String, String> SPECIAL_STYLEABLE_NAMES = ImmutableMap.builder().put((Object)"appwidget-provider", (Object)"AppWidgetProviderInfo").put((Object)"searchable", (Object)"Searchable").put((Object)"actionkey", (Object)"SearchableActionKey").put((Object)"intent", (Object)"Intent").put((Object)"Keyboard", (Object)"Keyboard").put((Object)"Row", (Object)"Keyboard_Row").put((Object)"Key", (Object)"Keyboard_Key").put((Object)"device-admin", (Object)"DeviceAdmin").put((Object)"account-authenticator", (Object)"AccountAuthenticator").put((Object)"header", (Object)"PreferenceHeader").build();
    private static final ImmutableSet<String> ROOT_TAGS = ImmutableSet.of((Object)"appwidget-provider", (Object)"searchable", (Object)"Keyboard", (Object)"device-admin", (Object)"account-authenticator", (Object)"preference-headers", (Object[])new String[]{"paths"});

    private AndroidXmlResourcesUtil() {
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidXmlResourcesUtil.$$$reportNull$$$0(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(AndroidDomUtil.removeUnambiguousNames(AttributeProcessingUtil.getPreferencesClassMap(facet)));
        result.addAll((Collection<String>)ROOT_TAGS);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            AndroidXmlResourcesUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static boolean isSupportedRootTag(@NotNull AndroidFacet facet, @NotNull String rootTagName) {
        if (facet == null) {
            AndroidXmlResourcesUtil.$$$reportNull$$$0(2);
        }
        if (rootTagName == null) {
            AndroidXmlResourcesUtil.$$$reportNull$$$0(3);
        }
        return ROOT_TAGS.contains((Object)rootTagName) || LayoutViewClassUtils.findClassByTagName(facet, rootTagName, "android.preference.Preference") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/xml/AndroidXmlResourcesUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/xml/AndroidXmlResourcesUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleRoots";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedRootTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

