/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.util;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.webflow.el.inject.ExpressionLanguageConfiguration;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowUtil {
    private static final Set<String> EXPRESSION_PREFIXES = new HashSet<String>();

    private WebflowUtil() {
    }

    public static boolean isDynamicExpression(@NotNull String value) {
        if (value == null) {
            WebflowUtil.$$$reportNull$$$0(0);
        }
        for (String prefix : EXPRESSION_PREFIXES) {
            if (!value.contains(prefix)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Flow> getAllFlows(@NotNull Module module, @NotNull List<PsiFile> exceptedFiles) {
        if (module == null) {
            WebflowUtil.$$$reportNull$$$0(1);
        }
        if (exceptedFiles == null) {
            WebflowUtil.$$$reportNull$$$0(2);
        }
        ArrayList<Flow> flows = new ArrayList<Flow>();
        for (WebflowModel model : WebflowDomModelManager.getInstance(module.getProject()).getAllModels(module)) {
            if (exceptedFiles.contains(model.getFlowFile())) continue;
            flows.add(model.getFlow());
        }
        ArrayList<Flow> arrayList = flows;
        if (arrayList == null) {
            WebflowUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public static XmlFile resolveFlow(@NotNull Flow flow) {
        WebflowModel model;
        if (flow == null) {
            WebflowUtil.$$$reportNull$$$0(4);
        }
        return (model = WebflowUtil.getModelByFlow(flow)) != null ? model.getFlowFile() : null;
    }

    @Nullable(value="if flow has no underlying model (not configured)")
    public static String getFlowName(@NotNull Flow flow) {
        WebflowModel model;
        if (flow == null) {
            WebflowUtil.$$$reportNull$$$0(5);
        }
        return (model = WebflowUtil.getModelByFlow(flow)) != null ? model.getName() : null;
    }

    @Nullable
    private static WebflowModel getModelByFlow(@NotNull Flow flow) {
        if (flow == null) {
            WebflowUtil.$$$reportNull$$$0(6);
        }
        return WebflowDomModelManager.getInstance(flow.getManager().getProject()).getWebflowModel(DomUtil.getFile((DomElement)flow));
    }

    public static boolean isNonSingletonPrototype(CommonSpringBean bean) {
        if (!(bean instanceof SpringBean)) {
            return false;
        }
        SpringBean springBean = (SpringBean)bean;
        Boolean isSingleton = (Boolean)springBean.getSingleton().getValue();
        if (Boolean.TRUE == isSingleton) {
            return false;
        }
        SpringBeanScope scope = (SpringBeanScope)springBean.getScope().getValue();
        return scope == SpringBeanScope.PROTOTYPE_SCOPE;
    }

    @Contract(value="null -> false")
    public static boolean isWebFlowAvailable(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.webflow.execution.Action") != null;
    }

    static {
        for (ExpressionLanguageConfiguration configuration : ExpressionLanguageConfiguration.values()) {
            EXPRESSION_PREFIXES.add(configuration.getDetectionPrefix());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptedFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/util/WebflowUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/util/WebflowUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFlows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicExpression";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllFlows";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveFlow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFlowName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModelByFlow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

