/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.batch.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.batch.SpringBatchBundle;
import com.intellij.spring.batch.model.xml.dom.Job;
import com.intellij.spring.batch.model.xml.dom.JobRepository;
import com.intellij.spring.batch.model.xml.dom.Step;
import com.intellij.spring.batch.model.xml.dom.flowgroup.FlowGroupStep;
import com.intellij.spring.batch.model.xml.dom.tasklet.Tasklet;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringDomInspectionUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.List;

class SpringBatchModelVisitor
implements DomElementVisitor {
    private final DomElementAnnotationHolder myHolder;
    private final SpringDomInspectionUtils mySpringDomInspectionUtils;

    SpringBatchModelVisitor(DomElementAnnotationHolder holder) {
        this.myHolder = holder;
        this.mySpringDomInspectionUtils = new SpringDomInspectionUtils(holder);
    }

    public void visitDomElement(DomElement element) {
    }

    private void visitSubElements(DomElement domElement) {
        List children = DomUtil.getDefinedChildren((DomElement)domElement, (boolean)true, (boolean)false);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            DomElement child = (DomElement)children.get(i);
            child.accept((DomElementVisitor)this);
        }
    }

    public void visitJob(Job job) {
        this.mySpringDomInspectionUtils.explicitBeanRequired((DomElement)job, job.getJobRepository(), "jobRepository");
        this.visitSubElements(job);
    }

    public void visitJobRepository(JobRepository jobRepository) {
        this.mySpringDomInspectionUtils.explicitBeanRequired((DomElement)jobRepository, jobRepository.getTransactionManager(), "transactionManager");
        this.mySpringDomInspectionUtils.explicitBeanRequired((DomElement)jobRepository, jobRepository.getDataSource(), "dataSource");
    }

    public void visitStep(Step step) {
        this.visitSubElements(step);
    }

    public void visitFlowGroupStep(FlowGroupStep flowGroupStep) {
        if (!flowGroupStep.getNexts().isEmpty()) {
            this.mySpringDomInspectionUtils.oneOfRequired((DomElement)flowGroupStep, new DomElement[]{flowGroupStep.getNext(), (DomElement)flowGroupStep.getNexts().get(0)});
        }
    }

    public void visitTasklet(Tasklet tasklet) {
        this.mySpringDomInspectionUtils.explicitBeanRequired((DomElement)tasklet, tasklet.getTransactionManager(), "transactionManager");
        SpringBeanPointer springBean = null;
        if (DomUtil.hasXml((DomElement)tasklet.getRef())) {
            springBean = (SpringBeanPointer)tasklet.getRef().getBean().getValue();
        } else if (DomUtil.hasXml(tasklet.getRefAttribute())) {
            springBean = (SpringBeanPointer)tasklet.getRefAttribute().getValue();
        }
        if (springBean == null) {
            return;
        }
        PsiClass beanClass = springBean.getBeanClass();
        if (!InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"org.springframework.batch.core.step.tasklet.Tasklet") && !SpringDomInspectionUtils.hasAny((DomElement[])new DomElement[]{tasklet.getMethod()})) {
            this.myHolder.createProblem((DomElement)tasklet, SpringBatchBundle.message("SpringBatchModelInspection.tasklet.method.required.for.pojo", new Object[0]), new LocalQuickFix[0]);
        }
    }
}

