/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.batch.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.PairProcessor;

public class EnableSpringBatchModelsProvider
extends LocalAnnotationModelDependentModelsProvider {
    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<LocalModel, LocalModelDependency> processor) {
        Module module = localAnnotationModel.getModule();
        if (module == null) {
            return true;
        }
        if (!"org.springframework.batch.core.configuration.annotation.EnableBatchProcessing".equals(((PsiClass)localAnnotationModel.getConfig()).getQualifiedName())) {
            return true;
        }
        PsiClass batchSimpleConfiguration = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.batch.core.configuration.annotation.SimpleBatchConfiguration");
        if (batchSimpleConfiguration == null) {
            return true;
        }
        LocalAnnotationModel model = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(batchSimpleConfiguration, module, localAnnotationModel.getActiveProfiles());
        return processor.process((Object)model, (Object)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)batchSimpleConfiguration));
    }
}

