/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.NewHierarchy;
import org.fest.swing.hierarchy.SingleComponentHierarchy;
import org.fest.util.Preconditions;

public final class BasicComponentPrinter
implements ComponentPrinter {
    private static final String INDENTATION = "  ";
    private static final ComponentMatcher ALWAYS_MATCHES = BasicComponentPrinter.alwaysMatches();
    private final ComponentHierarchy hierarchy;

    @Nonnull
    private static ComponentMatcher alwaysMatches() {
        return new ComponentMatcher(){

            @Override
            public boolean matches(@Nullable Component c) {
                return true;
            }
        };
    }

    @Nonnull
    public static ComponentPrinter printerWithNewAwtHierarchy() {
        return new BasicComponentPrinter(NewHierarchy.ignoreExistingComponents());
    }

    @Nonnull
    public static ComponentPrinter printerWithCurrentAwtHierarchy() {
        return new BasicComponentPrinter(new ExistingHierarchy());
    }

    protected BasicComponentPrinter(@Nonnull ComponentHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    @Nonnull
    protected final ComponentHierarchy hierarchy() {
        return this.hierarchy;
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out) {
        this.printComponents(out, ALWAYS_MATCHES);
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out, @Nullable Container root) {
        this.printComponents(out, ALWAYS_MATCHES, root);
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out, @Nonnull Class<? extends Component> type) {
        this.printComponents(out, type, null);
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out, @Nonnull Class<? extends Component> type, @Nullable Container root) {
        BasicComponentPrinter.print(this.hierarchy(root), new TypeMatcher((Class)Preconditions.checkNotNull(type)), (PrintStream)Preconditions.checkNotNull((Object)out));
    }

    @Override
    public void printComponents(@Nonnull PrintStream out, @Nonnull ComponentMatcher matcher) {
        this.printComponents(out, matcher, null);
    }

    @Override
    public void printComponents(@Nonnull PrintStream out, @Nonnull ComponentMatcher matcher, @Nullable Container root) {
        BasicComponentPrinter.print(this.hierarchy(root), (ComponentMatcher)Preconditions.checkNotNull((Object)matcher), (PrintStream)Preconditions.checkNotNull((Object)out));
    }

    @Nonnull
    private ComponentHierarchy hierarchy(@Nullable Container root) {
        return root != null ? new SingleComponentHierarchy(root, this.hierarchy) : this.hierarchy;
    }

    @RunsInEDT
    private static void print(final @Nonnull ComponentHierarchy hierarchy, final @Nonnull ComponentMatcher matcher, final @Nonnull PrintStream out) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                for (Component component : hierarchy.roots()) {
                    BasicComponentPrinter.print((Component)Preconditions.checkNotNull((Object)component), hierarchy, matcher, 0, out);
                }
            }
        });
    }

    @RunsInCurrentThread
    private static void print(@Nonnull Component c, @Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher matcher, int level, @Nonnull PrintStream out) {
        if (matcher.matches(c)) {
            BasicComponentPrinter.print(c, level, out);
        }
        for (Component child : h.childrenOf(c)) {
            BasicComponentPrinter.print((Component)Preconditions.checkNotNull((Object)child), h, matcher, level + 1, out);
        }
    }

    @RunsInCurrentThread
    private static void print(@Nonnull Component c, int level, @Nonnull PrintStream out) {
        for (int i = 0; i < level; ++i) {
            out.print(INDENTATION);
        }
        out.println(Formatting.format(c));
    }
}

