/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.listener.WeakEventListener;
import org.fest.swing.monitor.Windows;

final class WindowAvailabilityMonitor
implements AWTEventListener {
    private static final long EVENT_MASK = 8240L;
    private final Windows windows;

    WindowAvailabilityMonitor(@Nonnull Windows windows) {
        this.windows = windows;
    }

    void attachTo(@Nonnull Toolkit toolkit) {
        WeakEventListener.attachAsWeakEventListener(toolkit, this, 8240L);
    }

    @Override
    @RunsInEDT
    public void eventDispatched(AWTEvent e) {
        Window w;
        if (!(e instanceof MouseEvent)) {
            return;
        }
        Object source = e.getSource();
        if (!(source instanceof Component)) {
            return;
        }
        Component c = (Component)source;
        Window window = w = c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
        if (w != null) {
            this.windows.markAsReady(w);
        }
    }
}

