/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;

final class WindowMetrics {
    @Nonnull
    @RunsInCurrentThread
    static Point absoluteCenterOf(@Nonnull Window window) {
        Insets insets = window.getInsets();
        int w = window.getWidth() - (insets.left + insets.right);
        int h = window.getHeight() - (insets.top + insets.bottom);
        int x = window.getX() + insets.left;
        int y = window.getY() + insets.top;
        return new Point(x + w / 2, y + h / 2);
    }

    private WindowMetrics() {
    }
}

