/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;

public class DefaultModuleVersionSelector
implements ModuleVersionSelector {
    private String group;
    private String name;
    private VersionConstraint moduleVersionConstraint;

    private DefaultModuleVersionSelector(String group, String name, VersionConstraint versionConstraint) {
        this.group = group;
        this.name = name;
        this.moduleVersionConstraint = versionConstraint;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public DefaultModuleVersionSelector setGroup(String group) {
        this.group = group;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DefaultModuleVersionSelector setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getVersion() {
        return this.moduleVersionConstraint.getPreferredVersion();
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.moduleVersionConstraint;
    }

    @Override
    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec(this).isSatisfiedBy(identifier);
    }

    public String toString() {
        return String.format("%s:%s:%s", this.group, this.name, this.moduleVersionConstraint.getPreferredVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultModuleVersionSelector)) {
            return false;
        }
        DefaultModuleVersionSelector that = (DefaultModuleVersionSelector)o;
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.moduleVersionConstraint != null ? !this.moduleVersionConstraint.equals(that.moduleVersionConstraint) : that.moduleVersionConstraint != null);
    }

    public int hashCode() {
        int result = this.group != null ? this.group.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.moduleVersionConstraint.hashCode();
        return result;
    }

    public static ModuleVersionSelector newSelector(String group, String name, String preferredVersion) {
        return new DefaultModuleVersionSelector(group, name, new DefaultMutableVersionConstraint(preferredVersion));
    }

    public static ModuleVersionSelector newSelector(String group, String name, VersionConstraint version) {
        return new DefaultModuleVersionSelector(group, name, version);
    }

    public static ModuleVersionSelector newSelector(ModuleComponentSelector selector) {
        return new DefaultModuleVersionSelector(selector.getGroup(), selector.getModule(), selector.getVersionConstraint());
    }
}

