/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.AbstractVersionConstraint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class DefaultImmutableVersionConstraint
extends AbstractVersionConstraint
implements ImmutableVersionConstraint {
    private final String preferredVersion;
    private final ImmutableList<String> rejectedVersions;

    public DefaultImmutableVersionConstraint(String preferredVersion, List<String> rejectedVersions) {
        if (preferredVersion == null) {
            throw new IllegalArgumentException("Preferred version must not be null");
        }
        if (rejectedVersions == null) {
            throw new IllegalArgumentException("Rejected versions must not be null");
        }
        this.preferredVersion = preferredVersion;
        this.rejectedVersions = ImmutableList.copyOf(rejectedVersions);
    }

    public DefaultImmutableVersionConstraint(String preferredVersion) {
        if (preferredVersion == null) {
            throw new IllegalArgumentException("Preferred version must not be null");
        }
        this.preferredVersion = preferredVersion;
        this.rejectedVersions = ImmutableList.of();
    }

    @Override
    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    @Override
    public List<String> getRejectedVersions() {
        return this.rejectedVersions;
    }

    public static ImmutableVersionConstraint of(VersionConstraint versionConstraint) {
        if (versionConstraint instanceof ImmutableVersionConstraint) {
            return (ImmutableVersionConstraint)versionConstraint;
        }
        return new DefaultImmutableVersionConstraint(versionConstraint.getPreferredVersion(), versionConstraint.getRejectedVersions());
    }

    public static ImmutableVersionConstraint of(String preferredVersion) {
        return new DefaultImmutableVersionConstraint(preferredVersion);
    }

    public static ImmutableVersionConstraint of(String preferredVersion, List<String> rejects) {
        return new DefaultImmutableVersionConstraint(preferredVersion, rejects);
    }
}

