/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetaDataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.util.BuildCommencedTimeProvider;

class DefaultCachedMetaData
implements ModuleMetaDataCache.CachedMetaData {
    private final ModuleSource moduleSource;
    private final long ageMillis;
    private final ModuleComponentResolveMetadata metaData;

    public DefaultCachedMetaData(ModuleMetadataCacheEntry entry, ModuleComponentResolveMetadata metaData, BuildCommencedTimeProvider timeProvider) {
        this.moduleSource = entry.moduleSource;
        this.ageMillis = timeProvider.getCurrentTime() - entry.createTimestamp;
        this.metaData = metaData;
    }

    @Override
    public boolean isMissing() {
        return this.metaData == null;
    }

    @Override
    public ModuleSource getModuleSource() {
        return this.moduleSource;
    }

    @Override
    public ResolvedModuleVersion getModuleVersion() {
        return this.isMissing() ? null : new DefaultResolvedModuleVersion(this.getMetaData().getId());
    }

    @Override
    public ModuleComponentResolveMetadata getMetaData() {
        return this.metaData;
    }

    @Override
    public long getAgeMillis() {
        return this.ageMillis;
    }
}

