/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileTimeStampInspector;
import org.gradle.api.internal.changedetection.state.TaskHistoryStore;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;

public class CachingFileHasher
implements FileHasher {
    private final PersistentIndexedCache<String, FileInfo> cache;
    private final FileHasher delegate;
    private final FileSystem fileSystem;
    private final StringInterner stringInterner;
    private final FileTimeStampInspector timestampInspector;

    public CachingFileHasher(FileHasher delegate, TaskHistoryStore store, StringInterner stringInterner, FileTimeStampInspector timestampInspector, String cacheName, FileSystem fileSystem) {
        this.delegate = delegate;
        this.fileSystem = fileSystem;
        this.cache = store.createCache(cacheName, String.class, new FileInfoSerializer(), 400000, true);
        this.stringInterner = stringInterner;
        this.timestampInspector = timestampInspector;
    }

    public String toString() {
        return "{hasher cache: " + this.cache + "}";
    }

    public HashCode hash(File file) {
        return this.snapshot(file).getHash();
    }

    public HashCode hash(FileTreeElement fileDetails) {
        return this.snapshot(fileDetails).getHash();
    }

    public HashCode hash(File file, FileMetadataSnapshot fileDetails) {
        return this.snapshot(file, fileDetails.getLength(), fileDetails.getLastModified()).getHash();
    }

    private FileInfo snapshot(File file) {
        FileMetadataSnapshot fileMetadata = this.fileSystem.stat(file);
        return this.snapshot(file, fileMetadata.getLength(), fileMetadata.getLastModified());
    }

    private FileInfo snapshot(FileTreeElement file) {
        return this.snapshot(file.getFile(), file.getSize(), file.getLastModified());
    }

    private FileInfo snapshot(File file, long length, long timestamp) {
        FileInfo info;
        String absolutePath = file.getAbsolutePath();
        if (this.timestampInspector.timestampCanBeUsedToDetectFileChange(absolutePath, timestamp) && (info = this.cache.get(absolutePath)) != null && length == info.length && timestamp == info.timestamp) {
            return info;
        }
        HashCode hash = this.delegate.hash(file);
        FileInfo info2 = new FileInfo(hash, length, timestamp);
        this.cache.put(this.stringInterner.intern(absolutePath), info2);
        return info2;
    }

    public void discard(String path) {
        this.cache.remove(path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileInfoSerializer
    extends AbstractSerializer<FileInfo> {
        private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();

        private FileInfoSerializer() {
        }

        @Override
        public FileInfo read(Decoder decoder) throws Exception {
            HashCode hash = this.hashCodeSerializer.read(decoder);
            long timestamp = decoder.readLong();
            long length = decoder.readLong();
            return new FileInfo(hash, length, timestamp);
        }

        @Override
        public void write(Encoder encoder, FileInfo value) throws Exception {
            this.hashCodeSerializer.write(encoder, value.hash);
            encoder.writeLong(value.timestamp);
            encoder.writeLong(value.length);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            FileInfoSerializer rhs = (FileInfoSerializer)obj;
            return Objects.equal((Object)this.hashCodeSerializer, (Object)rhs.hashCodeSerializer);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.hashCodeSerializer});
        }
    }

    @VisibleForTesting
    static class FileInfo {
        private final HashCode hash;
        private final long timestamp;
        private final long length;

        public FileInfo(HashCode hash, long length, long timestamp) {
            this.hash = hash;
            this.length = length;
            this.timestamp = timestamp;
        }

        public HashCode getHash() {
            return this.hash;
        }
    }
}

