/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Transformer;
import org.gradle.api.internal.changedetection.state.InMemoryDecoratedCache;
import org.gradle.api.internal.changedetection.state.LoggingEvictionListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.AsyncCacheAccess;
import org.gradle.cache.CacheDecorator;
import org.gradle.cache.CrossProcessCacheAccess;
import org.gradle.cache.FileLock;
import org.gradle.cache.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.AsyncCacheAccessDecoratedCache;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.cache.internal.CrossProcessSynchronizingCache;
import org.gradle.cache.internal.HeapProportionalCacheSizer;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.RemovalListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryCacheDecoratorFactory {
    private static final Logger LOG = Logging.getLogger(InMemoryCacheDecoratorFactory.class);
    private final boolean longLivingProcess;
    private final HeapProportionalCacheSizer cacheSizer = new HeapProportionalCacheSizer();
    private final CrossBuildInMemoryCache<String, CacheDetails> caches;

    public InMemoryCacheDecoratorFactory(boolean longLivingProcess, CrossBuildInMemoryCacheFactory cacheFactory) {
        this.longLivingProcess = longLivingProcess;
        this.caches = cacheFactory.newCache();
    }

    public CacheDecorator decorator(int maxEntriesToKeepInMemory, boolean cacheInMemoryForShortLivedProcesses) {
        return new InMemoryCacheDecorator(maxEntriesToKeepInMemory, cacheInMemoryForShortLivedProcesses);
    }

    private <K, V> MultiProcessSafeAsyncPersistentIndexedCache<K, V> applyInMemoryCaching(String cacheId, MultiProcessSafeAsyncPersistentIndexedCache<K, V> backingCache, int maxEntriesToKeepInMemory, boolean cacheInMemoryForShortLivedProcesses) {
        if (!this.longLivingProcess && !cacheInMemoryForShortLivedProcesses) {
            LOG.debug("Creating cache {} without in-memory store.", cacheId);
            return backingCache;
        }
        int targetSize = this.cacheSizer.scaleCacheSize(maxEntriesToKeepInMemory);
        CacheDetails cacheDetails = this.getCache(cacheId, targetSize);
        return new InMemoryDecoratedCache<K, V>(backingCache, (Cache<Object, Object>)cacheDetails.entries, cacheId, cacheDetails.lockState);
    }

    private CacheDetails getCache(String cacheId, final int maxSize) {
        CacheDetails cacheDetails = this.caches.get(cacheId, new Transformer<CacheDetails, String>(){

            @Override
            public CacheDetails transform(String cacheId) {
                Cache entries = InMemoryCacheDecoratorFactory.this.createInMemoryCache(cacheId, maxSize);
                CacheDetails cacheDetails = new CacheDetails(cacheId, maxSize, (Cache<Object, Object>)entries, new AtomicReference<Object>(null));
                LOG.debug("Creating in-memory store for cache {} (max size: {})", cacheId, maxSize);
                return cacheDetails;
            }
        });
        if (cacheDetails.maxEntries != maxSize) {
            throw new IllegalStateException("Mismatched in-memory store size for cache " + cacheId + ", expected: " + maxSize + ", found: " + cacheDetails.maxEntries);
        }
        return cacheDetails;
    }

    private Cache<Object, Object> createInMemoryCache(String cacheId, int maxSize) {
        LoggingEvictionListener evictionListener = new LoggingEvictionListener(cacheId, maxSize);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)maxSize).recordStats().removalListener((RemovalListener)evictionListener);
        Cache inMemoryCache = cacheBuilder.build();
        evictionListener.setCache((Cache<Object, Object>)inMemoryCache);
        return inMemoryCache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheDetails {
        private final String cacheId;
        private final int maxEntries;
        private final Cache<Object, Object> entries;
        private final AtomicReference<FileLock.State> lockState;

        CacheDetails(String cacheId, int maxEntries, Cache<Object, Object> entries, AtomicReference<FileLock.State> lockState) {
            this.cacheId = cacheId;
            this.maxEntries = maxEntries;
            this.entries = entries;
            this.lockState = lockState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InMemoryCacheDecorator
    implements CacheDecorator {
        private final int maxEntriesToKeepInMemory;
        private final boolean cacheInMemoryForShortLivedProcesses;

        InMemoryCacheDecorator(int maxEntriesToKeepInMemory, boolean cacheInMemoryForShortLivedProcesses) {
            this.maxEntriesToKeepInMemory = maxEntriesToKeepInMemory;
            this.cacheInMemoryForShortLivedProcesses = cacheInMemoryForShortLivedProcesses;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            InMemoryCacheDecorator other = (InMemoryCacheDecorator)obj;
            return this.maxEntriesToKeepInMemory == other.maxEntriesToKeepInMemory && this.cacheInMemoryForShortLivedProcesses == other.cacheInMemoryForShortLivedProcesses;
        }

        public int hashCode() {
            return this.maxEntriesToKeepInMemory ^ (this.cacheInMemoryForShortLivedProcesses ? 1 : 0);
        }

        @Override
        public <K, V> MultiProcessSafePersistentIndexedCache<K, V> decorate(String cacheId, String cacheName, MultiProcessSafePersistentIndexedCache<K, V> persistentCache, CrossProcessCacheAccess crossProcessCacheAccess, AsyncCacheAccess asyncCacheAccess) {
            AsyncCacheAccessDecoratedCache<K, V> asyncCache = new AsyncCacheAccessDecoratedCache<K, V>(asyncCacheAccess, persistentCache);
            MultiProcessSafeAsyncPersistentIndexedCache memCache = InMemoryCacheDecoratorFactory.this.applyInMemoryCaching(cacheId, asyncCache, this.maxEntriesToKeepInMemory, this.cacheInMemoryForShortLivedProcesses);
            return new CrossProcessSynchronizingCache(memCache, crossProcessCacheAccess);
        }
    }
}

