/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.copy.FileCopier;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurableFileTree
extends CompositeFileTree
implements ConfigurableFileTree {
    private Object dir;
    private final PatternSet patternSet;
    private final PathToFileResolver resolver;
    private final FileCopier fileCopier;
    private final DefaultTaskDependency buildDependency;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;

    public DefaultConfigurableFileTree(Object dir, FileResolver resolver, TaskResolver taskResolver, FileCopier fileCopier, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this(Collections.singletonMap("dir", dir), resolver, taskResolver, fileCopier, directoryFileTreeFactory);
    }

    public DefaultConfigurableFileTree(Map<String, ?> args, FileResolver resolver, TaskResolver taskResolver, FileCopier fileCopier, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.resolver = resolver;
        this.fileCopier = fileCopier;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patternSet = resolver.getPatternSetFactory().create();
        this.buildDependency = new DefaultTaskDependency(taskResolver);
        ConfigureUtil.configureByMap(args, this);
    }

    @Override
    public PatternSet getPatterns() {
        return this.patternSet;
    }

    @Override
    public DefaultConfigurableFileTree setDir(Object dir) {
        this.from(dir);
        return this;
    }

    @Override
    public File getDir() {
        if (this.dir == null) {
            throw new InvalidUserDataException("A base directory must be specified in the task or via a method argument!");
        }
        return this.resolver.resolve(this.dir);
    }

    @Override
    public DefaultConfigurableFileTree from(Object dir) {
        this.dir = dir;
        return this;
    }

    @Override
    public String getDisplayName() {
        return "directory '" + this.dir + "'";
    }

    public WorkResult copy(final Closure closure) {
        return this.fileCopier.copy((Action<? super CopySpec>)new Action<CopySpec>(){

            @Override
            public void execute(CopySpec copySpec) {
                copySpec.from(DefaultConfigurableFileTree.this);
                ConfigureUtil.configure(closure, copySpec);
            }
        });
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public DefaultConfigurableFileTree setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public DefaultConfigurableFileTree setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Iterable<String> includes) {
        this.patternSet.include((Iterable)includes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include((Spec)includeSpec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Iterable<String> excludes) {
        this.patternSet.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        File dir = this.getDir();
        context.add(this.directoryFileTreeFactory.create(dir, this.patternSet));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add(this.buildDependency);
    }

    @Override
    public ConfigurableFileTree builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    @Override
    public Set<Object> getBuiltBy() {
        return this.buildDependency.getValues();
    }

    @Override
    public ConfigurableFileTree setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }
}

