/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.List;
import java.util.Set;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.TaskClassValidationMessage;
import org.gradle.api.internal.project.taskfactory.TaskPropertyInfo;
import org.gradle.api.internal.tasks.TaskPropertyValue;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class TaskClassValidator {
    private final ImmutableSortedSet<TaskPropertyInfo> annotatedProperties;
    private final ImmutableList<TaskClassValidationMessage> validationMessages;
    private final boolean cacheable;

    public TaskClassValidator(Set<TaskPropertyInfo> annotatedProperties, List<TaskClassValidationMessage> validationMessages, boolean cacheable) {
        this.annotatedProperties = ImmutableSortedSet.copyOf(annotatedProperties);
        this.validationMessages = ImmutableList.copyOf(validationMessages);
        this.cacheable = cacheable;
    }

    public void addInputsAndOutputs(TaskInternal task) {
        for (TaskPropertyInfo property : this.annotatedProperties) {
            property.getConfigureAction().update(task, new TaskPropertyValue(property, task));
        }
    }

    public boolean hasAnythingToValidate() {
        return !this.annotatedProperties.isEmpty();
    }

    public ImmutableSortedSet<TaskPropertyInfo> getAnnotatedProperties() {
        return this.annotatedProperties;
    }

    public ImmutableList<TaskClassValidationMessage> getValidationMessages() {
        return this.validationMessages;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }
}

