/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.CollectionUtils;

public class NormalizingJavaCompiler
implements Compiler<JavaCompileSpec> {
    private static final Logger LOGGER = Logging.getLogger(NormalizingJavaCompiler.class);
    private final Compiler<JavaCompileSpec> delegate;

    public NormalizingJavaCompiler(Compiler<JavaCompileSpec> delegate) {
        this.delegate = delegate;
    }

    @Override
    public WorkResult execute(JavaCompileSpec spec) {
        this.resolveAndFilterSourceFiles(spec);
        this.resolveNonStringsInCompilerArgs(spec);
        this.logSourceFiles(spec);
        this.logCompilerArguments(spec);
        return this.delegateAndHandleErrors(spec);
    }

    private void resolveAndFilterSourceFiles(JavaCompileSpec spec) {
        FileCollection javaOnly = spec.getSource().filter((Spec<? super File>)new Spec<File>(){

            @Override
            public boolean isSatisfiedBy(File element) {
                return FileUtils.hasExtension(element, ".java");
            }
        });
        spec.setSource(new SimpleFileCollection(javaOnly.getFiles()));
    }

    private void resolveNonStringsInCompilerArgs(JavaCompileSpec spec) {
        spec.getCompileOptions().setCompilerArgs(CollectionUtils.toStringList(spec.getCompileOptions().getCompilerArgs()));
    }

    private void logSourceFiles(JavaCompileSpec spec) {
        if (!spec.getCompileOptions().isListFiles()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Source files to be compiled:");
        for (File file : spec.getSource()) {
            builder.append('\n');
            builder.append(file);
        }
        LOGGER.quiet(builder.toString());
    }

    private void logCompilerArguments(JavaCompileSpec spec) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        List<String> compilerArgs = new JavaCompilerArgumentsBuilder(spec).includeLauncherOptions(true).includeSourceFiles(true).build();
        String joinedArgs = Joiner.on((char)' ').join(compilerArgs);
        LOGGER.debug("Compiler arguments: {}", joinedArgs);
    }

    private WorkResult delegateAndHandleErrors(JavaCompileSpec spec) {
        try {
            return this.delegate.execute(spec);
        }
        catch (CompilationFailedException e) {
            if (spec.getCompileOptions().isFailOnError()) {
                throw e;
            }
            LOGGER.debug("Ignoring compilation failure.");
            return WorkResults.didWork(false);
        }
    }
}

