/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

class DefaultJarSnapshotter {
    private final StreamHasher hasher;
    private final ClassDependenciesAnalyzer analyzer;

    public DefaultJarSnapshotter(StreamHasher hasher, ClassDependenciesAnalyzer analyzer) {
        this.hasher = hasher;
        this.analyzer = analyzer;
    }

    public JarSnapshot createSnapshot(HashCode hash, JarArchive jarArchive) {
        final HashMap hashes = Maps.newHashMap();
        final ClassDependentsAccumulator accumulator = new ClassDependentsAccumulator();
        jarArchive.contents.visit(new FileVisitor(){

            @Override
            public void visitDir(FileVisitDetails dirDetails) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                HashCode classFileHash;
                if (!fileDetails.getName().endsWith(".class")) {
                    return;
                }
                InputStream inputStream = fileDetails.open();
                try {
                    classFileHash = DefaultJarSnapshotter.this.hasher.hash(inputStream);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                ClassAnalysis analysis = DefaultJarSnapshotter.this.analyzer.getClassAnalysis(classFileHash, fileDetails);
                accumulator.addClass(analysis);
                hashes.put(analysis.getClassName(), classFileHash);
            }
        });
        return new JarSnapshot(new JarSnapshotData(hash, hashes, accumulator.getAnalysis()));
    }
}

