/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.util.HashSet;
import java.util.LinkedHashMap;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotter;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class JarClasspathSnapshotFactory {
    private final JarSnapshotter jarSnapshotter;

    public JarClasspathSnapshotFactory(JarSnapshotter jarSnapshotter) {
        this.jarSnapshotter = jarSnapshotter;
    }

    JarClasspathSnapshot createSnapshot(Iterable<JarArchive> jarArchives) {
        LinkedHashMap jarSnapshots = Maps.newLinkedHashMap();
        LinkedHashMap jarHashes = Maps.newLinkedHashMap();
        HashSet allClasses = Sets.newHashSet();
        HashSet duplicateClasses = Sets.newHashSet();
        for (JarArchive jar : jarArchives) {
            if (!jar.file.exists()) continue;
            JarSnapshot snapshot = this.jarSnapshotter.createSnapshot(jar);
            jarSnapshots.put(jar.file, snapshot);
            jarHashes.put(jar.file, snapshot.getHash());
            for (String c : snapshot.getClasses()) {
                if (allClasses.add(c)) continue;
                duplicateClasses.add(c);
            }
        }
        JarClasspathSnapshotData jarClasspathSnapshotData = new JarClasspathSnapshotData(jarHashes, duplicateClasses);
        return new JarClasspathSnapshot(jarSnapshots, jarClasspathSnapshotData);
    }
}

