/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.impldep.org.junit.experimental.categories.Category;
import org.gradle.internal.impldep.org.junit.runner.Description;
import org.gradle.internal.impldep.org.junit.runner.manipulation.Filter;

class CategoryFilter
extends Filter {
    private final Set<Class<?>> inclusions;
    private final Set<Class<?>> exclusions;

    public CategoryFilter(Set<Class<?>> inclusions, Set<Class<?>> exclusions) {
        this.inclusions = inclusions;
        this.exclusions = exclusions;
    }

    public boolean shouldRun(Description description) {
        Class testClass = description.getTestClass();
        Description desc = description.isSuite() || testClass == null ? null : Description.createSuiteDescription((Class)testClass);
        return this.shouldRun(description, desc);
    }

    private boolean shouldRun(Description description, Description parent) {
        HashSet<Class> categories = new HashSet<Class>();
        Category annotation = (Category)description.getAnnotation(Category.class);
        if (annotation != null) {
            categories.addAll(Arrays.asList(annotation.value()));
        }
        if (parent != null && (annotation = (Category)parent.getAnnotation(Category.class)) != null) {
            categories.addAll(Arrays.asList(annotation.value()));
        }
        boolean result = this.inclusions.isEmpty();
        for (Class category : categories) {
            if (!this.matches(category, this.inclusions)) continue;
            result = true;
            break;
        }
        if (result) {
            for (Class category : categories) {
                if (!this.matches(category, this.exclusions)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean matches(Class<?> category, Set<Class<?>> categories) {
        for (Class<?> cls : categories) {
            if (!cls.isAssignableFrom(category)) continue;
            return true;
        }
        return false;
    }

    public final String describe() {
        StringBuilder sb = new StringBuilder();
        if (!this.inclusions.isEmpty()) {
            sb.append("(");
            sb.append(StringUtils.join(this.inclusions, (String)" OR "));
            sb.append(")");
            if (!this.exclusions.isEmpty()) {
                sb.append(" AND ");
            }
        }
        if (!this.exclusions.isEmpty()) {
            sb.append("NOT (");
            sb.append(StringUtils.join(this.exclusions, (String)" OR "));
            sb.append(")");
        }
        return sb.toString();
    }
}

