/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.DefaultProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.plugins.BuildConfigurationRule;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.plugins.UploadRule;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

public class BasePlugin
implements Plugin<Project> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String BUILD_GROUP = "build";
    public static final String UPLOAD_ARCHIVES_TASK_NAME = "uploadArchives";
    public static final String UPLOAD_GROUP = "upload";
    private final ProjectPublicationRegistry publicationRegistry;
    private final ProjectConfigurationActionContainer configurationActionContainer;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    @Inject
    public BasePlugin(ProjectPublicationRegistry publicationRegistry, ProjectConfigurationActionContainer configurationActionContainer, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.publicationRegistry = publicationRegistry;
        this.configurationActionContainer = configurationActionContainer;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        BasePluginConvention convention = new BasePluginConvention(project);
        project.getConvention().getPlugins().put("base", convention);
        this.configureBuildConfigurationRule(project);
        this.configureUploadRules(project);
        this.configureUploadArchivesTask();
        this.configureArchiveDefaults(project, convention);
        this.configureConfigurations(project);
        this.configureAssemble((ProjectInternal)project);
    }

    private void configureArchiveDefaults(final Project project, final BasePluginConvention pluginConvention) {
        project.getTasks().withType(AbstractArchiveTask.class, new Action<AbstractArchiveTask>(){

            @Override
            public void execute(AbstractArchiveTask task) {
                ConventionMapping taskConventionMapping = task.getConventionMapping();
                Callable<File> destinationDir = task instanceof Jar ? new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return pluginConvention.getLibsDir();
                    }
                } : new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return pluginConvention.getDistsDir();
                    }
                };
                taskConventionMapping.map("destinationDir", destinationDir);
                taskConventionMapping.map("version", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return project.getVersion() == "unspecified" ? null : project.getVersion().toString();
                    }
                });
                taskConventionMapping.map("baseName", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return pluginConvention.getArchivesBaseName();
                    }
                });
            }
        });
    }

    private void configureBuildConfigurationRule(Project project) {
        project.getTasks().addRule(new BuildConfigurationRule(project.getConfigurations(), project.getTasks()));
    }

    private void configureUploadRules(Project project) {
        project.getTasks().addRule(new UploadRule(project));
    }

    private void configureUploadArchivesTask() {
        this.configurationActionContainer.add((Action<? super ProjectInternal>)new Action<Project>(){

            @Override
            public void execute(Project project) {
                boolean hasIvyRepo;
                Upload uploadArchives = (Upload)project.getTasks().withType(Upload.class).findByName(BasePlugin.UPLOAD_ARCHIVES_TASK_NAME);
                if (uploadArchives == null) {
                    return;
                }
                boolean bl = hasIvyRepo = !uploadArchives.getRepositories().withType(IvyArtifactRepository.class).isEmpty();
                if (!hasIvyRepo) {
                    return;
                }
                ConfigurationInternal configuration = (ConfigurationInternal)uploadArchives.getConfiguration();
                Module module = configuration.getModule();
                ModuleVersionIdentifier publicationId = BasePlugin.this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
                BasePlugin.this.publicationRegistry.registerPublication(module.getProjectPath(), new DefaultProjectPublication(publicationId));
            }
        });
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        project.setStatus("integration");
        Configuration archivesConfiguration = ((Configuration)configurations.maybeCreate("archives")).setDescription("Configuration for archive artifacts.");
        ((Configuration)configurations.maybeCreate("default")).setDescription("Configuration for default artifacts.");
        final DefaultArtifactPublicationSet defaultArtifacts = project.getExtensions().create("defaultArtifacts", DefaultArtifactPublicationSet.class, archivesConfiguration.getArtifacts());
        configurations.all(new Action<Configuration>(){

            @Override
            public void execute(Configuration configuration) {
                configuration.getArtifacts().all(new Action<PublishArtifact>(){

                    @Override
                    public void execute(PublishArtifact artifact) {
                        defaultArtifacts.addCandidate(artifact);
                    }
                });
            }
        });
    }

    private void configureAssemble(ProjectInternal project) {
        project.getTasks().getByName(ASSEMBLE_TASK_NAME).dependsOn(project.getConfigurations().getByName("archives").getAllArtifacts().getBuildDependencies());
    }
}

