/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies;

import groovy.lang.Closure;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.dependencies.DependencyReportContainer;
import org.gradle.api.reporting.dependencies.internal.DefaultDependencyReportContainer;
import org.gradle.api.reporting.dependencies.internal.HtmlDependencyReporter;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.ConsoleRenderer;

@Incubating
public class HtmlDependencyReportTask
extends ConventionTask
implements Reporting<DependencyReportContainer> {
    private Set<Project> projects;
    private final DependencyReportContainer reports = this.getObjectFactory().newInstance(DefaultDependencyReportContainer.class, this);

    public HtmlDependencyReportTask() {
        this.reports.getHtml().setEnabled(true);
        this.getOutputs().upToDateWhen((Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                return false;
            }
        });
    }

    @Override
    @Nested
    public DependencyReportContainer getReports() {
        return this.reports;
    }

    @Override
    public DependencyReportContainer reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    @Override
    public DependencyReportContainer reports(Action<? super DependencyReportContainer> configureAction) {
        configureAction.execute(this.reports);
        return this.reports;
    }

    @Inject
    public ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionSelectorScheme getVersionSelectorScheme() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionComparator getVersionComparator() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void generate() {
        if (!this.reports.getHtml().isEnabled()) {
            this.setDidWork(false);
            return;
        }
        HtmlDependencyReporter reporter = new HtmlDependencyReporter(this.getVersionSelectorScheme(), this.getVersionComparator());
        reporter.render(this.getProjects(), this.reports.getHtml().getDestination());
        this.getProject().getLogger().lifecycle("See the report at: {}", new ConsoleRenderer().asClickableFileUrl(this.reports.getHtml().getEntryPoint()));
    }

    @Internal
    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }
}

