/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.compile.AbstractOptions;
import org.gradle.api.tasks.compile.DebugOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.util.DeprecationLogger;

public class CompileOptions
extends AbstractOptions {
    private static final long serialVersionUID = 0L;
    private static final ImmutableSet<String> EXCLUDE_FROM_ANT_PROPERTIES = ImmutableSet.of((Object)"debugOptions", (Object)"forkOptions", (Object)"compilerArgs", (Object)"incremental");
    private boolean failOnError = true;
    private boolean verbose;
    private boolean listFiles;
    private boolean deprecation;
    private boolean warnings = true;
    private String encoding;
    private boolean debug = true;
    private DebugOptions debugOptions = new DebugOptions();
    private boolean fork;
    private ForkOptions forkOptions = new ForkOptions();
    private FileCollection bootstrapClasspath;
    private String extensionDirs;
    private List<String> compilerArgs = Lists.newArrayList();
    private boolean incremental;
    private FileCollection sourcepath;
    private FileCollection annotationProcessorPath;
    private final Property<File> annotationProcessorGeneratedSourcesDirectory;

    @Inject
    public CompileOptions(ObjectFactory objectFactory) {
        this.annotationProcessorGeneratedSourcesDirectory = objectFactory.property(File.class);
    }

    @Input
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Console
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Console
    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    @Console
    public boolean isDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    @Console
    public boolean isWarnings() {
        return this.warnings;
    }

    public void setWarnings(boolean warnings) {
        this.warnings = warnings;
    }

    @Input
    @Optional
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Input
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Nested
    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void setDebugOptions(DebugOptions debugOptions) {
        this.debugOptions = debugOptions;
    }

    @Input
    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void setForkOptions(ForkOptions forkOptions) {
        this.forkOptions = forkOptions;
    }

    @Deprecated
    @Internal
    public String getBootClasspath() {
        DeprecationLogger.nagUserOfReplacedProperty("CompileOptions.bootClasspath", "CompileOptions.bootstrapClasspath");
        return this.bootstrapClasspath == null ? null : this.bootstrapClasspath.getAsPath();
    }

    @Deprecated
    public void setBootClasspath(String bootClasspath) {
        DeprecationLogger.nagUserOfReplacedProperty("CompileOptions.bootClasspath", "CompileOptions.bootstrapClasspath");
        if (bootClasspath == null) {
            this.bootstrapClasspath = null;
        } else {
            String[] paths = StringUtils.split((String)bootClasspath, (char)File.pathSeparatorChar);
            ArrayList files = Lists.newArrayListWithCapacity((int)paths.length);
            for (String path : paths) {
                files.add(new File(path));
            }
            this.bootstrapClasspath = new SimpleFileCollection(files);
        }
    }

    @Optional
    @CompileClasspath
    public FileCollection getBootstrapClasspath() {
        return this.bootstrapClasspath;
    }

    public void setBootstrapClasspath(FileCollection bootstrapClasspath) {
        this.bootstrapClasspath = bootstrapClasspath;
    }

    @Input
    @Optional
    public String getExtensionDirs() {
        return this.extensionDirs;
    }

    public void setExtensionDirs(String extensionDirs) {
        this.extensionDirs = extensionDirs;
    }

    @Input
    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    public void setCompilerArgs(List<String> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    public CompileOptions fork(Map<String, Object> forkArgs) {
        this.fork = true;
        this.forkOptions.define(forkArgs);
        return this;
    }

    public CompileOptions debug(Map<String, Object> debugArgs) {
        this.debug = true;
        this.debugOptions.define(debugArgs);
        return this;
    }

    public CompileOptions setIncremental(boolean incremental) {
        this.incremental = incremental;
        return this;
    }

    @Override
    public Map<String, Object> optionMap() {
        Map<String, Object> map = super.optionMap();
        map.putAll(this.debugOptions.optionMap());
        map.putAll(this.forkOptions.optionMap());
        return map;
    }

    @Override
    protected boolean excludeFromAntProperties(String fieldName) {
        return EXCLUDE_FROM_ANT_PROPERTIES.contains((Object)fieldName);
    }

    @Override
    protected String getAntPropertyName(String fieldName) {
        if (fieldName.equals("warnings")) {
            return "nowarn";
        }
        if (fieldName.equals("extensionDirs")) {
            return "extdirs";
        }
        return fieldName;
    }

    @Override
    protected Object getAntPropertyValue(String fieldName, Object value) {
        if (fieldName.equals("warnings")) {
            return !this.warnings;
        }
        return value;
    }

    @Input
    public boolean isIncremental() {
        return this.incremental;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @Optional
    @Incubating
    public FileCollection getSourcepath() {
        return this.sourcepath;
    }

    @Incubating
    public void setSourcepath(FileCollection sourcepath) {
        this.sourcepath = sourcepath;
    }

    @Optional
    @Incubating
    @Internal
    @Nullable
    public FileCollection getAnnotationProcessorPath() {
        return this.annotationProcessorPath;
    }

    @Incubating
    public void setAnnotationProcessorPath(@Nullable FileCollection annotationProcessorPath) {
        this.annotationProcessorPath = annotationProcessorPath;
    }

    @Optional
    @Nullable
    @Incubating
    @OutputDirectory
    public File getAnnotationProcessorGeneratedSourcesDirectory() {
        return (File)this.annotationProcessorGeneratedSourcesDirectory.getOrNull();
    }

    @Incubating
    public void setAnnotationProcessorGeneratedSourcesDirectory(File file) {
        this.annotationProcessorGeneratedSourcesDirectory.set(file);
    }

    @Incubating
    public void setAnnotationProcessorGeneratedSourcesDirectory(Provider<File> file) {
        this.annotationProcessorGeneratedSourcesDirectory.set(file);
    }
}

