/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import org.gradle.ide.xcode.internal.xcodeproj.PBXProjectItem;
import org.gradle.ide.xcode.internal.xcodeproj.PBXReference;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import org.gradle.internal.impldep.com.dd.plist.NSDictionary;
import org.gradle.internal.impldep.com.dd.plist.NSObject;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;

public class PBXBuildFile
extends PBXProjectItem {
    private final PBXReference fileRef;
    private Optional<NSDictionary> settings;

    public PBXBuildFile(PBXReference fileRef) {
        this.fileRef = (PBXReference)Preconditions.checkNotNull((Object)fileRef);
        this.settings = Optional.absent();
    }

    public PBXReference getFileRef() {
        return this.fileRef;
    }

    public Optional<NSDictionary> getSettings() {
        return this.settings;
    }

    public void setSettings(Optional<NSDictionary> v) {
        this.settings = v;
    }

    @Override
    public String isa() {
        return "PBXBuildFile";
    }

    @Override
    public int stableHash() {
        return this.fileRef.stableHash();
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        s.addField("fileRef", this.fileRef);
        if (this.settings.isPresent()) {
            s.addField("settings", (NSObject)this.settings.get());
        }
    }

    @Override
    public String toString() {
        return String.format("%s fileRef=%s settings=%s", super.toString(), this.fileRef, this.settings);
    }
}

